
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	keyscan.c 	       	                                            **
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq															**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/


#include "common.h"

/************************Key_Scan Variable****************/

KEY_define SDK_KEY;


#define	KEYPRESS_SCAN()			{							\
		if(KEY_PORT0 == 0)	SDK_KEY.KeyCurrent.bits.b0 = 1;	\
		if(KEY_PORT1 == 0)	SDK_KEY.KeyCurrent.bits.b1 = 1;	\
		if(KEY_PORT2 == 0)	SDK_KEY.KeyCurrent.bits.b2 = 1;	\
		if(KEY_PORT3 == 0)	SDK_KEY.KeyCurrent.bits.b3 = 1;	\
		if(KEY_PORT4 == 0)	SDK_KEY.KeyCurrent.bits.b4 = 1;	\
		if(KEY_PORT5 == 0)	SDK_KEY.KeyCurrent.bits.b5 = 1;	\
		if(KEY_PORT6 == 0)	SDK_KEY.KeyCurrent.bits.b6 = 1;	\
		if(KEY_PORT7 == 0)	SDK_KEY.KeyCurrent.bits.b7 = 1;	\
								}
								
							
								

/********************************************************************
Function:	fun_Key_dealwith
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void fun_Key_init(void)
{

}

/********************************************************************
Function:	Key_Scan
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void fun_Key_Scan(void)
{

	SDK_KEY.KeyCurrent.U8 = 0;
	KEYPRESS_SCAN();
	if (SDK_KEY.KeyCurrent.U8 != SDK_KEY.KeyOld) 
	{
		SDK_KEY.KeyNoChangedTime = 0;			
		SDK_KEY.KeyOld = SDK_KEY.KeyCurrent.U8; 
		SDK_KEY.KeyDown.U8 = 0;
		SDK_KEY.KeyUp.U8 = 0;
		return; 
	}
	else
	{
		SDK_KEY.KeyNoChangedTime++;						  
		if (SDK_KEY.KeyNoChangedTime >= LUCC_KEY_DEBOUNCE) //50
		{
			SDK_KEY.KeyNoChangedTime = LUCC_KEY_DEBOUNCE;
			SDK_KEY.KeyPress.U8 = SDK_KEY.KeyOld;																//
			SDK_KEY.KeyDown.U8 = SDK_KEY.KeyPress.U8 & (SDK_KEY.KeyPress.U8 ^ SDK_KEY.KeyLast); //
			SDK_KEY.KeyUp.U8 |= SDK_KEY.KeyLast & (~SDK_KEY.KeyPress.U8);								//
			SDK_KEY.KeyLast = SDK_KEY.KeyPress.U8;															//
		}
	}
//--------------------------------?按--------------------------------------------//
	if (SDK_KEY.KeyPressTime == LUCC_LONG_KEY_TIME)
	{
		if (SDK_KEY.KeyPress.bits.b0)
		{
			
		}
		if (SDK_KEY.KeyPress.bits.b1)
		{
			
		}
		if (SDK_KEY.KeyPress.bits.b2)
		{
			
		}
		if (SDK_KEY.KeyPress.bits.b3)
		{
			
		}

		SDK_KEY.KeyPressTime = LUCC_LONG_KEY_TIME + 1;
	}
//--------------------------------短按--------------------------------------------//
	else if (SDK_KEY.KeyPressTime < LUCC_LONG_KEY_TIME)
	{
//--------------------------------?起--------------------------------------------//		
		if (SDK_KEY.KeyUp.bits.b0)
		{
			
		}
		if (SDK_KEY.KeyUp.bits.b1)
		{
			
		}
		if (SDK_KEY.KeyUp.bits.b2)
		{
			
		}

//--------------------------------按下--------------------------------------------//
		if (SDK_KEY.KeyDown.bits.b0)
		{
			gbv_KeyStatus_1 = 1;
		}
		if (SDK_KEY.KeyDown.bits.b1)
		{
			gbv_KeyStatus_2 = 1;
		}
		if (SDK_KEY.KeyDown.bits.b2)
		{
			gbv_KeyStatus_3 = 1;
		}

	}
	else
	{
		SDK_KEY.KeyPressTime = LUCC_LONG_KEY_TIME + 1; //Key time more than 3 s don't count,b.
															   //because of judge gu8v_KeyPressTime==5
	}
	if (SDK_KEY.KeyDown.U8 != 0)
	{
		SET_HALT_CLEAR();
	}
	if (SDK_KEY.KeyPress.U8)
	{
		SDK_KEY.KeyPressTime++;
	}
	else
	{
		SDK_KEY.KeyPressTime = 0;
	}
	SDK_KEY.KeyUp.U8 = 0;
}

