
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	lcd.h                                      					**
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq													    	**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/


#ifndef _Lcd_H_
#define	_Lcd_H_


// |---------------------------------------------------------------------------------------|
// |  PIN  |  1   |  2   |  3   |  4   |  5   |  6  |  7  |  8  |  9  |  10  |  11  |  12  |               
// |---------------------------------------------------------------------------------------|
// |  COM1 |      |      | 	    | COM1 |  1A  | 1B  |  2A | 2B  | 3A  |  3B  |  4A  |  4B  |
// |---------------------------------------------------------------------------------------|
// |  COM2 |      |		 | COM2 |      |  1F  | 1G  |  2F | 2G  | 3F  |  3G  |	4F  |  4G  |
// |---------------------------------------------------------------------------------------|
// |  COM4 | COM4 |      |      |      |  P1  | 1D  |  P2 | 2D  | P3  |	 3D  |  P4  |  4D  |
// |---------------------------------------------------------------------------------------|
// |  COM3 | 	  |	COM3 |      |      |  1E  | 1C  |  2E | 2C  | 3E  |  3C  |  4E  |  4C  |
// |---------------------------------------------------------------------------------------|
// |  RAM  | 	  |		 |      |      | 0	  | 1	|  2  | 3   | 4   | 5    |  6   |  8   | 
// |---------------------------------------------------------------------------------------|

#define     SEG_A   0
#define     SEG_B   4
#define     SEG_C   6
#define     SEG_D   7
#define     SEG_E   2
#define     SEG_F   1
#define     SEG_G   5
#define     SEG_H   3

#define     a       (1<<SEG_A)
#define     b       (1<<SEG_B)
#define     c       (1<<SEG_C)
#define     d       (1<<SEG_D)
#define     e       (1<<SEG_E)
#define     f       (1<<SEG_F)
#define     g       (1<<SEG_G)
#define     h       (1<<SEG_H)

#define     LCDCODE_0		0
#define     LCDCODE_1		1	
#define     LCDCODE_2		2
#define     LCDCODE_3		3
#define     LCDCODE_4		4
#define     LCDCODE_5		5
#define     LCDCODE_6		6
#define     LCDCODE_7		7
#define     LCDCODE_8		8
#define     LCDCODE_9		9
#define     LCDCODE_A		10	
#define     LCDCODE_B		11
#define     LCDCODE_C		12
#define     LCDCODE_D		13
#define     LCDCODE_E		14
#define     LCDCODE_F		15
#define     LCDCODE_G		16
#define     LCDCODE_H		17
#define     LCDCODE_I		18
#define     LCDCODE_J		19
#define     LCDCODE_K		20
#define     LCDCODE_L		21
#define     LCDCODE_M		22
#define     LCDCODE_N		23
#define     LCDCODE_n		24
#define     LCDCODE_o		25
#define     LCDCODE_O		26
#define     LCDCODE_P		27
#define     LCDCODE_Q		28
#define     LCDCODE_r		29	
#define     LCDCODE_S		30
#define     LCDCODE_t		31
#define     LCDCODE_T		32
#define     LCDCODE_U		33
#define     LCDCODE_v		34
#define     LCDCODE_W		35
#define     LCDCODE_Y		36
#define     LCDCODE_Z		37
#define     LCDCODE__		38
#define     LCDCODE_DOT		39
#define     LCDCODE_NONE	40
#define     LCDCODE_c	    41

#define		LCD_ADDR0       9
#define		LCD_ADDR1       11
#define		LCD_ADDR2       13
#define		LCD_ADDR3       15


//	BH67F2762	LCD pin SET

#define		SET_LCDPIN_SEG0()		_pas11 = 1;_pas10 = 0;
#define		SET_LCDPIN_SEG1()		_pas13 = 1;_pas12 = 1;
#define		SET_LCDPIN_SEG2()		_pas15 = 1;_pas14 = 0;
#define		SET_LCDPIN_SEG3()		_pas17 = 1;_pas16 = 1;
#define		SET_LCDPIN_SEG4()		_pcs01 = 1;_pcs00 = 0;
#define		SET_LCDPIN_SEG5()		_pbs15 = 1;_pbs14 = 0;
#define		SET_LCDPIN_SEG6()		_pbs17 = 0;_pbs16 = 1;
#define		SET_LCDPIN_SEG7()		_pas01 = 1;_pas00 = 0;
#define		SET_LCDPIN_SEG8()		_pas05 = 1;_pas04 = 0;
#define		SET_LCDPIN_SEG9()		_pcs03 = 0;_pcs02 = 1;
#define		SET_LCDPIN_SEG10()		_pas13 = 1;_pas12 = 1;
//  SEG10 - 18 Alway AS LCD Pin
#define		SET_LCDPIN_SEG19()		_pcs05 = 0;_pcs04 = 1;
#define		SET_LCDPIN_SEG20()		_pcs07 = 0;_pcs06 = 1;
#define		SET_LCDPIN_SEG21()		_pcs11 = 0;_pcs10 = 1;
#define		SET_LCDPIN_SEG22()		_pcs13 = 0;_pcs12 = 1;
#define		SET_LCDPIN_SEG23()		_pcs15 = 0;_pcs14 = 1;
#define		SET_LCDPIN_SEG24()		_pcs17 = 0;_pcs16 = 1;
#define		SET_LCDPIN_SEG25()		_pds01 = 0;_pds00 = 1;
#define		SET_LCDPIN_SEG26()		_pds03 = 0;_pds02 = 1;
#define		SET_LCDPIN_SEG27()		_pds05 = 0;_pds04 = 1;
#define		SET_LCDPIN_SEG28()		_pds07 = 0;_pds06 = 1;
#define		SET_LCDPIN_SEG29()		_pds11 = 0;_pds10 = 1;
#define		SET_LCDPIN_SEG30()		_pds13 = 0;_pds12 = 1;
#define		SET_LCDPIN_SEG31()		_pds15 = 0;_pds14 = 1;
#define		SET_LCDPIN_SEG32()		_pds17 = 0;_pds16 = 1;
#define		SET_LCDPIN_SEG33()		_pes01 = 0;_pes00 = 1;
#define		SET_LCDPIN_SEG34()		_pes03 = 0;_pes02 = 1;
//  SEG35 - 37 Alway AS LCD Pin
#define		SET_LCDPIN_SEG38()		_coms01 = 0;
#define		SET_LCDPIN_SEG39()		_coms00 = 0;
// COM 0 - 5
#define		SET_LCDPIN_COM0()		_pes13 = 0;_pes12 = 1;
#define		SET_LCDPIN_COM1()		_pes11 = 0;_pes10 = 1;
#define		SET_LCDPIN_COM2()		_pes07 = 0;_pes06 = 1;
#define		SET_LCDPIN_COM3()		_pes05 = 0;_pes04 = 1;
#define		SET_LCDPIN_COM4()		_coms00 = 0;
#define		SET_LCDPIN_COM5()		_coms01 = 0;

// 

//	|--------------------------------------------------------------------------|
//	|------------------------------〞_lcdc0-------------------------------------|
//	|BIT	|7		|6		|5		|4		|3		|2		|1		|0	   ----|		
//	|--------------------------------------------------------------------------|
//	|Name	|〞		|〞		|〞  	|DTYC	|LCDPR	|-  	|CPVS1	|CPVS0 	---|
//	|--------------------------------------------------------------------------|	  
//  Bit7	TYPE: LCD type control
//      0: Type A
//      1: Type B
//  Bit6 ~ 3	Unimplemented, read as ※0§
//  Bit2 ~ 1	LCDIS1 ~ LCDIS0: LCD Current Selection for R type LCD(VA = PLCD = VDD,1/3bias)
//      00=25uA
//      01=50uA
//      10=100uA
//      11=200uA
//  Bit0	LCDEN: LCD enable control
//      0: Disable
//      1: Enable


#define		SET_LCDC0_TYPE_A()		{	_type  = 0;	}
#define		SET_LCDC0_TYPE_B()		{	_type  = 1;	}
#define		SET_LCDC0_I25()		    {	_lcdis1 = 0;    _lcdis0 = 0;}
#define		SET_LCDC0_I50()		    {	_lcdis1 = 0;    _lcdis0 = 1;}
#define		SET_LCDC0_I100()		{	_lcdis1 = 1;	_lcdis0 = 0;}
#define		SET_LCDC0_I200()		{	_lcdis1 = 1;	_lcdis0 = 1;}
#define		SET_LCDC0_ENABLE()		{	_lcden = 1;}
#define		SET_LCDC0_DISABLE()		{	_lcden = 0;}


//	|--------------------------------------------------------------------------|
//	|------------------------------〞_lcdcp-------------------------------------|
//	|BIT	|7		|6		|5		|4		|3		|2		|1		|0	   ----|		
//	|--------------------------------------------------------------------------|
//	|Name	|〞		|〞		|〞  	|DTYC	|LCDPR	|-  	|CPVS1	|CPVS0 	---|
//	|--------------------------------------------------------------------------|	  
//  Bit7 ~ 5	Unimplemented, read as "0"
//  Bit4	DTYC : Define LCD Duty
//      0: 1/4 Duty(LCD COM: COM0~COM3, the COM4~COM5 can be configured as the other functions)
//      1: 1/6 Duty(LCD COM: COM0~COM5)
//  Bit3	LCDPR: LCD Power selection for R3 type
//      0: PLCD pin
//      1: Internal charge pump
//  Bit2    Unimplemented, read as "0"
//  Bit1 ~ 0	CPVS1 ~ CPVS0: charge pump output voltage selection (R type only)
//  00: 3.3V
//  01: 3.0V
//  10: 2.7V
//  11: 4.5V

#define    SET_LCDCP_DUTY_1C4()     _dtyc   = 0;
#define    SET_LCDCP_DUTY_1C6()     _dtyc   = 1;
#define    SET_LCDCP_POWER_EXT()    _lcdpr  = 0;
#define    SET_LCDCP_POWER_IN()     _lcdpr  = 1;  
#define    SET_LCDCP_POWER_3_3()    _cpvs1  = 0; _cpvs0  = 0;
#define    SET_LCDCP_POWER_3_0()    _cpvs1  = 0; _cpvs0  = 1;
#define    SET_LCDCP_POWER_2_7()    _cpvs1  = 1; _cpvs0  = 0;
#define    SET_LCDCP_POWER_4_5()    _cpvs1  = 1; _cpvs0  = 1;








volatile	static	__8_type  gu8v_LCD_buffer[40] __attribute__ ((at(0x400)));


void	fun_LCD_FULL(u8 lu8v_lcd_data); 
void	fun_LCD_Init();
void 	fun_LCD_NUM(u8 lu8v_lcd_mode,u8 lu8v_addr,u8 lu8v_data);
void 	LCD_DISPLAY_NUM(u8 lu8v_mode,u16 lu8v_DISPLAUDATA);
void 	fun_LCD_UpData();
void    fun_LCD_Display_Cor(u8 lu8v_corr);
void    fun_LCD_Display_Success();
void    fun_LCD_Display_Fail();
void 	fun_LCD_Display____();
void    fun_LCD_Display_C();
void 	fun_LCD_Test();
void 	fun_LCD_Display_Err();
void 	fun_LCD_Display_Lo();
void 	fun_LCD_Display_Hi();

#define SET_LCD_DOT()   gu8v_LCD_buffer[13].bits.b3= 1;
#define CLR_LCD_DOT()   gu8v_LCD_buffer[13].bits.b3 = 0;

#endif
