
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	calculate.h 	       	                                    **
//**	Description	: 																**
//**	MCU      	: 	xx															**
//**	Author   	: 	Ljq													    	**
//**	Date     	: 	2020/03/15													**
//**	Version  	: 	V0002														**
//**	History  	:			 							 						**
/*************************************************************************************/

#ifndef _CALCULATE_H_
#define _CALCULATE_H_

//=========================================校準點設置=======================================//
#define CORRTEMP_LOW    250    //校准点1	(单位：0.1°C)
#define CORRTEMP_HIGH   370    //校准点2	(单位：0.1°C)
//=========================================接口變量=========================================//
extern	volatile	__16_type   gu16v_Correction_K1;        //  校準係數
extern	volatile	__16_type   gu16v_Correction_K2;

//=========================================接口函數=========================================//

/********************************************************************
*	Function:	fun_LibVerSion
*	INPUT	:	none
*	OUTPUT	:	LIBVERSION		>>	庫函數的版本號
*	NOTE	:   
********************************************************************/
u16		fun_LibVerSion();
/********************************************************************
*   Function:	fun_Rntc_Calculate
*   INPUT	:	lu16v_adc_res1		>>	分壓電阻ADC值1
*   			lu16v_adc_res2 		>>	分壓電阻ADC值2
*   OUTPUT	:	lu32v_res_ntc		>>	NTC 阻值(单位：x10 Ω)
*   NOTE	:   電路圖如下:	(取ADC的絕對值)
*   			---  VCM
*   			 |	
*   			---
*   			| |	 NTC
*   			---
*                |   TEMP1 (adc_res1)
*               ---
*               | |  100K
*               ---
*                |   TEMP2 (adc_res2)
*               --- 
*               | |	 300K
*               ---
*                |
*               ---  GND
********************************************************************/
u32		fun_Rntc_Calculate(u16 lu16v_adc_res1,u16 lu16v_adc_res2);

/********************************************************************
*	Function:	fun_Tsen_Calculate
*	INPUT	:	lu32v_res_ntc       >>  NTC的阻值(单位：x10 Ω)
*	OUTPUT	:	ls16v_Tntc_actual   >>  NTC的溫度(单位：0.01°C)
*			:	-10001	:	低于0°C
			:	-10002	:	高于100°C
*	NOTE	:   NTC 對應的溫度
********************************************************************/
s16		fun_Tsen_Calculate(u32 lu32v_res_ntc);

/********************************************************************
*	Function:	fun_Tobj_Calculate
*	INPUT	:	ls16v_temp_ntc		>>  NTC 溫度(单位：0.01°C)
*				ls16v_adc_vtp		>>  VTP ADC值
*	OUTPUT	:	ls16v_Tobj_Result 	>>  物表溫度(单位：0.01°C)
*				返回值	:	-10003	>>	<	0°C
*				返回值	:	-10004	>>	>	100°C
*	NOTE	:   物表溫度計算
********************************************************************/ 
s16		fun_Tobj_Calculate(s16 ls16v_temp_ntc,s16 ls16v_adc_vtp);

/********************************************************************
*   Function:	fun_Corr_Calculate
*   INPUT	:	ls16v_adc_CorrVtp1	>>	第一個校準點的AD值
*   			ls16v_adc_CorrVtp2	>>	第二個校準點的AD值
*   			lu16v_res_ntc		>>	NTC的電阻值		(单位: 10Ω)
*   OUTPUT	:	NONE
*   NOTE	:   通過校準兩個溫度點獲取K1、K2的值
********************************************************************/
void	fun_Corr_Calculate(s16 ls16v_adc_CorrVtp1,s16 ls16v_adc_CorrVtp2,u16 lu16v_res_ntc);

/********************************************************************
*   Function:	fun_ObjTemp_DataHandle
*   INPUT	:	ls16v_ObjTemp		>>	物表溫度	(单位: 0.01°C)	
*   OUTPUT	:	ls16v_ObjTemp_Out	>>	物表溫度	(单位: 0.1°C)
*   NOTE	:   xx.xx °C -- xx.x °C
********************************************************************/
s16		fun_ObjTemp_DataHandle(s16 ls16v_ObjTemp);

/********************************************************************
*	Function:	fun_Temp_Compensate
*	INPUT	:	ls16v_Tsen		>>	環境溫度	(单位: 0.01°C)
*				ls16v_Tobj		>>	物表溫度	(单位: 0.01°C)
*				ls16v_LowComp	>>	低溫補償係數	
*				ls16v_HighComp	>>	高溫補償係數
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
s16		fun_Temp_Compensate(s16 ls16v_Tsen,s16 ls16v_Tobj,s16 ls16v_LowComp,s16 ls16v_HighComp);

/********************************************************************
*	Function:	fun_Temp_SurfaceToBody
*	INPUT	:	ls16v_room		>>	環境溫度	(单位: 1°C)    			
				ls16v_obj		>>	物表溫度	(单位: 0.1°C)
*	OUTPUT	:	lu16v_BodyTemp	>>	人體溫度	(单位: 0.1°C)
*	NOTE	:   
********************************************************************/
s16 	fun_Temp_SurfaceToBody(s16 ls16v_room, s16 ls16v_obj);


#endif

