
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	beep.h                                      				**
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq													    	**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/

#ifndef _BEEP_H_
#define _BEEP_H_

typedef struct
{
	u8			Time;
	u8			Count;
	u8			Mode;
	__8_type 	Status;
}BEEP_define;

#define gbv_BeepSwitch	SDK_BEEP.Status.bits.b0

/********************************************************************
Function:	BEEP GPIO
********************************************************************/

#define		pin_BEEP_IO			_pcc0
#define		pin_BEEP			_pc0

#define 	BEEP_ON()			{_ct0on = 1;}
#define 	BEEP_OFF()			{_ct0on = 0;}
#define		BEEP_HIGH()		    {pin_BEEP = 1;}
#define		BEEP_LOW()		    {pin_BEEP = 0;}
#define		BEEP_1			    1
#define		BEEP_1_1		    2
#define		BEEP_1_1_1		    3
#define		BEEP_1_1_10Time	    4

/********************************************************************
Function:	
********************************************************************/

void fun_BeepScan(void);
void fun_BeepSet(u8	lu8c_beep_mode);
void fun_Beep_Test();

#endif

