
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	work.c 	       	                                       		**
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq															**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/

#include "common.h"

SYS_define	SDK_SYS;
CAL_define	SDK_CAL;

/********************************************************************
Function:	fun_WorkModeScan
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/

void fun_WorkModeScan(void)
{
	switch(SDK_SYS.WorkMode)
	{
		case	WORKMODE_POWERON:
		break;
		case	WORKMODE_WAKEUP:
			if(gbv_KeyStatus_2)
			{
				GOTO_SCAN_MODE();
			}
			
		break;
		case	WORKMODE_SCAN:
		{
		
			if(fun_get_NTC())
			{
				SDK_CAL.RES_Buff.U32 = fun_Rntc_Calculate(SDK_CAL.ADC_Res1.S16,SDK_CAL.ADC_Res2.S16);
				gbv_Flag_GetNTC = 1;
			}
			
			if(gbv_Flag_GetNTC)
			{	
				gbv_Flag_GetNTC = 0;
			
				if(gbv_KeyStatus_2)
				{
					SDK_KEY.KeyStatus.U8 = 0;
					GOTO_MEAS_MODE();
					gbv_Flag_GetNTC = 	0;
				}
				
				if(gbv_KeyStatus_1)
				{		
					SDK_KEY.KeyStatus.U8 = 0;			
					GOTO_CORR_MODE();
					fun_LCD_Display_Cor(0);
				}
			
			}
			
			fun_LCD_Display_C();

			break;
		}
		case	WORKMODE_MEAS:
		{
			if(fun_get_VTP())
			{	
				SDK_CAL.AmbTemp.S16		=	fun_Tsen_Calculate(SDK_CAL.RES_Buff.U32);		
				SDK_CAL.ObjTemp.S16 	= 	fun_Tobj_Calculate(SDK_CAL.AmbTemp.U16,SDK_CAL.ADC_Vtp.S16);
				SDK_CAL.ObjTemp.S16 	= 	fun_Temp_Compensate(SDK_CAL.AmbTemp.U16,SDK_CAL.ObjTemp.U16,LOW_COMP,HIGH_COMP);
				
				if(SDK_CAL.AmbTemp.S16 < 1000 || SDK_CAL.AmbTemp.S16 > 4000)	// 環境溫度小於10°C 或者大於40°C
				{
					fun_LCD_Display_Err();
					fun_BeepSet(BEEP_1_1_1);
				}
				else if(SDK_CAL.ObjTemp.S16<0 || SDK_CAL.ObjTemp.S16> 6000)	// 環境溫度小於0°C 或者大於60°C
				{
					fun_LCD_Display_Err();
					fun_BeepSet(BEEP_1_1_1);					
				}	
				else
				{
					
					SDK_CAL.ObjTemp.S16 	= 	fun_ObjTemp_DataHandle(SDK_CAL.ObjTemp.U16);
					SDK_CAL.BodyTemp.S16	=	fun_Temp_SurfaceToBody(SDK_CAL.AmbTemp.U16/100,SDK_CAL.ObjTemp.U16);
				
					//	修改显示模式
					gbv_Flag_TempMode = TEMP_OBJ_MODE;					
					if(gbv_Flag_TempMode == TEMP_OBJ_MODE)
					{
						LCD_DISPLAY_NUM(0,SDK_CAL.ObjTemp.S16);
						fun_BeepSet(BEEP_1);
					}
					else
					{
				
						if(SDK_CAL.BodyTemp.S16 < 320)
						{
							fun_LCD_Display_Lo();
							fun_BeepSet(BEEP_1_1_1);
						}
						else if(SDK_CAL.BodyTemp.S16 > 430)
						{
							fun_LCD_Display_Hi();
							fun_BeepSet(BEEP_1_1_1);
						}
						else
						{
							LCD_DISPLAY_NUM(0,SDK_CAL.BodyTemp.S16);
							fun_BeepSet(BEEP_1);
						}
					}
					
				}
				GOTO_SCAN_MODE();
								
			}
			else
			{
				fun_LCD_Display____();
			}
		}
		break;		
		case	WORKMODE_CORR:
		{
			fun_CORR_MODE();
			break;		
		}
		
		default:	GOTO_SCAN_MODE();break;		
	}
}

volatile bit 	gbv_Corr_Lock;
volatile u8 	gu8v_CorrMode;
volatile u8 	gu8v_CorrCount;
void	fun_CORR_MODE()
{
	SET_HALT_CLEAR();
	switch(gu8v_CorrMode)
	{
		case	0:
			gu8v_CorrCount++;
			if(gu8v_CorrCount>100)
			{
				gu8v_CorrCount = 0;
				gu8v_CorrMode++;
			}
		break;
		case	1:
		
			if(gbv_Corr_Lock == 0)
			{
				if(fun_get_NTC())//NTC	
				{	
					gbv_Corr_Lock = 1;
					SDK_CAL.RES_Buff.U32 = fun_Rntc_Calculate(SDK_CAL.ADC_Res1.S16,SDK_CAL.ADC_Res2.S16);	
					SDK_CAL.AmbTemp.U16	 = fun_Tsen_Calculate(SDK_CAL.RES_Buff.U32);
				}
			}
			else
			{
				if(gbv_500ms_reversal)
				{
					LCD_DISPLAY_NUM(1,SDK_CAL.AmbTemp.U16);
				}
				else
				{
					fun_LCD_FULL(0);
				}
				if(gbv_KeyStatus_3)
				{
					SDK_KEY.KeyStatus.U8 = 0;				
					gbv_Corr_Lock = 0;
					gu8v_CorrCount = 0;
					fun_LCD_Display_Cor(1);
					gu8v_CorrMode++;
					SDK_SYS.PublicMode = 0;
				}
			}
			break;
		case	2:
			gu8v_CorrCount++;
			if(gu8v_CorrCount>100)
			{
				gu8v_CorrCount = 0;
				gu8v_CorrMode++;
			}
		break;
		case	3:
		
			if(fun_get_VTP_CORR())	
			{	
				LCD_DISPLAY_NUM(1,SDK_CAL.ADC_Vtp.S16);
			}
			if(gbv_KeyStatus_3)
			{
				SDK_KEY.KeyStatus.U8 = 0;	
				gu8v_CorrMode++;		
				SDK_CAL.VTP_Buff1.S16 = SDK_CAL.ADC_Vtp.S16;
				fun_LCD_Display_Cor(2);
					SDK_SYS.PublicMode = 0;
			}
		break;
		case	4:
			gu8v_CorrCount++;
			if(gu8v_CorrCount>100)
			{
				gu8v_CorrCount = 0;
				gu8v_CorrMode++;
			}
		break;
		case	5:
			if(fun_get_VTP_CORR())	
			{	
				LCD_DISPLAY_NUM(1,SDK_CAL.ADC_Vtp.S16);	
			}	
			if(gbv_KeyStatus_3)
			{
				SDK_KEY.KeyStatus.U8 = 0;	
				gu8v_CorrMode++;		
				SDK_CAL.VTP_Buff2.S16 = SDK_CAL.ADC_Vtp.S16;
				SDK_SYS.PublicMode = 0;
				
			}
		break;
		case	6:
		{
			fun_Corr_Calculate(SDK_CAL.VTP_Buff1.S16,SDK_CAL.VTP_Buff2.S16,SDK_CAL.RES_Buff.U32);					

				
			if(gu16v_Correction_K2.U16>9500&&gu16v_Correction_K2.U16<10500)	
			{
				fun_EEprom_Write(0,0x55);			
				fun_EEprom_Write(1,gu16v_Correction_K1.byte.byte0);
				fun_EEprom_Write(2,gu16v_Correction_K1.byte.byte1);
				fun_EEprom_Write(3,gu16v_Correction_K2.byte.byte0);
				fun_EEprom_Write(4,gu16v_Correction_K2.byte.byte1);
				fun_LCD_Display_Success();	
			}
			else
			{
				fun_LCD_Display_Fail();
			}
				gu8v_CorrMode++;
			break;	
		}
		case 	7:
			if(gbv_KeyStatus_3)
			{
				SDK_KEY.KeyStatus.U8 = 0;
				SET_HALT_SLEEP();
				fun_LCD_FULL(0);
				gbv_Flag_GetNTC	= 0;
				gu8v_CorrMode = 0;
			}
			
		break;

		default: break;
	}
	
}


u8 fun_get_NTC()
{
	switch(SDK_SYS.PublicMode)
	{
		case 0:
		{	
			fun_TEMP1_INIT();
			SDK_SYS.PublicMode++;
			break;
		}
		case 1:
		{
			if(gbv_adc_Success)
			{	
				SDK_CAL.ADC_Res1.S16 = SDK_ADC.AdcData.S32;	
				
				fun_TEMP2_INIT();
				SDK_SYS.PublicMode ++;	
			}
			break;
		}
		case 2:
		{
			if(gbv_adc_Success)
			{	
				SDK_CAL.ADC_Res2.S16 = SDK_ADC.AdcData.S32;	

			
				fun_VTP_INIT();
				SET_OPA_ZERO();
			
				SDK_SYS.PublicMode ++;	
			}
			break;
		}	
		case 3: 
		{
			if(gbv_adc_Success)
			{	
				SDK_CAL.ADC_VtpZero.S16 = SDK_ADC.AdcData.S32;			
				
				fun_BAT_INIT();
				SDK_SYS.PublicMode ++;
			}
		}
		break;
		case 4:
			if(gbv_adc_Success)
			{	
				//	电池电压量测
				
				SDK_CAL.BAT_Buff.S16 = SDK_ADC.AdcData.S32;			
				SDK_SYS.PublicMode = 0;
			}
				
				
					return	1;
		break;
			
		default:break;
	}	
	return 0;
}


u8	fun_get_VTP()
{
	switch(SDK_SYS.PublicMode)
	{
		case	0:
		{
			fun_VTP_INIT();
			SET_OPA_VTP();		
			SDK_SYS.PublicMode ++;					
			break;
		}
		case	1:
		if(gbv_adc_Success)
		{	
			SDK_SYS.PublicMode 	= 0;
			SDK_CAL.ADC_Vtp.S16 	= SDK_ADC.AdcData.S32 - SDK_CAL.ADC_VtpZero.S16;

			return 1;	
		}
	}
	return	0;
}



u8	fun_get_VTP_CORR()
{
	switch(SDK_SYS.PublicMode)
	{
		case	0:
		{
			fun_VTP_INIT();
			SET_OPA_ZERO();		
			SDK_SYS.PublicMode ++;					
			break;
		}
		case	1:
		if(gbv_adc_Success)
		{	

			SDK_CAL.ADC_VtpZero.S16 = SDK_ADC.AdcData.S32;

			SET_OPA_VTP();				
			fun_VTP_INIT();
			SDK_SYS.PublicMode ++;	
			break;	
		}
		case	2:
		if(gbv_adc_Success)
		{
			SDK_SYS.PublicMode = 0;	
			SDK_CAL.ADC_Vtp.S16 = SDK_ADC.AdcData.S32  - SDK_CAL.ADC_VtpZero.S16;
			return 1; 	
		}
		break;	
		default: break;	
	}
	return	0;
}

