
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	uart.c 	       	                                            **
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq															**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/

#include "common.h"

UART_define SDK_UART;


/********************************************************************
Function:	fun_Uart_Init
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void fun_Uart_Init(void)
{
	
	_pas17	= 1;
	_pas16	= 0;
	_pas15  = 0;
	_pas14  = 1;
	
	SET_USIM_UART();	
	SET_UART_ENABLE();
	SET_UART_DATARATE();
	SET_UART_HIGHSPEED();
	SET_UART_SEND_ENABLE();	
	SET_UART_RECE_ENABLE();
		
	_rie = 1;				//接收中斷使能
    _usime=1;
    
	_emi	=	1;
   
}

/**************************************************************
 * 	UBRGH = 0 : baud rate = Fh /(64 * (N+1))
 *	UBRGH = 1 : baud rate = Fh /(16 * (N+1))
 *	eg. baud rate = 4m/(16 * (25 + 1)) =  9615 bit/s ?等于9600
 * **************************************************************/



/********************************************************************
Function:	fun_Uart_Off
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void fun_Uart_Off(void)
{
	SET_UART_SEND_DISABLE();	
	SET_UART_RECE_DISABLE();
	SET_UART_DISABLE();		
}
/***********************************************************
**   Function : fun_Uart_SendByte
**   INPUT    : data
**   OUTPUT   : none
**   NOTE     : 
**			
***********************************************************/
volatile	u8 lu8v_Uart_temp;
void fun_Uart_SendByte(u8 lu8v_uart_data)
{

	lu8v_Uart_temp = _usr;
	_txr_rxr = lu8v_uart_data;  
	while(!_tidle);							
}


/********************************************************************
Function:	fun_Uart_Test
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void fun_Uart_Test(void)
{

	fun_Uart_Init();
	while(1)
	{
		GCC_CLRWDT();
		fun_Uart_SendByte(0x55);
		GCC_DELAY(10000);
	}
	
		
}
/********************************************************************
Function:	fun_Uart_ISR
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/

volatile	u8	array_uart_rxbuff[10];
volatile	u8	array_uart_txbuff[10];
volatile	bit	gbv_rx_success;
volatile	u8	gu8v_tx_guide;
volatile 	u8	lu8v_isr_temp0;
void __attribute((interrupt(0x28)))  fun_Uart_ISR()
{
	volatile u8	lu8v_isr_temp0;
								//clear urf flag
   	if(_perr && _nf && _ferr && _oerr)		// error found?
   	{
   	   lu8v_isr_temp0 = _usr;				//read USR to clear error flag    
   	   lu8v_isr_temp0 = _txr_rxr;
   	}
   	else									// no error found
   	{
   	   if(_rxif)							//RXR	data register has available	data
   	   {
   	   		_rxif = 0;
			for(lu8v_isr_temp0 = 0;lu8v_isr_temp0<4;lu8v_isr_temp0++)
			{
				array_uart_rxbuff[lu8v_isr_temp0] = array_uart_rxbuff[lu8v_isr_temp0+1];		
			}
			array_uart_rxbuff[4] = _txr_rxr; 
			if(array_uart_rxbuff[0]==0x55&&array_uart_rxbuff[4]==(u8)(array_uart_rxbuff[0]+array_uart_rxbuff[1]+array_uart_rxbuff[2]+array_uart_rxbuff[3]))
			{
				gbv_rx_success = 1;
			}	   	   	  
   	   		GCC_NOP();

   	   }

   	}	
	

}
void __attribute((interrupt(0x08)))  fun_INT0_ISR()
{

GCC_NOP();
_int0f=1;
GCC_NOP();
}