
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	Sysinit.c      	                                   			**
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq													    	**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/

#include "common.h"


/********************************************************************
*	Function:	fun_Sys_Init
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void	fun_Sys_Init()
{

// disable cpc
//	_cp0c 	= 0;
//	_cp1c	= 0;
//	|--------------------------------------------------------------------------|
//	|-----------------------------SMOD-----------------------------------------|
//	|BIT	|7		|6		|5		|4		|3		|2		|1		|0	   ----|		
//	---------------------------------------------------------------------------|
//	|Name	|CKS2	|CKS1	|CKS0	|FSTEN	|LTO	|HTO	|IDLEN	|HLCLK ----|
//	---------------------------------------------------------------------------|
//	|POR 	|0 		|0 		|0 		|0		|0 		|0 		|1 		|1	   ----|
//	---------------------------------------------------------------------------|
//	CKS2	CKS1	CKS1
//	0		0		0		: fSUB
//	0		0		1		: fSUB
//	0		1		0		: fH/64
//	0		1		1		: fH/32
//	1		0		0		: fH/38
//	1		0		1		: fH/8
//	1		1		0		: fH/4
//	1		1		1		: fH/2
//	NOTE:	fH
	_scc = 0b00000011;


//	|--------------------------------------------------------------------------|
//	|-----------------------------WDTC-----------------------------------------|
//	|BIT	|7		|6		|5		|4		|3		|2		|1		|0	   ----|		
//	---------------------------------------------------------------------------|
//	|Name	|CKS2	|CKS1	|CKS0	|FSTEN	|LTO	|HTO	|IDLEN	|HLCLK ----|
//	---------------------------------------------------------------------------|
//	|POR 	|0 		|0 		|0 		|0		|0 		|0 		|1 		|1	   ----|
//	---------------------------------------------------------------------------|
//	Bit 7~3 WE4~WE0: WDT enable
//		10101: disable
//		01010: enable (default)
//	Bit 2~0 WS2~WS0: select WDT timeout period
//		000: 2^8/fS
//		001: 2^10/fS
//		010: 2^12/fS
//		011: 2^14/fS (default)
//		100: 2^15/fS
//		101: 2^38/fS
//		110: 2^17/fS
//		111: 2^18/fS
	_wdtc = 0b01010111;

//------------------------
//	pa 
//	pa0		-->  ICPDA
//	pa1		-->  SEG
//	pa2		-->  ICPCK
//  pa3	  	-->	 SEG
//	pa4		-->  BEEP
//	pa5		-->  
//	pa6		-->  KEY
//	pa7		-->  KEY 
//------------------------
	_pa		= 0b11001010;	
	_pac 	= 0b11001010;
	_papu 	= 0b11001010;
	_pawu	= 0b00001010;
//------------------------
//	pb
//	pb0 	--> KEY
//	pb1		--> xx
//	pb2		--> AN5
//	pb3		--> AN5
//	pb4		--> xx
//	pb5		--> AN5
//	pb6		--> AN6
//	pb7		--> xx
//------------------------
	_pb		= 0b10000001;	
	_pbc 	= 0b10000001;
	_pbpu 	= 0b10000001;
////------------------------
////	pc
////	pc0~pc4	--> SEG
////------------------------
//
	_pcc 	= 0b00000000;
	_pc	    = 0b00000000;
	_pcpu 	= 0b00000000;



//------------------------
//	pa3 -->	SEG 
//	pa2 --> IO
//	pa1 --> SEG
//	pa0 --> IO
//------------------------
	_pas0	=	0;
	
	
//------------------------
//	pa7 -->	IO 
//	pa6 --> SEG
//	pa5 --> IO
//	pa4 --> CTPB
//------------------------
	_pas1	=	0;
	
//------------------------
//	pb3 -->	COM3 
//	pb2 --> COM2
//	pb1 --> COM1
//	pb0 --> COM0
//------------------------
	_pbs0	=	0;
	
//------------------------
//	pb7 -->	IO 
//	pb6 --> AN6
//	pb5 --> AN5
//	pb4 --> IO
//------------------------
	_pbs1	=	0b00001010;		
    _pcs0=0b00000001;
	

	
	SDK_SYS.WorkMode = WORKMODE_SCAN;
	
}
/********************************************************************
*	Function:	fun_Reset_Init
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void	fun_Reset_Init()
{
	fun_TimeInit();
	fun_EEPROM_Init();
	fun_LCD_Init();
	
}
/********************************************************************
*	Function:	fun_SysSleep
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void	fun_SysSleep()
{
	fun_LCD_FULL(0);
	_lcden = 0;
//	SET_CTM_OFF();
	SET_TB0_OFF();
	fun_ADC_Disable();
	_emi=1;	
	_pbc2=1;
	_pbpu2=1;
	_int1s1=1;	//下降沿中斷
	_int1e=0;
//	_int1f=0;
	
	
	
	GCC_HALT();
	
	SET_HALT_WAKEUP();
	
	_int1e=1;
	
	fun_Reset_Init();
	SDK_SYS.WorkMode = WORKMODE_WAKEUP;
	gbv_Flag_GetNTC = 0;
}

