
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	main.c 	       	                                            **
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq															**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/
#include "common.h"

/********************************************************************
Function:	main
INPUT	:
OUTPUT	:	
NOTE	:   程序入口
********************************************************************/

void main()
{
	//判斷是否是上電復位或者是正常情況下的非正常復位
	//如果成立則執行上電初始化動作，反之則執行WDT溢出初始化
	if(_to ==0 || _pdf ==0)									// WDT	Reset
	{	//上電復位或者是正常情況下的非正常復位
		fun_Ram_CLear();									// CLR  RAM 		
		fun_Sys_Init();
	
	//	設置 SysClock 8Mhz 
		_hirc1 = 0;
		_hirc0 = 1;
		_hircen = 1;
		while(!_hircf);
		
		fun_Reset_Init();		
	}
	else							 						
	{	//WDT 溢出復位
		fun_Reset_Init();
	}
	fun_Test_Function();
	
	while(1)
	{
	    //   清除看門狗	 		
		GCC_CLRWDT();	
	    //   工作循環
	    //SDK_TM.HaltTime=HALT_TIME+1;		
		if(SDK_TM.HaltTime < HALT_TIME)		
		{
			if(_tb0f)	        //	8ms
			{
				_tb0f = 0;
				
				fun_SysTimeScan();
				fun_WorkModeScan();
				fun_Key_Scan();				
				fun_BeepScan();
				//   清除標誌位 ，在工作流程控制可使用gbv_500ms，由此地方統一清除
				gbv_500ms = 0;
			}
	        //	ADC 輪詢掃描
			fun_ADC_Polling();
		}
	    //	休眠模式
		else	
		{		
			fun_SysSleep();
		}		
	}			
	
}




/********************************************************************
Function:	fun_Test_Function
INPUT	:
OUTPUT	:	
NOTE	:   功能測試
********************************************************************/
void	fun_Test_Function()
{	
	#if(TEST_MODE == TEST_LCD)
	fun_LCD_Test();
	#endif
	#if(TEST_MODE == TEST_BEEP)
	fun_Beep_Test();
	#endif
	#if(TEST_MODE == TEST_PERI)
	fun_Peripherals_Test();
	#endif
	#if(TEST_MODE == TEST_UART)
	fun_Uart_Test();
	#endif
	#if(TEST_MODE == TEST_NTC)
	fun_ADC_NTC_Test();
	#endif
	#if(TEST_MODE == TEST_OPAZERO)
	fun_ADC_OPA_ZeroTest();
	#endif
	#if(TEST_MODE == TEST_OPAVTP)
	fun_ADC_OPA_VTPTest();
	#endif
}


