
/*************************************************************************************/
//**	Copyright	:	2020 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	adc.c 	       	                                            **
//**	Description	: 																**
//**	MCU      	: 	BH67F2762													**
//**	Author   	: 	Ljq															**
//**	Date     	: 	2020/03/16													**
//**	Version  	: 	V02															**
//**	History  	:																**
/*************************************************************************************/

#include "common.h"

ADC_define	SDK_ADC;

/********************************************************************
*	Function:	fun_VTP_INIT
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_VTP_INIT()
{
	SET_PGA_x64();
	SET_AGS_1();
	SET_VTP_CHANNAL();
	SET_ADC_SPEED_20HZ();
	fun_ADC_Power_Enable();
	fun_ADC_Enable();
}

/********************************************************************
*	Function:	fun_TEMP1_INIT
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_TEMP1_INIT()
{
	SET_PGA_x1();
	SET_AGS_1();
	SET_TEMP1_CHANNAL();
	SET_ADC_SPEED_80HZ();
	fun_ADC_Power_Enable();
	fun_ADC_Enable();	
}

/********************************************************************
*	Function:	fun_TEMP2_INIT
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_TEMP2_INIT()
{
	SET_PGA_x1();
	SET_AGS_1();
	SET_TEMP2_CHANNAL();	
	SET_ADC_SPEED_80HZ();
	fun_ADC_Power_Enable();
	fun_ADC_Enable();	
}

/********************************************************************
*	Function:	fun_BAT_INIT
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_BAT_INIT()
{
	SET_PGA_x1();
	SET_AGS_1();
	SET_BAT_CHANNAL();	
	SET_ADC_SPEED_80HZ();
	fun_ADC_Power_Enable();
	fun_ADC_Enable();	
}

/********************************************************************
*	Function:	fun_ADC_Power_Enable
*	INPUT	:
*	OUTPUT	:
*	NOTE	:  	
********************************************************************/
void fun_ADC_Power_Enable()
{

	SET_AVDD_2_4();  
	//以下參數在後續應用中不會變化所以在此進行設置
	SET_VGS_0();
	SET_ADC_FMCLOCK_C2();
	SET_LDO_OPEN();

}

/********************************************************************
*	Function:	fun_ADC_Power_Disable
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_ADC_Power_Disable()
{
	SET_LDO_CLOSE();
}

/********************************************************************
*	Function:	fun_ADC_Enable
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_ADC_Enable()
{
	SDK_ADC.SampleCount = 0;
	gbv_adc_SampleMode = 0;
	gbv_adc_Success = 0;	
	SET_ADC_OPEN();
	SET_ADC_NORMAL();
	SET_ADRST_DISABLE();
	SET_ADRST_ENABLE();
	SET_ADRST_DISABLE();
	SET_ADCEOC_CLEAR();
}

/********************************************************************
*	Function:	fun_ADC_Disable
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_ADC_Disable()
{
	SDK_ADC.SampleCount = 0;
	gbv_adc_SampleMode = 0;
	SET_ADC_SLEEP();
	SET_ADRST_DISABLE();
	SET_ADC_CLOSE();
	fun_ADC_Power_Disable();	
}

/********************************************************************
*	Function:	fun_ADC_Polling
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   獲取六筆數據，除去最大最小值求平均
********************************************************************/
void fun_filter_adc()
{	
	u8 i;
	s32 ls32v_adc_result = 0;
	s16 ls16v_adc_max;
	s16 ls16v_adc_min;
	
	ls16v_adc_max = SDK_ADC.AdcBuff[0];
	ls16v_adc_min = SDK_ADC.AdcBuff[0];
	
	for(i=0;i<10;i++)
	{
		ls32v_adc_result += SDK_ADC.AdcBuff[i];
		ls16v_adc_max = (ls16v_adc_max > SDK_ADC.AdcBuff[i]) ?  ls16v_adc_max : SDK_ADC.AdcBuff[i] ; 
		ls16v_adc_min = (ls16v_adc_min < SDK_ADC.AdcBuff[i]) ?  ls16v_adc_min : SDK_ADC.AdcBuff[i] ; 
	}
		
	SDK_ADC.AdcData.S32 = (ls32v_adc_result - ls16v_adc_min - ls16v_adc_max) >> 3;
}

/********************************************************************
*	Function:	fun_ADC_Polling
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_ADC_Polling()
{

	if(_eoc!=0)
	{
		//鎖存數據
		SET_ADCLATCH_ENABLE();
		//將數據轉換為32bit 的有符號數據
		SDK_ADC.AdcData.U32 = 0;
		SDK_ADC.AdcData.byte.byte0	= _adrl;
		SDK_ADC.AdcData.byte.byte1	= _adrm;				
		SDK_ADC.AdcData.byte.byte2	= _adrh;
		if(SDK_ADC.AdcData.bits.b23)
		{
			SDK_ADC.AdcData.byte.byte3 = 0xff;
		}

		SDK_ADC.AdcData.S32 >>= 8;		
		SET_ADCLATCH_DISABLE();
		SET_ADCEOC_CLEAR();

		//採樣計數
		SDK_ADC.SampleCount++;
		if(gbv_adc_SampleMode==0)
		{
			//丟棄前三筆數據
			if(SDK_ADC.SampleCount>3)
			{
				SDK_ADC.SampleCount=0;
				gbv_adc_SampleMode = 1;
			}
		}
		else if(gbv_adc_SampleMode==1)
		{			
			SDK_ADC.AdcBuff[SDK_ADC.SampleCount-1] = SDK_ADC.AdcData.S32;
			if(SDK_ADC.SampleCount>=10)
			{

				fun_filter_adc();
				gbv_adc_Success		= 1;
				SDK_ADC.SampleCount = 0;
				gbv_adc_SampleMode 	= 0;

			}
//			SDK_ADC.SampleCount = 0;
//			gbv_adc_SampleMode 	= 0;
//			gbv_adc_Success		= 1;	
		}	 
	}		
}

/********************************************************************
*	Function:	fun_ADC_NTC_Test
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_ADC_NTC_Test()
{
	fun_TEMP2_INIT();
	while(1)
	{
		GCC_CLRWDT();//清除看門狗	
		fun_ADC_Polling();
	}
}

/********************************************************************
*	Function:	fun_ADC_OPA_ZeroTest
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_ADC_OPA_ZeroTest()
{
	fun_VTP_INIT();
	SET_OPA_ZERO();
	while(1)
	{
		GCC_CLRWDT();//清除看門狗	
		fun_ADC_Polling();	
	}
}
/********************************************************************
*	Function:	fun_ADC_OPA_VTPTest
*	INPUT	:
*	OUTPUT	:	
*	NOTE	:   
********************************************************************/
void fun_ADC_OPA_VTPTest()
{
	fun_VTP_INIT();
	SET_OPA_VTP();
	while(1)
	{
		GCC_CLRWDT();//清除看門狗	
		fun_ADC_Polling();
	}
}
