/**
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include <stdint.h>
#include "BH67F2495.h"
#include "..\..\..\driver\Ram.h"
#include "..\..\..\driver\wdt.h"
#include "..\..\..\driver\Oscillators.h"
#include "..\..\..\driver\Adc24.h"
#include "..\..\..\driver\Uart.h"
#include "..\..\..\application\Bia.h"

volatile uint8_t uart0QueueBuf[20];    // 中断使用需要加 volatile
volatile uint8_t txBuf[20];
Bia_t bia;

void Adc_Cnt_Reset()
{
    adc24SourceData.samplingCnt = 0;
}

void main()
{
    // 判斷是否為上電復位或者非正常情況下的復位, 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
    if (_to == 0 || _pdf == 0)
    {
        // config sys clock
        Ram_Clear();
        // config Oscillators
        Oscillators_Cfg();
        // config uart
        uart0Status.rxBuf    = uart0QueueBuf;            // 傳入緩存Buf地址
        uart0Status.rxBufLen = sizeof(uart0QueueBuf);    // 傳入緩存Buf長度
        Uart_Cfg_t uartCfg;
        uartCfg.flag.b.addr   = false;
        uartCfg.flag.b.wakeUp = true;
        Uart0_Cfg(&uartCfg);
        Uart0_Enable();
        Uart0_Isr_Enable();
        // 阻抗量測開始
        bia.sineWaveFreq = SINE_WAVE_FREQ_50KHZ;
        Bia_Enable(&bia);
        // enable emi
        _emi = 1;
    }
    else
    {
        // WDT溢出復位初始化
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
        Adc24_Poling();
        if (adc24SourceData.flag.b.isReady)
        {
            adc24SourceData.flag.b.isReady = 0;
            Bia_Loop(&adc24SourceData.data.adcData, &bia);
        }
        if (bia.status == BIA_SUCCESS)
        {
#if BIA_PHASE_FUNCTION
            // impedance measurement is successful read impedance
            uint8_t txChar[] = "measure success:F=50Khz,Impedance=    ,Phase=      \r\n";
            Int32ToString(bia.impedance, &txChar[34]);
            Int32ToString(bia.phase, &txChar[45]);
            Uart0_TxByte_Interrupt(txChar, sizeof(txChar));
#else
            // impedance measurement is successful read impedance
            uint8_t txChar[] = "measure success:F=50Khz,Impedance=      \n";
            Int32ToString(bia.impedance, &txChar[34]);
            Uart0_TxByte_Interrupt(txChar, sizeof(txChar));
#endif
            Bia_Enable(&bia);
        }
        else if (bia.status == BIA_CHECK_ELECTRODE && bia.electrodeStatus != 0x00)
        {
            // remind user to connect electrodes
            uint8_t txChar[] = "check electrode\n";
            Uart0_TxByte_Interrupt(txChar, sizeof(txChar));
        }
        else if (bia.status == BIA_ERROR_RANGER)
        {
            // check impedance ranger
            uint8_t txChar[] = "error ranger\n";
            Uart0_TxByte_Interrupt(txChar, sizeof(txChar));
            Bia_Enable(&bia);
        }
        else if (bia.status == BIA_ERROR_REPEAT)
        {
            // Remind users to remain stable
            uint8_t txChar[] = "error repeat,keep stable\n";
            Uart0_TxByte_Interrupt(txChar, sizeof(txChar));
            Bia_Enable(&bia);
        }
        else
        {
        }
    }
}