/**
 * *************************************************************************************************************
 * @file wdt.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for wdt firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0
 * # 主要功能
 *     * WdtCfg配置看門口溢出時間
 *     * WdtEnable WDT Enable
 *     * WdtDisable WDT Disable
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _WDT_H_
#define _WDT_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <BH67F2495.h>

/* Exported types ------------------------------------------------------------------------------------------*/
/*! WDT time out period selection enum */
typedef enum {
    WDT_TIME_8MS,
    WDT_TIME_32MS,
    WDT_TIME_125MS,
    WDT_TIME_500MS,    //!< default
    WDT_TIME_1000MS,
    WDT_TIME_2000MS,
    WDT_TIME_4000MS,
    WDT_TIME_8000MS,
} Wdt_Time_e;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
/**
 * @brief WDT time out period configuration
 * WDT clock Source fs =fsub
 * @param type @see Wdt_Time_e
 */
#define Wdt_Enable(type) { _wdtc = (0x50+type);}
#define Wdt_Disable()    { _wdtc = 0xA8;}
// clang-format on

#endif