/**
 * *************************************************************************************************************
 * @file Uart.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Uart firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.1
 * * Uart 初始化配置函數
 * * Uart 使能和除能
 * * Uart 發送16進制buf (使用中断的方式)
 * * Uart 發送char 字符串 (使用中断的方式)
 * * Uart 接收 (使用中断的方式)
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _UART_H_
#define _UART_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH67F2495.h"

/* Exported types ----------------------------------------------------------------------------------------*/
/**
 * @brief Uart cfg structure definition
 *
 */
typedef struct {
    union {
        struct
        {
            uint8_t addr   : 1;
            uint8_t wakeUp : 1;
        } b;

        uint8_t byte;
    } flag;
} Uart_Cfg_t;

/**
 * @brief Uart cfg structure definition
 *
 */
typedef struct {
    volatile uint8_t *txOffset;
    volatile uint8_t txLen;

    union {
        struct {
            uint8_t isBusy      : 1;
            uint8_t queueIsFull : 1;
        } b;

        uint8_t byte;
    } flag;

    volatile uint8_t rxBufLen;
    volatile uint8_t *rxBuf;
    volatile bool IsBusy;
} Uart_Status_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void Uart0_Cfg(const Uart_Cfg_t *cfg_t);
#define Uart0_Enable()      { _uarten0 = 1; _txen0 = 1; _rxen0 = 1;}
#define Uart0_Disable()     { _uarten0 = 0;}
#define Uart0_Isr_Enable()  { _ur0e = 1;}
#define Uart0_Isr_Disable() { _ur0e = 0;}

extern volatile Uart_Status_t uart0Status;
bool Uart0_TxByte_Interrupt(volatile uint8_t *buf, uint8_t len);
void Uart0_TxByte_Polling(uint8_t *byte, uint8_t len);
bool Uart0_IsAvailable_ReadByte(uint8_t * byte);

void Uart1_Cfg(const Uart_Cfg_t *cfg_t);
#define Uart1_Enable()      { _uarten1 = 1; _txen1 = 1; _rxen1 = 1;}
#define Uart1_Disable()     { _uarten1 = 0;}
#define Uart1_Isr_Enable()  { _ur1e = 1;}
#define Uart1_Isr_Disable() { _ur1e = 0;}

extern volatile Uart_Status_t uart1Status;
bool Uart1_TxByte_Interrupt(volatile uint8_t *buf, uint8_t len);
void Uart1_TxByte_Polling(uint8_t *byte, uint8_t len);
bool Uart1_IsAvailable_ReadByte(uint8_t * byte);

void Int32ToString(int32_t num, uint8_t *str);
// clang-format on

#endif