/**
 * *************************************************************************************************************
 * @file Uart.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Uart firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.2
 * * Uart 初始化配置函數
 * * Uart 使能和除能
 * * Uart 發送16進制buf (使用中断的方式)
 * * Uart 發送char 字符串 (使用中断的方式)
 * * Uart 接收 (使用中断的方式)
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#include "Uart.h"
#include "..\board\BoardCfg.h"
#ifdef SUPPORT_ISP
    #include "..\application\Iap_Isp.h"
#endif

#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 12000000    //!< 設置系統頻率，目前支援設置為12000000
#endif
#ifndef UART0_BAUD_RATE
    #define UART0_BAUD_RATE 9600    //!< 300,600,1200,2400,4800,9600,14400,19200,38400,57600,115200,230400,250000
#endif
#ifndef UART1_BAUD_RATE
    #define UART1_BAUD_RATE 9600    //!< 300,600,1200,2400,4800,9600,14400,19200,38400,57600,115200,230400,250000
#endif  

// clang-format off

#if (SYS_CLOCK_FREQ == 8000000)
    #define UART_CLOCK_FREQ 16000000
#else
    #define UART_CLOCK_FREQ  SYS_CLOCK_FREQ
#endif  

#define SET_UARTn_TX_INTERRUPT_DISABLE(n)   { _tiie##n = 0; _teie##n = 0;}
#define SET_UARTn_TX_INTERRUPT_ENABLE(n)    { _tiie##n = 1; _teie##n = 1;}
#define SET_UARTn_Format_D8_NONE_S1(n)      { _u##n##cr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_EVEN_S1(n)      { _u##n##cr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_ODD_S1(n)       { _u##n##cr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D9_NONE_S1(n)      { _u##n##cr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_EVEN_S1(n)      { _u##n##cr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_ODD_S1(n)       { _u##n##cr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)1bit-Stop
#define SET_UARTn_Format_D8_NONE_S2(n)      { _u##n##cr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_EVEN_S2(n)      { _u##n##cr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_ODD_S2(n)       { _u##n##cr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D9_NONE_S2(n)      { _u##n##cr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_EVEN_S2(n)      { _u##n##cr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_ODD_S2(n)       { _u##n##cr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)2bit-Stop

#if UART_CLOCK_FREQ == 4000000
    #define SET_UARTn_BAUDRATE_300(n)       { _ufcr##n = 0x18; _brdl##n = 0x15; _brdh##n = 0x34;}
    #define SET_UARTn_BAUDRATE_600(n)       { _ufcr##n = 0x28; _brdl##n = 0x0A; _brdh##n = 0x1A;}
    #define SET_UARTn_BAUDRATE_1200(n)      { _ufcr##n = 0x18; _brdl##n = 0x05; _brdh##n = 0x0D;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _ufcr##n = 0x28; _brdl##n = 0x82; _brdh##n = 0x06;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _ufcr##n = 0x18; _brdl##n = 0x41; _brdh##n = 0x03;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _ufcr##n = 0x28; _brdl##n = 0xA0; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_14400(n)     { _ufcr##n = 0x30; _brdl##n = 0x15; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _ufcr##n = 0x18; _brdl##n = 0xD0; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_28800(n)     { _ufcr##n = 0x38; _brdl##n = 0x8A; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_38400(n)     { _ufcr##n = 0x08; _brdl##n = 0x68; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_56000(n)     { _ufcr##n = 0x18; _brdl##n = 0x47; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_57600(n)     { _ufcr##n = 0x20; _brdl##n = 0x45; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_115200(n)    { _ufcr##n = 0x30; _brdl##n = 0x22; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_230400(n)    { _ufcr##n = 0x18; _brdl##n = 0x11; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _ufcr##n = 0x00; _brdl##n = 0x10; _brdh##n = 0x00;}
#endif
#if UART_CLOCK_FREQ == 8000000
    #define SET_UARTn_BAUDRATE_300(n)       { _ufcr##n = 0x28; _brdl##n = 0x2A; _brdh##n = 0x68;}
    #define SET_UARTn_BAUDRATE_600(n)       { _ufcr##n = 0x18; _brdl##n = 0x15; _brdh##n = 0x34;}
    #define SET_UARTn_BAUDRATE_1200(n)      { _ufcr##n = 0x28; _brdl##n = 0x0A; _brdh##n = 0x1A;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _ufcr##n = 0x18; _brdl##n = 0x05; _brdh##n = 0x0D;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _ufcr##n = 0x28; _brdl##n = 0x82; _brdh##n = 0x06;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _ufcr##n = 0x18; _brdl##n = 0x41; _brdh##n = 0x03;}
    #define SET_UARTn_BAUDRATE_14400(n)     { _ufcr##n = 0x20; _brdl##n = 0x2B; _brdh##n = 0x02;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _ufcr##n = 0x28; _brdl##n = 0xA0; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_28800(n)     { _ufcr##n = 0x30; _brdl##n = 0x15; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_38400(n)     { _ufcr##n = 0x18; _brdl##n = 0xD0; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_56000(n)     { _ufcr##n = 0x38; _brdl##n = 0x8E; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_57600(n)     { _ufcr##n = 0x38; _brdl##n = 0x8A; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_115200(n)    { _ufcr##n = 0x20; _brdl##n = 0x45; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_230400(n)    { _ufcr##n = 0x30; _brdl##n = 0x22; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _ufcr##n = 0x00; _brdl##n = 0x20; _brdh##n = 0x00;}
#endif
#if UART_CLOCK_FREQ == 12000000
    #define SET_UARTn_BAUDRATE_300(n)       { _ufcr##n = 0x00; _brdl##n = 0x40; _brdh##n = 0x9C;}
    #define SET_UARTn_BAUDRATE_600(n)       { _ufcr##n = 0x00; _brdl##n = 0x20; _brdh##n = 0x4E;}
    #define SET_UARTn_BAUDRATE_1200(n)      { _ufcr##n = 0x00; _brdl##n = 0x10; _brdh##n = 0x27;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _ufcr##n = 0x00; _brdl##n = 0x88; _brdh##n = 0x13;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _ufcr##n = 0x00; _brdl##n = 0xC4; _brdh##n = 0x09;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _ufcr##n = 0x00; _brdl##n = 0xE2; _brdh##n = 0x04;}
    #define SET_UARTn_BAUDRATE_14400(n)     { _ufcr##n = 0x18; _brdl##n = 0x41; _brdh##n = 0x03;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _ufcr##n = 0x00; _brdl##n = 0x71; _brdh##n = 0x02;}
    #define SET_UARTn_BAUDRATE_28800(n)     { _ufcr##n = 0x28; _brdl##n = 0xA0; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_38400(n)     { _ufcr##n = 0x20; _brdl##n = 0x38; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_56000(n)     { _ufcr##n = 0x10; _brdl##n = 0xD6; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_57600(n)     { _ufcr##n = 0x18; _brdl##n = 0xD0; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_115200(n)    { _ufcr##n = 0x08; _brdl##n = 0x68; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_230400(n)    { _ufcr##n = 0x08; _brdl##n = 0x34; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _ufcr##n = 0x00; _brdl##n = 0x30; _brdh##n = 0x00;}
#endif
#if UART_CLOCK_FREQ == 16000000
    #define SET_UARTn_BAUDRATE_300(n)       { _ufcr##n = 0x18; _brdl##n = 0x55; _brdh##n = 0xD0;}
    #define SET_UARTn_BAUDRATE_600(n)       { _ufcr##n = 0x28; _brdl##n = 0x2A; _brdh##n = 0x68;}
    #define SET_UARTn_BAUDRATE_1200(n)      { _ufcr##n = 0x18; _brdl##n = 0x15; _brdh##n = 0x34;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _ufcr##n = 0x28; _brdl##n = 0x0A; _brdh##n = 0x1A;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _ufcr##n = 0x18; _brdl##n = 0x05; _brdh##n = 0x0D;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _ufcr##n = 0x28; _brdl##n = 0x82; _brdh##n = 0x06;}
    #define SET_UARTn_BAUDRATE_14400(n)     { _ufcr##n = 0x08; _brdl##n = 0x57; _brdh##n = 0x04;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _ufcr##n = 0x18; _brdl##n = 0x41; _brdh##n = 0x03;}
    #define SET_UARTn_BAUDRATE_28800(n)     { _ufcr##n = 0x20; _brdl##n = 0x2B; _brdh##n = 0x02;}
    #define SET_UARTn_BAUDRATE_38400(n)     { _ufcr##n = 0x28; _brdl##n = 0xA0; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_56000(n)     { _ufcr##n = 0x30; _brdl##n = 0x1D; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_57600(n)     { _ufcr##n = 0x30; _brdl##n = 0x15; _brdh##n = 0x01;}
    #define SET_UARTn_BAUDRATE_115200(n)    { _ufcr##n = 0x38; _brdl##n = 0x8A; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_230400(n)    { _ufcr##n = 0x20; _brdl##n = 0x45; _brdh##n = 0x00;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _ufcr##n = 0x00; _brdl##n = 0x40; _brdh##n = 0x00;}
#endif

// clang-format on

volatile Uart_Status_t uart0Status;
volatile uint8_t *queue_in0;
volatile uint8_t *queue_out0;

/**
 * @brief configuration uart
 *
 * @param cfg_t
 */
void Uart0_Cfg(const Uart_Cfg_t *cfg_t)
{
#if defined(PIN_TX0_PD4)
    PIN_PD4_TX0();
#endif
#if defined(PIN_RX0_PD5)
    PIN_PD5_RX0();
#endif

    SET_UARTn_Format_D8_NONE_S1(0);    // 數據傳輸格式設定
    // 波特率設定
#if UART0_BAUD_RATE == 300
    SET_UARTn_BAUDRATE_300(0);
#elif UART0_BAUD_RATE == 600
    SET_UARTn_BAUDRATE_600(0);
#elif UART0_BAUD_RATE == 1200
    SET_UARTn_BAUDRATE_1200(0);
#elif UART0_BAUD_RATE == 2400
    SET_UARTn_BAUDRATE_2400(0);
#elif UART0_BAUD_RATE == 4800
    SET_UARTn_BAUDRATE_4800(0);
#elif UART0_BAUD_RATE == 9600
    SET_UARTn_BAUDRATE_9600(0);
#elif UART0_BAUD_RATE == 14400
    SET_UARTn_BAUDRATE_14400(0);
#elif UART0_BAUD_RATE == 19200
    SET_UARTn_BAUDRATE_19200(0);
#elif UART0_BAUD_RATE == 28800
    SET_UARTn_BAUDRATE_28800(0);
#elif UART0_BAUD_RATE == 38400
    SET_UARTn_BAUDRATE_38400(0);
#elif UART0_BAUD_RATE == 57600
    SET_UARTn_BAUDRATE_57600(0);
#elif UART0_BAUD_RATE == 115200
    SET_UARTn_BAUDRATE_115200(0);
#elif UART0_BAUD_RATE == 230400
    SET_UARTn_BAUDRATE_230400(0);
#elif UART0_BAUD_RATE == 250000
    SET_UARTn_BAUDRATE_250000(0);
#else
    #error "Please set the correct UART_BAUD_RATE and SYS_CLOCK_FREQ"
#endif

    _ufcr0 &= 0xFC;     // default rx fifo 1byte trigger
    _ufcr0 |= 0x01;
    _adden0 = cfg_t->flag.b.addr;
    _wake0  = cfg_t->flag.b.wakeUp;
    _rie0   = 1;    // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
    // _tiie0   = 1;    // TIDLE(無數據傳輸)置位，可置中斷標誌位
    // _teie0   = 1;    // TXIF(數據已加載到移位暫存器，TXR為空)置位時，可置中斷標誌位
    uart0Status.txLen              = 0;
    uart0Status.txOffset           = 0;
    queue_in0                      = (uint8_t *)uart0Status.rxBuf;
    queue_out0                     = (uint8_t *)uart0Status.rxBuf;
    uart0Status.flag.b.queueIsFull = false;
}

/**
 * @brief 發送16進制 buf
 *
 * @param buf 發送的buf
 * @param len 發送的長度
 * @note 使用的是中斷發送，若 uart0Status.txLen = 0則說明數據已經發送完成
 * @return true 發送成功
 * @return false 發送失敗，上一筆數據還未發送完成
 */
bool Uart0_TxByte_Interrupt(volatile uint8_t *buf, uint8_t len)
{
    if (uart0Status.txLen > 0)
    {
        return false;
    }
    else
    {
        // clang-format off
        uart0Status.txLen    = len - 1;
        uart0Status.txOffset = buf;
        _acc = _u0sr;
        _txr_rxr0 = *uart0Status.txOffset;
        uart0Status.flag.b.isBusy = true;
        SET_UARTn_TX_INTERRUPT_ENABLE(0);
        // clang-format on
        return true;
    }
}

/**
 * @brief 發送16進制 buf
 *
 * @param byte 發送的byte
 * @param len  byte len
 * @return true 發送成功
 * @return false 發送失敗
 */
void Uart0_TxByte_Polling(uint8_t *byte, uint8_t len)
{
    SET_UARTn_TX_INTERRUPT_DISABLE(0);
    uint8_t i;
    for (i = 0; i < len; i++)
    {
        // clang-format off
        _acc      = _u0sr;
        _txr_rxr0 = *byte;
        while (!_tidle0)
            ;
        byte++;
        // clang-format on
    }
}

/**
 * @brief 讀取uart緩存數據
 * @param *byte 串口缓存中第一个可读字节，当没有可读数据时返回0，整数类型。
 * @return true 有可读字节
 * @return false 無可读字节
 */
bool Uart0_IsAvailable_ReadByte(uint8_t *byte)
{
    if ((queue_in0 != queue_out0) || uart0Status.flag.b.queueIsFull)
    {
        if (queue_out0 >= (uint8_t *)(uart0Status.rxBuf + uart0Status.rxBufLen))
        {
            queue_out0 = (uint8_t *)(uart0Status.rxBuf);
        }
        *byte = *queue_out0++;

        uart0Status.flag.b.queueIsFull = false;
        return true;
    }
    else
    {
        return false;
    }
}

#ifdef SUPPORT_ISP
// clang-format off
__attribute__((interrupt(0x30), reg_acc(0x8B), isr_at(0x30 + PROM_AP_ADDRESS_START)))
void UART0_ISR_Routine()
// clang-format on
#else
DEFINE_ISR(UART0_ISR, 0x30)
#endif
{
    // 噪声干扰错误 | 帧错误 | 溢出错误
    if (_nf0 | _ferr0 | _oerr0)
    {
        _acc = _u0sr;
        _acc = _txr_rxr0;
    }
    // 发送数据
    if (_txif0)
    {
        if (uart0Status.txLen > 0)
        {
            uart0Status.txOffset++;
            _txr_rxr0 = *uart0Status.txOffset;
            uart0Status.txLen--;
        }
        else
        {
            if (_tidle0)
            {
                uart0Status.flag.b.isBusy = false;
            }
        }
    }
    // 接收数据
    if (_rxif0)
    {
        if ((queue_in0 > queue_out0) && ((queue_in0 - queue_out0) >= uart0Status.rxBufLen))
        {
            // Queue is full: in is first byte and out is last byte
        }
        else if (uart0Status.flag.b.queueIsFull)
        {
            // Queue is full: in++ == out
        }
        else
        {
            // Queue is not full
            if (queue_in0 >= (uint8_t *)(uart0Status.rxBuf + uart0Status.rxBufLen))
            {
                queue_in0 = (uint8_t *)(uart0Status.rxBuf);
            }
            *queue_in0++ = _txr_rxr0;
            if (queue_in0 == queue_out0)
            {
                uart0Status.flag.b.queueIsFull = true;    // Queue is full: in++ == out
            }
        }
    }
}

volatile Uart_Status_t uart1Status;
volatile uint8_t *queue_in1;
volatile uint8_t *queue_out1;

/**
 * @brief configuration uart
 *
 * @param cfg_t
 */
void Uart1_Cfg(const Uart_Cfg_t *cfg_t)
{
#if defined(PIN_TX1_PC7)
    PIN_PC7_TX1();
#endif
#if defined(PIN_TX1_PA4)
    PIN_PA4_TX1();
#endif
#if defined(PIN_RX1_PA5)
    PIN_PA5_RX1();
#endif
#if defined(PIN_RX1_PC6)
    PIN_PC6_RX1();
#endif

    SET_UARTn_Format_D8_NONE_S1(1);    // 數據傳輸格式設定
    // 波特率設定
#if UART1_BAUD_RATE == 300
    SET_UARTn_BAUDRATE_300(1);
#elif UART1_BAUD_RATE == 600
    SET_UARTn_BAUDRATE_600(1);
#elif UART1_BAUD_RATE == 1200
    SET_UARTn_BAUDRATE_1200(1);
#elif UART1_BAUD_RATE == 2400
    SET_UARTn_BAUDRATE_2400(1);
#elif UART1_BAUD_RATE == 4800
    SET_UARTn_BAUDRATE_4800(1);
#elif UART1_BAUD_RATE == 9600
    SET_UARTn_BAUDRATE_9600(1);
#elif UART1_BAUD_RATE == 14400
    SET_UARTn_BAUDRATE_14400(1);
#elif UART1_BAUD_RATE == 19200
    SET_UARTn_BAUDRATE_19200(1);
#elif UART1_BAUD_RATE == 28800
    SET_UARTn_BAUDRATE_28800(1);
#elif UART1_BAUD_RATE == 38400
    SET_UARTn_BAUDRATE_38400(1);
#elif UART1_BAUD_RATE == 57600
    SET_UARTn_BAUDRATE_57600(1);
#elif UART1_BAUD_RATE == 115200
    SET_UARTn_BAUDRATE_115200(1);
#elif UART1_BAUD_RATE == 230400
    SET_UARTn_BAUDRATE_230400(1);
#elif UART1_BAUD_RATE == 250000
    SET_UARTn_BAUDRATE_250000(1);
#else
    #error "Please set the correct UART_BAUD_RATE and SYS_CLOCK_FREQ"
#endif

    _ufcr1 &= 0xFC;     // default rx fifo 1byte trigger
    _ufcr1 |= 0x01;
    _adden1 = cfg_t->flag.b.addr;
    _wake1  = cfg_t->flag.b.wakeUp;
    _rie1   = 1;    // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
    // _tiie1   = 1;    // TIDLE(無數據傳輸)置位，可置中斷標誌位
    // _teie1   = 1;    // TXIF(數據已加載到移位暫存器，TXR為空)置位時，可置中斷標誌位
    uart1Status.txLen              = 0;
    uart1Status.txOffset           = 0;
    queue_in1                      = (uint8_t *)uart1Status.rxBuf;
    queue_out1                     = (uint8_t *)uart1Status.rxBuf;
    uart1Status.flag.b.queueIsFull = false;
}

/**
 * @brief 發送16進制 buf
 *
 * @param buf 發送的buf
 * @param len 發送的長度
 * @note 使用的是中斷發送，若 uart1Status.txLen = 0則說明數據已經發送完成
 * @return true 發送成功
 * @return false 發送失敗，上一筆數據還未發送完成
 */
bool Uart1_TxByte_Interrupt(volatile uint8_t *buf, uint8_t len)
{
    if (uart1Status.txLen > 0)
    {
        return false;
    }
    else
    {
        // clang-format off
        uart1Status.txLen    = len - 1;
        uart1Status.txOffset = buf;
        _acc = _u1sr;
        _txr_rxr1 = *uart1Status.txOffset;
        uart1Status.flag.b.isBusy = true;
        SET_UARTn_TX_INTERRUPT_ENABLE(1);
        // clang-format on
        return true;
    }
}

/**
 * @brief 發送16進制 buf
 *
 * @param byte 發送的byte
 * @param len  byte len
 * @return true 發送成功
 * @return false 發送失敗
 */
void Uart1_TxByte_Polling(uint8_t *byte, uint8_t len)
{
    SET_UARTn_TX_INTERRUPT_DISABLE(1);
    uint8_t i;
    for (i = 0; i < len; i++)
    {
        // clang-format off
        _acc      = _u1sr;
        _txr_rxr1 = *byte;
        while (!_tidle1)
            ;
        byte++;
        // clang-format on
    }
}

/**
 * @brief 讀取uart緩存數據
 * @param *byte 串口缓存中第一个可读字节，当没有可读数据时返回0，整数类型。
 * @return true 有可读字节
 * @return false 無可读字节
 */
bool Uart1_IsAvailable_ReadByte(uint8_t *byte)
{
    if ((queue_in1 != queue_out1) || uart1Status.flag.b.queueIsFull)
    {
        if (queue_out1 >= (uint8_t *)(uart1Status.rxBuf + uart1Status.rxBufLen))
        {
            queue_out1 = (uint8_t *)(uart1Status.rxBuf);
        }
        *byte = *queue_out1++;

        uart1Status.flag.b.queueIsFull = false;
        return true;
    }
    else
    {
        return false;
    }
}

#ifdef SUPPORT_ISP
// clang-format off
__attribute__((interrupt(0x34), reg_acc(0x8C), isr_at(0x34 + PROM_AP_ADDRESS_START)))
void UART1_ISR_Routine()
// clang-format on
#else
DEFINE_ISR(UART1_ISR, 0x34)
#endif
{
    // 噪声干扰错误 | 帧错误 | 溢出错误
    if (_nf1 | _ferr1 | _oerr1)
    {
        _acc = _u1sr;
        _acc = _txr_rxr1;
    }
    // 发送数据
    if (_txif1)
    {
        if (uart1Status.txLen > 0)
        {
            uart1Status.txOffset++;
            _txr_rxr1 = *uart1Status.txOffset;
            uart1Status.txLen--;
        }
        else
        {
            if (_tidle1)
            {
                uart1Status.flag.b.isBusy = false;
            }
        }
    }
    // 接收数据
    if (_rxif1)
    {
        if ((queue_in1 > queue_out1) && ((queue_in1 - queue_out1) >= uart1Status.rxBufLen))
        {
            // Queue is full: in is first byte and out is last byte
        }
        else if (uart1Status.flag.b.queueIsFull)
        {
            // Queue is full: in++ == out
        }
        else
        {
            // Queue is not full
            if (queue_in1 >= (uint8_t *)(uart1Status.rxBuf + uart1Status.rxBufLen))
            {
                queue_in1 = (uint8_t *)(uart1Status.rxBuf);
            }
            *queue_in1++ = _txr_rxr1;
            if (queue_in1 == queue_out1)
            {
                uart1Status.flag.b.queueIsFull = true;    // Queue is full: in++ == out
            }
        }
    }
}

void Int32ToString(int32_t num, uint8_t *str)    // 10进制
{
    int i = 0;    // 指示填充str
    // 如果num为负数，将num变正
    if (num < 0)
    {
        num      = -num;
        str[i++] = '-';
    }
    // 转换
    do
    {
        // 取num最低位 字符0~9的ASCII码是48~57；简单来说数字0+48=48，ASCII码对应字符'0'
        str[i++] = num % 10 + 48;
        num /= 10;    // 去掉最低位
    } while (num);    // num不为0继续循环

    str[i] = '\0';
    // 确定开始调整的位置
    int j = 0;
    if (str[0] == '-')
    {
        // 如果有负号，负号不用调整
        j = 1;    // 从第二位开始调整
        ++i;      // 由于有负号，所以交换的对称轴也要后移1位
    }
    // 对称交换
    for (; j < i / 2; j++)
    {
        // 对称交换两端的值 其实就是省下中间变量交换a+b的值：a=a+b;b=a-b;a=a-b;
        str[j]         = str[j] + str[i - 1 - j];
        str[i - 1 - j] = str[j] - str[i - 1 - j];
        str[j]         = str[j] - str[i - 1 - j];
    }
}