/**
 * *************************************************************************************************************
 * @file TimeBase.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for TimeBase firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _TIME_BASE_H_
#define _TIME_BASE_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BH67F2495.h"

/* Exported types ----------------------------------------------------------------------------------------*/
/*! timeBase time out period selection enum */
typedef enum {
    TIMEBASE_8MS    = 0x00,
    TIMEBASE_16MS   = 0x01,
    TIMEBASE_32MS   = 0x02,
    TIMEBASE_62MS   = 0x03,
    TIMEBASE_125MS  = 0x04,
    TIMEBASE_250MS  = 0x05,
    TIMEBASE_500MS  = 0x06,
    TIMEBASE_1000MS = 0x07,
} TimeBase_Cfg_e;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
#define TimeBase0_Cfg(type)         { _pscr = 0x03; _tb0c = type;} //!< @see TimeBase_Cfg_e
#define TimeBase0_Enable()          { _tb0on = 1;}
#define TimeBase0_Disable()         { _tb0on = 0;}
#define TimeBase0_Isr_Enable()      { _tb0e = 1;}
#define TimeBase0_Isr_Disable()     { _tb0e = 0;}

#define TimeBase1_Cfg(type)         { _pscr = 0x03; _tb1c = type;} //!< @see TimeBase_Cfg_e
#define TimeBase1_Enable()          { _tb1on = 1;}
#define TimeBase1_Disable()         { _tb1on = 0;}
#define TimeBase1_Isr_Enable()      { _tb1e = 1;}
#define TimeBase1_Isr_Disable()     { _tb1e = 0;}

// clang-format on

#endif