/**
 * *************************************************************************************************************
 * @file LedScan7x6_BFScales.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for LedScan7x6_BFScales firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _LED_SCAN7X6_H_
#define _LED_SCAN7X6_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"

/* Exported types -----------------------------------------------------------------------------------------*/
typedef struct {
    uint8_t SegA : 1;
    uint8_t SegB : 1;
    uint8_t SegC : 1;
    uint8_t SegD : 1;
    uint8_t SegE : 1;
    uint8_t SegF : 1;
    uint8_t SegG : 1;
    uint8_t SegH : 1;
} led_bits_t;

typedef union {
    led_bits_t bits;
    uint8_t byte;
} led_bits_type;

typedef struct {
    uint8_t BIT0 : 1;
    uint8_t BIT1 : 1;
    uint8_t BIT2 : 1;
    uint8_t BIT3 : 1;
    uint8_t BIT4 : 1;
    uint8_t BIT5 : 1;
    uint8_t BIT6 : 1;
    uint8_t BIT7 : 1;
} uint8_bits_t;

typedef union {
    uint8_bits_t bits;
    uint8_t byte;
} uint8_bits_type;

// LED_Num_BCD
#define CHAR_0   0
#define CHAR_1   1
#define CHAR_2   2
#define CHAR_3   3
#define CHAR_4   4
#define CHAR_5   5
#define CHAR_6   6
#define CHAR_7   7
#define CHAR_8   8
#define CHAR_9   9
#define CHAR_A   10
#define CHAR_B   11
#define CHAR_C   12
#define CHAR_D   13
#define CHAR_E   14
#define CHAR_F   15
#define CHAR_G   16
#define CHAR_H   17
#define CHAR_I   18
#define CHAR_J   19
#define CHAR_L   20
#define CHAR_N   21
#define CHAR_n   22
#define CHAR_o   23
#define CHAR_P   24
#define CHAR_Q   25
#define CHAR_r   26
#define CHAR_U   27
#define CHAR_u   28
#define CHAR_Y   29
#define CHAR__   30
#define CHAR_    31
#define CHAR_OFF 32
#define CHAR_ALL 33

#define LED_LINK ledCharBuf[0].bits.BIT0
#define LED_KG   ledCharBuf[0].bits.BIT1
#define LED_JIN  ledCharBuf[0].bits.BIT2
#define LED_BAT  ledCharBuf[0].bits.BIT3
#define LED_HR   ledCharBuf[0].bits.BIT4
#define LED_BLE  ledCharBuf[0].bits.BIT5
#define LED_DOT1 ledCharBuf[0].bits.BIT6

#define LED_LINE1 ledCharBuf[1].bits.BIT0
#define LED_LINE2 ledCharBuf[1].bits.BIT1
#define LED_LINE3 ledCharBuf[1].bits.BIT2
#define LED_LINE4 ledCharBuf[1].bits.BIT3
#define LED_NC1   ledCharBuf[1].bits.BIT4
#define LED_NC2   ledCharBuf[1].bits.BIT5
#define LED_DOT2  ledCharBuf[1].bits.BIT6
/* Exported functions --------------------------------------------------------------------------------------*/
void LedScan7x6_Disable();                         //!< 关闭所有显示
void LedScan7x6_Loop(void);                        //!< 定時輪詢，建議2ms
void LedScan7x6_dataBCDUpdate(uint16_t number);    //!< 數字顯示，結果轉換到 ledNumBuf 1位小數 秤使用

void LedScan7x6_dataAllUpdate(bool withBcd);    //!< 將要顯示的值更新
extern led_bits_type ledNumBuf[4];              //!< 用於7-SEG數碼管
extern uint8_bits_type ledCharBuf[2];           //!< 用於特殊字符,常用全亮或全滅等整體控制

/**
1. 全滅LED
    ledNumBuf[0].byte = CHAR_OFF;
    ledNumBuf[1].byte = CHAR_OFF;
    ledNumBuf[2].byte = CHAR_OFF;
    ledNumBuf[3].byte = CHAR_OFF;
    ledCharBuf[0].byte = 0x00;
    ledCharBuf[1].byte = 0x00;
    LedScan7x6_dataAllUpdate(true);

2. 全亮LED
    ledNumBuf[0].byte = CHAR_ALL;
    ledNumBuf[1].byte = CHAR_ALL;
    ledNumBuf[2].byte = CHAR_ALL;
    ledNumBuf[3].byte = CHAR_ALL;
    ledCharBuf[0].byte = 0xFF;
    ledCharBuf[1].byte = 0xFF;
    LedScan7x6_dataAllUpdate(true);

3. 數字區域顯示體重值
    LedScan7x6_dataBCDUpdate(weightKg);
    LedScan7x6_dataAllUpdate(true);

4. 特殊字符區域：顯示單位切換
   if (unit == KG)
   {
       LED_KG = 1;
       LED_JIN= 0;
   }
   else if (unit == JIN)
   {
       LED_KG = 0;
       LED_JIN= 1;
   }

5. 特殊字符區域：數字區域，比如動畫顯示數字外圍跑圈效果
     - - - -
    |       |
     - - - -
    // 清除數字所有顯示
    ledNumBuf[0].byte = CHAR_OFF;
    ledNumBuf[1].byte = CHAR_OFF;
    ledNumBuf[2].byte = CHAR_OFF;
    ledNumBuf[3].byte = CHAR_OFF;
    LedScan7x6_dataAllUpdate(true);

    // 定時500ms 或 其他輪詢執行
    if (gbv_500ms)
    {
        gbv_500ms = 0;
        switch (PollingDisplay_Cnt){
        case 0: ledNumBuf[0].bits.SegA = 1; break;
        case 1: ledNumBuf[1].bits.SegA = 1; break;
        case 2: ledNumBuf[2].bits.SegA = 1; break;
        case 3: ledNumBuf[3].bits.SegA = 1; break;
        case 4: ledNumBuf[3].bits.SegB = 1; break;
        case 5: ledNumBuf[3].bits.SegC = 1; break;
        case 6: ledNumBuf[3].bits.SegD = 1; break;
        case 7: ledNumBuf[2].bits.SegD = 1; break;
        case 8: ledNumBuf[1].bits.SegD = 1; break;
        case 9: ledNumBuf[0].bits.SegD = 1; break;
        case 10: ledNumBuf[0].bits.SegE = 1; break;
        case 11: ledNumBuf[0].bits.SegF = 1; break;
        default:
            break;
        }
        PollingDisplay_Cnt ++;
        if (PollingDisplay_Cnt > 11)
        {
            PollingDisplay_Cnt = 0;
        }
    }
**/

#endif