/**
 * *************************************************************************************************************
 * @file LedScan7x6_BFScales.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for LedScan7x6_BFScales firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "LedScan7x6.h"
#include "..\board\BoardCfg.h"

// clang-format off
//--可以直接包含Gpio.h,此處為方便移植，直接將代碼複製到此處避免包含
#define PIN_ModeOutput(p, n)        { _##p##c##n = 0;}
#define PIN_ModeInput(p, n)         { _##p##c##n = 1;}
#define PIN_OutputHigh(p, n)        { _##p####n = 1;}
#define PIN_OutputLow(p, n)         { _##p####n = 0;}
#define PIN_OutputInvert(p, n)      { _##p####n = ~_##p####n;}
#define PIN_PullHigh_Enable(p, n)   { _##p##pu##n = 1;}
#define PIN_PullHigh_Disable(p, n)  { _##p##pu##n = 0;}
#define PIN_WakeUp_Enable(p, n)     { _##p##wu##n = 1;}  //!< only pa port
#define PIN_WakeUp_Disable(p, n)    { _##p##wu##n = 0;}  //!< only pa port
#define PIN_IsHigh(p, n)            _##p####n == 1
#define PIN_IsLow(p, n)             _##p####n == 0

// LedScan7x6 Pin configuration,統一在BoardCfg.h文件中方便管理
//#define PIN_SEG0_P    pd
//#define PIN_SEG0_N    0
//#define PIN_SEG1_P    pd
//#define PIN_SEG1_N    1
//#define PIN_SEG2_P    pd
//#define PIN_SEG2_N    2
//#define PIN_SEG3_P    pd
//#define PIN_SEG3_N    3
//#define PIN_SEG4_P    pd
//#define PIN_SEG4_N    4
//#define PIN_SEG5_P    pd
//#define PIN_SEG5_N    5
//#define PIN_SEG6_P    pd
//#define PIN_SEG6_N    6
#define LED_COM_ON(port , n)        { PIN_OutputLow(port,n); PIN_ModeOutput(port,n);}
#define LED_SEG_ON(port , n)        { PIN_OutputHigh(port,n); PIN_ModeOutput(port,n);}
#define LED_SEG_OFF(port , n)       { PIN_PullHigh_Disable(port,n); PIN_ModeInput(port,n);}
#define LED_SEG_Disable(port , n)   { PIN_PullHigh_Enable(port,n); PIN_ModeInput(port,n);}

// clang-format on
led_bits_type LED_Num_data[4];    //!< 用於7-SEG數碼管
led_bits_type ledNumBuf[4];       //!< 用於7-SEG數碼管
uint8_bits_type ledCharBuf[2];    //!< 用於特殊字符

volatile uint8_bits_type LED_HW_MAP[7];    //!< 映射實際的LED
volatile uint8_t LEDScanCnt;               //!< 掃描計數

#define SEG_MAP(x) (1 << x)    // 段碼位置
#define a          SEG_MAP(0)
#define b          SEG_MAP(1)
#define c          SEG_MAP(2)
#define d          SEG_MAP(3)
#define e          SEG_MAP(4)
#define f          SEG_MAP(5)
#define g          SEG_MAP(6)
#define h          SEG_MAP(7)
const uint8_t LedNumberTable[] =
    {
        a + b + c + d + e + f,           // Displays "0"  	// 0
        b + c,                           // Displays "1"  	// 1
        a + b + d + e + g,               // Displays "2"  	// 2
        a + b + c + d + g,               // Displays "3"  	// 3
        b + c + f + g,                   // Displays "4"  	// 4
        a + c + d + f + g,               // Displays "5"  	// 5
        a + c + d + e + f + g,           // Displays "6"  	// 6
        a + b + c,                       // Displays "7"  	// 7
        a + b + c + d + e + f + g,       // Displays "8"  	// 8
        a + b + c + d + f + g,           // Displays "9"  	// 9
        a + b + c + e + f + g,           // Displays "A"  	// 10
        c + d + e + f + g,               // Displays "B"  	// 11
        a + d + e + f,                   // Displays "C"  	// 12
        b + c + d + e + g,               // Displays "D"  	// 13
        a + d + e + f + g,               // Displays "E"  	// 14
        a + e + f + g,                   // Displays "F"  	// 15
        a + c + d + e + f,               // Displays "G"  	// 16
        b + c + e + f + g,               // Displays "H"  	// 17
        e + f,                           // Displays "I"  	// 18
        b + c + d + e,                   // Displays "J"  	// 19
        d + e + f,                       // Displays "L"  	// 20
        a + b + c + e + f,               // Displays "N"  	// 21
        c + e + g,                       // Displays "n"  	// 22
        c + d + e + g,                   // Displays "o"  	// 23
        a + b + e + f + g,               // Displays "P"  	// 24
        a + b + c + f + g,               // Displays "Q"  	// 25
        e + g,                           // Displays "r"  	// 26
        b + c + d + e + f,               // Displays "U" 	// 27
        c + d + e,                       // Displays "u"   	// 28
        b + c + d + f + g,               // Displays "Y"   	// 29
        g,                               // Displays "-"  	// 30
        b,                               // Displays "'"   	// 31
        0,                               // Displays " "  	// 32
        a + b + c + d + e + f + g + h    // Displays "8."  	// 33
};

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                LED map to IO map                                    @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// 比如LED 對應的IO為，負端接SEG4，正端接SEG5，則#define MAP_LED1    LED_HW_MAP[4].bits.BIT5
//   __		A
//  |  |  F	  B
//   __		G
//  |  |  E   C
//   __  	D
#define SEG0_A LED_HW_MAP[0].bits.BIT1
#define SEG0_B LED_HW_MAP[0].bits.BIT3
#define SEG0_C LED_HW_MAP[0].bits.BIT6
#define SEG0_D LED_HW_MAP[4].bits.BIT0
#define SEG0_E LED_HW_MAP[0].bits.BIT5
#define SEG0_F LED_HW_MAP[0].bits.BIT2
#define SEG0_G LED_HW_MAP[0].bits.BIT4

#define SEG1_A LED_HW_MAP[1].bits.BIT0
#define SEG1_B LED_HW_MAP[1].bits.BIT3
#define SEG1_C LED_HW_MAP[1].bits.BIT6
#define SEG1_D LED_HW_MAP[4].bits.BIT1
#define SEG1_E LED_HW_MAP[1].bits.BIT5
#define SEG1_F LED_HW_MAP[1].bits.BIT2
#define SEG1_G LED_HW_MAP[1].bits.BIT4

#define SEG2_A LED_HW_MAP[2].bits.BIT0
#define SEG2_B LED_HW_MAP[2].bits.BIT3
#define SEG2_C LED_HW_MAP[2].bits.BIT6
#define SEG2_D LED_HW_MAP[4].bits.BIT2
#define SEG2_E LED_HW_MAP[2].bits.BIT5
#define SEG2_F LED_HW_MAP[2].bits.BIT1
#define SEG2_G LED_HW_MAP[2].bits.BIT4

#define SEG3_A LED_HW_MAP[3].bits.BIT0
#define SEG3_B LED_HW_MAP[3].bits.BIT2
#define SEG3_C LED_HW_MAP[3].bits.BIT6
#define SEG3_D LED_HW_MAP[4].bits.BIT3
#define SEG3_E LED_HW_MAP[3].bits.BIT5
#define SEG3_F LED_HW_MAP[3].bits.BIT1
#define SEG3_G LED_HW_MAP[3].bits.BIT4
// 特殊字符
#define SIGN_DOT2  LED_HW_MAP[4].bits.BIT5
#define SIGN_DOT1  LED_HW_MAP[4].bits.BIT6
#define SIGN_BLE   LED_HW_MAP[6].bits.BIT4
#define SIGN_KG    LED_HW_MAP[6].bits.BIT0
#define SIGN_JIN   LED_HW_MAP[5].bits.BIT4
#define SIGN_BAT   LED_HW_MAP[6].bits.BIT2
#define SIGN_HR    LED_HW_MAP[6].bits.BIT3
#define SIGN_LINK  LED_HW_MAP[6].bits.BIT5
#define SIGN_LINE1 LED_HW_MAP[5].bits.BIT0
#define SIGN_LINE2 LED_HW_MAP[5].bits.BIT1
#define SIGN_LINE3 LED_HW_MAP[5].bits.BIT2
#define SIGN_LINE4 LED_HW_MAP[5].bits.BIT3
#define SIGN_NC1   LED_HW_MAP[5].bits.BIT6
#define SIGN_NC2   LED_HW_MAP[6].bits.BIT1

void LedScan7x6_Disable()
{
    LED_SEG_Disable(PIN_SEG0_P, PIN_SEG0_N);
    LED_SEG_Disable(PIN_SEG1_P, PIN_SEG1_N);
    LED_SEG_Disable(PIN_SEG2_P, PIN_SEG2_N);
    LED_SEG_Disable(PIN_SEG3_P, PIN_SEG3_N);
    LED_SEG_Disable(PIN_SEG4_P, PIN_SEG4_N);
    LED_SEG_Disable(PIN_SEG5_P, PIN_SEG5_N);
    LED_SEG_Disable(PIN_SEG6_P, PIN_SEG6_N);
}

/**
 * @brief 定時掃描LED，建議放置到Timer中，時間建議設置為2ms
 */
void LedScan7x6_Loop(void)
{
    LED_SEG_OFF(PIN_SEG0_P, PIN_SEG0_N);
    LED_SEG_OFF(PIN_SEG1_P, PIN_SEG1_N);
    LED_SEG_OFF(PIN_SEG2_P, PIN_SEG2_N);
    LED_SEG_OFF(PIN_SEG3_P, PIN_SEG3_N);
    LED_SEG_OFF(PIN_SEG4_P, PIN_SEG4_N);
    LED_SEG_OFF(PIN_SEG5_P, PIN_SEG5_N);
    LED_SEG_OFF(PIN_SEG6_P, PIN_SEG6_N);
    // clang-format off
    switch (LEDScanCnt)
    {
        case 0:
            if (LED_HW_MAP[0].bits.BIT1){ LED_SEG_ON(PIN_SEG1_P, PIN_SEG1_N);} else{ LED_SEG_OFF(PIN_SEG1_P, PIN_SEG1_N);}
            if (LED_HW_MAP[0].bits.BIT2){ LED_SEG_ON(PIN_SEG2_P, PIN_SEG2_N);} else{ LED_SEG_OFF(PIN_SEG2_P, PIN_SEG2_N);}
            if (LED_HW_MAP[0].bits.BIT3){ LED_SEG_ON(PIN_SEG3_P, PIN_SEG3_N);} else{ LED_SEG_OFF(PIN_SEG3_P, PIN_SEG3_N);}
            if (LED_HW_MAP[0].bits.BIT4){ LED_SEG_ON(PIN_SEG4_P, PIN_SEG4_N);} else{ LED_SEG_OFF(PIN_SEG4_P, PIN_SEG4_N);}
            if (LED_HW_MAP[0].bits.BIT5){ LED_SEG_ON(PIN_SEG5_P, PIN_SEG5_N);} else{ LED_SEG_OFF(PIN_SEG5_P, PIN_SEG5_N);}
            if (LED_HW_MAP[0].bits.BIT6){ LED_SEG_ON(PIN_SEG6_P, PIN_SEG6_N);} else{ LED_SEG_OFF(PIN_SEG6_P, PIN_SEG6_N);}
        	LED_COM_ON(PIN_SEG0_P, PIN_SEG0_N);
            break;
        case 1:
            if (LED_HW_MAP[1].bits.BIT0){ LED_SEG_ON(PIN_SEG0_P, PIN_SEG0_N);} else{ LED_SEG_OFF(PIN_SEG0_P, PIN_SEG0_N);}
            if (LED_HW_MAP[1].bits.BIT2){ LED_SEG_ON(PIN_SEG2_P, PIN_SEG2_N);} else{ LED_SEG_OFF(PIN_SEG2_P, PIN_SEG2_N);}
            if (LED_HW_MAP[1].bits.BIT3){ LED_SEG_ON(PIN_SEG3_P, PIN_SEG3_N);} else{ LED_SEG_OFF(PIN_SEG3_P, PIN_SEG3_N);}
            if (LED_HW_MAP[1].bits.BIT4){ LED_SEG_ON(PIN_SEG4_P, PIN_SEG4_N);} else{ LED_SEG_OFF(PIN_SEG4_P, PIN_SEG4_N);}
            if (LED_HW_MAP[1].bits.BIT5){ LED_SEG_ON(PIN_SEG5_P, PIN_SEG5_N);} else{ LED_SEG_OFF(PIN_SEG5_P, PIN_SEG5_N);}
            if (LED_HW_MAP[1].bits.BIT6){ LED_SEG_ON(PIN_SEG6_P, PIN_SEG6_N);} else{ LED_SEG_OFF(PIN_SEG6_P, PIN_SEG6_N);}
            LED_COM_ON(PIN_SEG1_P, PIN_SEG1_N);
            break;
        case 2:
            if (LED_HW_MAP[2].bits.BIT0){ LED_SEG_ON(PIN_SEG0_P, PIN_SEG0_N);} else{ LED_SEG_OFF(PIN_SEG0_P, PIN_SEG0_N);}
            if (LED_HW_MAP[2].bits.BIT1){ LED_SEG_ON(PIN_SEG1_P, PIN_SEG1_N);} else{ LED_SEG_OFF(PIN_SEG1_P, PIN_SEG1_N);}
            if (LED_HW_MAP[2].bits.BIT3){ LED_SEG_ON(PIN_SEG3_P, PIN_SEG3_N);} else{ LED_SEG_OFF(PIN_SEG3_P, PIN_SEG3_N);}
            if (LED_HW_MAP[2].bits.BIT4){ LED_SEG_ON(PIN_SEG4_P, PIN_SEG4_N);} else{ LED_SEG_OFF(PIN_SEG4_P, PIN_SEG4_N);}
            if (LED_HW_MAP[2].bits.BIT5){ LED_SEG_ON(PIN_SEG5_P, PIN_SEG5_N);} else{ LED_SEG_OFF(PIN_SEG5_P, PIN_SEG5_N);}
            if (LED_HW_MAP[2].bits.BIT6){ LED_SEG_ON(PIN_SEG6_P, PIN_SEG6_N);} else{ LED_SEG_OFF(PIN_SEG6_P, PIN_SEG6_N);}
            LED_COM_ON(PIN_SEG2_P, PIN_SEG2_N);
            break;
        case 3:
            if (LED_HW_MAP[3].bits.BIT0){ LED_SEG_ON(PIN_SEG0_P, PIN_SEG0_N);} else{ LED_SEG_OFF(PIN_SEG0_P, PIN_SEG0_N);}
            if (LED_HW_MAP[3].bits.BIT1){ LED_SEG_ON(PIN_SEG1_P, PIN_SEG1_N);} else{ LED_SEG_OFF(PIN_SEG1_P, PIN_SEG1_N);}
            if (LED_HW_MAP[3].bits.BIT2){ LED_SEG_ON(PIN_SEG2_P, PIN_SEG2_N);} else{ LED_SEG_OFF(PIN_SEG2_P, PIN_SEG2_N);}
            if (LED_HW_MAP[3].bits.BIT4){ LED_SEG_ON(PIN_SEG4_P, PIN_SEG4_N);} else{ LED_SEG_OFF(PIN_SEG4_P, PIN_SEG4_N);}
            if (LED_HW_MAP[3].bits.BIT5){ LED_SEG_ON(PIN_SEG5_P, PIN_SEG5_N);} else{ LED_SEG_OFF(PIN_SEG5_P, PIN_SEG5_N);}
            if (LED_HW_MAP[3].bits.BIT6){ LED_SEG_ON(PIN_SEG6_P, PIN_SEG6_N);} else{ LED_SEG_OFF(PIN_SEG6_P, PIN_SEG6_N);}
            LED_COM_ON(PIN_SEG3_P, PIN_SEG3_N);
            break;
        case 4:
            if (LED_HW_MAP[4].bits.BIT0){ LED_SEG_ON(PIN_SEG0_P, PIN_SEG0_N);} else{ LED_SEG_OFF(PIN_SEG0_P, PIN_SEG0_N);}
            if (LED_HW_MAP[4].bits.BIT1){ LED_SEG_ON(PIN_SEG1_P, PIN_SEG1_N);} else{ LED_SEG_OFF(PIN_SEG1_P, PIN_SEG1_N);}
            if (LED_HW_MAP[4].bits.BIT2){ LED_SEG_ON(PIN_SEG2_P, PIN_SEG2_N);} else{ LED_SEG_OFF(PIN_SEG2_P, PIN_SEG2_N);}
            if (LED_HW_MAP[4].bits.BIT3){ LED_SEG_ON(PIN_SEG3_P, PIN_SEG3_N);} else{ LED_SEG_OFF(PIN_SEG3_P, PIN_SEG3_N);}
            if (LED_HW_MAP[4].bits.BIT5){ LED_SEG_ON(PIN_SEG5_P, PIN_SEG5_N);} else{ LED_SEG_OFF(PIN_SEG5_P, PIN_SEG5_N);}
            if (LED_HW_MAP[4].bits.BIT6){ LED_SEG_ON(PIN_SEG6_P, PIN_SEG6_N);} else{ LED_SEG_OFF(PIN_SEG6_P, PIN_SEG6_N);}
            LED_COM_ON(PIN_SEG4_P, PIN_SEG4_N);
            break;
        case 5:
            if (LED_HW_MAP[5].bits.BIT0){ LED_SEG_ON(PIN_SEG0_P, PIN_SEG0_N);} else{ LED_SEG_OFF(PIN_SEG0_P, PIN_SEG0_N);}
            if (LED_HW_MAP[5].bits.BIT1){ LED_SEG_ON(PIN_SEG1_P, PIN_SEG1_N);} else{ LED_SEG_OFF(PIN_SEG1_P, PIN_SEG1_N);}
            if (LED_HW_MAP[5].bits.BIT2){ LED_SEG_ON(PIN_SEG2_P, PIN_SEG2_N);} else{ LED_SEG_OFF(PIN_SEG2_P, PIN_SEG2_N);}
            if (LED_HW_MAP[5].bits.BIT3){ LED_SEG_ON(PIN_SEG3_P, PIN_SEG3_N);} else{ LED_SEG_OFF(PIN_SEG3_P, PIN_SEG3_N);}
            if (LED_HW_MAP[5].bits.BIT4){ LED_SEG_ON(PIN_SEG4_P, PIN_SEG4_N);} else{ LED_SEG_OFF(PIN_SEG4_P, PIN_SEG4_N);}
            if (LED_HW_MAP[5].bits.BIT6){ LED_SEG_ON(PIN_SEG6_P, PIN_SEG6_N);} else{ LED_SEG_OFF(PIN_SEG6_P, PIN_SEG6_N);}
            LED_COM_ON(PIN_SEG5_P, PIN_SEG5_N);
            break;
        case 6:
            if (LED_HW_MAP[6].bits.BIT0){ LED_SEG_ON(PIN_SEG0_P, PIN_SEG0_N);} else{ LED_SEG_OFF(PIN_SEG0_P, PIN_SEG0_N);}
            if (LED_HW_MAP[6].bits.BIT1){ LED_SEG_ON(PIN_SEG1_P, PIN_SEG1_N);} else{ LED_SEG_OFF(PIN_SEG1_P, PIN_SEG1_N);}
            if (LED_HW_MAP[6].bits.BIT2){ LED_SEG_ON(PIN_SEG2_P, PIN_SEG2_N);} else{ LED_SEG_OFF(PIN_SEG2_P, PIN_SEG2_N);}
            if (LED_HW_MAP[6].bits.BIT3){ LED_SEG_ON(PIN_SEG3_P, PIN_SEG3_N);} else{ LED_SEG_OFF(PIN_SEG3_P, PIN_SEG3_N);}
            if (LED_HW_MAP[6].bits.BIT4){ LED_SEG_ON(PIN_SEG4_P, PIN_SEG4_N);} else{ LED_SEG_OFF(PIN_SEG4_P, PIN_SEG4_N);}
            if (LED_HW_MAP[6].bits.BIT5){ LED_SEG_ON(PIN_SEG5_P, PIN_SEG5_N);} else{ LED_SEG_OFF(PIN_SEG5_P, PIN_SEG5_N);}
            LED_COM_ON(PIN_SEG6_P, PIN_SEG6_N);
            break;
        default:
            break;
    }
	LEDScanCnt++;
	if (LEDScanCnt > 6)
	{
	   LEDScanCnt = 0;
	}
}

/**
 * @brief 將 ledNumBuf 和 ledCharBuf 值更新到 LED 顯示
 */
void LedScan7x6_dataAllUpdate(bool withBcd)
{
	if (withBcd)
	{
		LED_Num_data[0].byte = LedNumberTable[ledNumBuf[0].byte];
		LED_Num_data[1].byte = LedNumberTable[ledNumBuf[1].byte];
		LED_Num_data[2].byte = LedNumberTable[ledNumBuf[2].byte];
		LED_Num_data[3].byte = LedNumberTable[ledNumBuf[3].byte];
	}
    // 字段映射， 不能直接賦值，直接賦值編譯器轉換 效率會非常低，造成 ROM 變大
    if (LED_Num_data[0].bits.SegA){ SEG0_A = 1;} else { SEG0_A = 0;}
	if (LED_Num_data[0].bits.SegB){ SEG0_B = 1;} else { SEG0_B = 0;}
	if (LED_Num_data[0].bits.SegC){ SEG0_C = 1;} else { SEG0_C = 0;}
	if (LED_Num_data[0].bits.SegD){ SEG0_D = 1;} else { SEG0_D = 0;}
	if (LED_Num_data[0].bits.SegE){ SEG0_E = 1;} else { SEG0_E = 0;}
	if (LED_Num_data[0].bits.SegF){ SEG0_F = 1;} else { SEG0_F = 0;}
	if (LED_Num_data[0].bits.SegG){ SEG0_G = 1;} else { SEG0_G = 0;}

	if (LED_Num_data[1].bits.SegA){ SEG1_A = 1;} else { SEG1_A = 0;}
	if (LED_Num_data[1].bits.SegB){ SEG1_B = 1;} else { SEG1_B = 0;}
	if (LED_Num_data[1].bits.SegC){ SEG1_C = 1;} else { SEG1_C = 0;}
	if (LED_Num_data[1].bits.SegD){ SEG1_D = 1;} else { SEG1_D = 0;}
	if (LED_Num_data[1].bits.SegE){ SEG1_E = 1;} else { SEG1_E = 0;}
	if (LED_Num_data[1].bits.SegF){ SEG1_F = 1;} else { SEG1_F = 0;}
	if (LED_Num_data[1].bits.SegG){ SEG1_G = 1;} else { SEG1_G = 0;}

	if (LED_Num_data[2].bits.SegA){ SEG2_A = 1;} else { SEG2_A = 0;}
	if (LED_Num_data[2].bits.SegB){ SEG2_B = 1;} else { SEG2_B = 0;}
	if (LED_Num_data[2].bits.SegC){ SEG2_C = 1;} else { SEG2_C = 0;}
	if (LED_Num_data[2].bits.SegD){ SEG2_D = 1;} else { SEG2_D = 0;}
	if (LED_Num_data[2].bits.SegE){ SEG2_E = 1;} else { SEG2_E = 0;}
	if (LED_Num_data[2].bits.SegF){ SEG2_F = 1;} else { SEG2_F = 0;}
	if (LED_Num_data[2].bits.SegG){ SEG2_G = 1;} else { SEG2_G = 0;}

	if (LED_Num_data[3].bits.SegA){ SEG3_A = 1;} else { SEG3_A = 0;}
	if (LED_Num_data[3].bits.SegB){ SEG3_B = 1;} else { SEG3_B = 0;}
	if (LED_Num_data[3].bits.SegC){ SEG3_C = 1;} else { SEG3_C = 0;}
	if (LED_Num_data[3].bits.SegD){ SEG3_D = 1;} else { SEG3_D = 0;}
	if (LED_Num_data[3].bits.SegE){ SEG3_E = 1;} else { SEG3_E = 0;}
	if (LED_Num_data[3].bits.SegF){ SEG3_F = 1;} else { SEG3_F = 0;}
	if (LED_Num_data[3].bits.SegG){ SEG3_G = 1;} else { SEG3_G = 0;}

	if (ledCharBuf[0].bits.BIT0){ SIGN_LINK = 1;} else { SIGN_LINK = 0;}
	if (ledCharBuf[0].bits.BIT1){ SIGN_KG   = 1;} else { SIGN_KG   = 0;}
	if (ledCharBuf[0].bits.BIT2){ SIGN_JIN  = 1;} else { SIGN_JIN  = 0;}
	if (ledCharBuf[0].bits.BIT3){ SIGN_BAT  = 1;} else { SIGN_BAT  = 0;}
	if (ledCharBuf[0].bits.BIT4){ SIGN_HR   = 1;} else { SIGN_HR   = 0;}
	if (ledCharBuf[0].bits.BIT5){ SIGN_BLE  = 1;} else { SIGN_BLE  = 0;}
	if (ledCharBuf[0].bits.BIT6){ SIGN_DOT1 = 1;} else { SIGN_DOT1 = 0;}

	if (ledCharBuf[1].bits.BIT0){ SIGN_LINE1 = 1;} else { SIGN_LINE1 = 0;}
	if (ledCharBuf[1].bits.BIT1){ SIGN_LINE2 = 1;} else { SIGN_LINE2 = 0;}
	if (ledCharBuf[1].bits.BIT2){ SIGN_LINE3 = 1;} else { SIGN_LINE3 = 0;}
	if (ledCharBuf[1].bits.BIT3){ SIGN_LINE4 = 1;} else { SIGN_LINE4 = 0;}
	if (ledCharBuf[1].bits.BIT4){ SIGN_NC1   = 1;} else { SIGN_NC1   = 0;}
	if (ledCharBuf[1].bits.BIT5){ SIGN_NC2   = 1;} else { SIGN_NC2   = 0;}
	if (ledCharBuf[1].bits.BIT6){ SIGN_DOT2  = 1;} else { SIGN_DOT2  = 0;}
}

// clang-format on

/**
 * @brief HEX 轉換為4位BCD碼顯示
 * LED_Num_BCD[0] High → LED_Num_BCD[3] Low
 * 最大顯示9999,超過1萬位以上不顯示,比如10000,顯示0000,54321顯示4321
 * 此顯示用於LED秤上,通常有一位小數點,所以小於10,比如9顯示09,十位0會顯示
 * @param number
 */
void LedScan7x6_dataBCDUpdate(uint16_t number)
{
    uint8_t i;
    uint16_t temp;
    temp = number;
    for (i = 4; i > 0;)
    {
        i--;
        ledNumBuf[i].byte = number % 10;
        number /= 10;
    }
    if (temp < 100)
    {
        ledNumBuf[0].byte = CHAR_OFF;
        ledNumBuf[1].byte = CHAR_OFF;
    }
    else if (temp < 1000)
    {
        ledNumBuf[0].byte = CHAR_OFF;
    }
}