/**
 * *************************************************************************************************************
 * @file Gpio.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Gpio firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
    *Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _GPIO_H_
#define _GPIO_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BH67F2495.h"

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
#define PIN_ModeOutput(p, n)        { _##p##c##n = 0;}
#define PIN_ModeInput(p, n)         { _##p##c##n = 1;}
#define PIN_OutputHigh(p, n)        { _##p####n = 1;}
#define PIN_OutputLow(p, n)         { _##p####n = 0;}
#define PIN_OutputInvert(p, n)      { _##p####n = ~_##p####n;}
#define PIN_PullHigh_Enable(p, n)   { _##p##pu##n = 1;}
#define PIN_PullHigh_Disable(p, n)  { _##p##pu##n = 0;}
#define PIN_WakeUp_Enable(p, n)     { _##p##wu##n = 1;}  //!< only pa port
#define PIN_WakeUp_Disable(p, n)    { _##p##wu##n = 0;}  //!< only pa port
#define PIN_IsHigh(p, n)              _##p####n == 1
#define PIN_IsLow(p, n)               _##p####n == 0
#define PIN_Data(p, n)                _##p####n

// clang-format on
// clang-format off
#define PIN_PA0_GPIO()      { _pas01 = 0; _pas00 = 0;}
#define PIN_PA0_PTP0I()     { _pas01 = 0; _pas00 = 0;}
#define PIN_PA0_XT1()       { _pas01 = 1; _pas00 = 1;}

#define PIN_PA1_GPIO()      { _pas03 = 0; _pas02 = 0;}
#define PIN_PA1_INT0()      { _pas03 = 0; _pas02 = 0;}
#define PIN_PA1_STCK()      { _pas03 = 0; _pas02 = 0; _stckps = 0;}
#define PIN_PA1_OSC1()      { _pas03 = 1; _pas02 = 1;}

#define PIN_PA2_GPIO()      { _pas05 = 0; _pas04 = 0;}
#define PIN_PA2_PTCK0()     { _pas05 = 0; _pas04 = 0;}
#define PIN_PA2_XT2()       { _pas05 = 1; _pas04 = 1;}

#define PIN_PA3_GPIO()      { _pas07 = 0; _pas06 = 0;}
#define PIN_PA3_PTP1I()     { _pas07 = 0; _pas06 = 0; _ptp1ips = 0;}
#define PIN_PA3_PTP1()      { _pas07 = 0; _pas06 = 1;}

#define PIN_PA4_GPIO()      { _pas11 = 0; _pas10 = 0;}
#define PIN_PA4_SDO()       { _pas11 = 0; _pas10 = 1;}
#define PIN_PA4_TX1()       { _pas11 = 1; _pas10 = 0; }

#define PIN_PA5_GPIO()      { _pas13 = 0; _pas12 = 0;}
#define PIN_PA5_STPI()      { _pas13 = 0; _pas12 = 0;}
#define PIN_PA5_SCS()       { _pas13 = 0; _pas12 = 1; _scsbps1 = 0; _scsbps0 = 1;}
#define PIN_PA5_RX1()       { _pas13 = 1; _pas12 = 0; _rx1tx1ps = 1;}
#define PIN_PA5_TX1()       { _pas13 = 1; _pas12 = 0;}
#define PIN_PA5_SEG32()     { _pas13 = 1; _pas12 = 1;}

#define PIN_PA6_GPIO()      { _pas15 = 0; _pas14 = 0;}
#define PIN_PA6_STCK()      { _pas15 = 0; _pas14 = 0; _stckps = 1;}
#define PIN_PA6_SCK()       { _pas15 = 0; _pas14 = 1; _scksclps1 = 0; _scksclps1 = 1;}
#define PIN_PA6_SCL()       { _pas15 = 0; _pas14 = 1; _scksclps1 = 0; _scksclps1 = 1;}
#define PIN_PA6_SEG31()     { _pas15 = 1; _pas14= 1;}

#define PIN_PA7_GPIO()      { _pas17 = 0; _pas16 = 0;}
#define PIN_PA7_ATCK()      { _pas17 = 0; _pas16 = 0;}
#define PIN_PA7_SDI()       { _pas17 = 0; _pas16 = 1; _sdisdaps1 = 0; _sdisdaps0 = 1;}
#define PIN_PA7_SDA()       { _pas17 = 0; _pas16 = 1; _sdisdaps1 = 0; _sdisdaps0 = 1;}
#define PIN_PA7_SEG30()     { _pas17 = 1; _pas16 = 1;}

#define PIN_PB0_GPIO()      { _pbs01 = 0; _pbs00 = 0;}
#define PIN_PB0_SEG29()     { _pbs01 = 1; _pbs00 = 1;}

#define PIN_PB1_GPIO()      { _pbs03 = 0; _pbs02 = 0;}
#define PIN_PB1_INT1()      { _pbs03 = 0; _pbs02 = 0;}
#define PIN_PB1_STPB()      { _pbs03 = 0; _pbs02 = 1;}
#define PIN_PB1_SEG28()     { _pbs03 =1; _pbs02 = 1;}


#define PIN_PB2_GPIO()      { _pbs05 = 0; _pbs04 = 0;}
#define PIN_PB2_INT2()      { _pbs05 = 0; _pbs04 = 0;}
#define PIN_PB2_STP()       { _pbs05 = 0; _pbs04 = 1;}
#define PIN_PB2_SCS()       { _pbs05 = 1; _pbs04 = 0; _scsbps1 = 1; _scsbps0 = 1;}
#define PIN_PB2_SEG27()     { _pbs05 = 1; _pbs04 = 1;}

#define PIN_PB3_GPIO()      { _pbs07 = 0; _pbs06 = 0;}
#define PIN_PB3_INT3()      { _pbs07 = 0; _pbs06 = 0;}
#define PIN_PB3_SCK()       { _pbs07 = 0; _pbs06 = 1; _scksclps1 = 1; _scksclps1 = 1;}
#define PIN_PB3_SCL()       { _pbs07 = 0; _pbs06 = 1; _scksclps1 = 1; _scksclps1 = 1;}
#define PIN_PB3_SEG26()     { _pbs07 = 1; _pbs06 = 1;}

#define PIN_PC2_GPIO()      { _pcs05 = 0; _pcs04 = 0;}
#define PIN_PC2_INT5()      { _pcs05 = 0; _pcs04 = 0;}
#define PIN_PC2_PTP1I()     { _pcs05 = 0; _pcs04 = 0; _ptp1ips = 1;}
#define PIN_PC2_PTP1()      { _pcs05 = 0; _pcs04 = 1;}
#define PIN_PC2_LVDIN()     { _pcs05 = 1; _pcs04 = 1;}

#define PIN_PC3_GPIO()      { _pcs07 = 0; _pcs06 = 0;}
#define PIN_PC3_PTCK1()     { _pcs07 = 0; _pcs06 = 0; _ptck1ps = 0;}
#define PIN_PC3_PTP0()      { _pcs07 = 0; _pcs06 = 1;}
#define PIN_PC3_VDDIO()     { _pcs07 = 1; _pcs06 = 1;}

#define PIN_PC4_GPIO()      { _pcs11 = 0; _pcs10 = 0;}
#define PIN_PC4_SCS()       { _pcs11 = 0; _pcs10 = 1; _scsbps1 = 1; _scsbps0 = 0;}

#define PIN_PC5_GPIO()      { _pcs13 = 0; _pcs12 = 0;}
#define PIN_PC5_SCK()       { _pcs13 = 0; _pcs12 = 1; _scksclps1 = 1; _scksclps1 = 0;}
#define PIN_PC5_SCL()       { _pcs13 = 0; _pcs12 = 1; _scksclps1 = 1; _scksclps1 = 0;}

#define PIN_PC6_GPIO()      { _pcs15 = 0; _pcs14 = 0;}
#define PIN_PC6_SDI()       { _pcs15 = 0; _pcs14 = 1; _sdisdaps1 = 1; _sdisdaps0 = 0;}
#define PIN_PC6_SDA()       { _pcs15 = 0; _pcs14 = 1; _sdisdaps1 = 1; _sdisdaps0 = 0;}
#define PIN_PC6_RX1()       { _pcs15 = 1; _pcs14 = 0; _rx1tx1ps = 0;}
#define PIN_PC6_TX1()       { _pcs15 = 1; _pcs14 = 0;}


#define PIN_PC7_GPIO()      { _pcs17 = 0; _pcs16 = 0;}
#define PIN_PC7_SDO()       { _pcs17 = 0; _pcs16 = 1;}
#define PIN_PC7_TX1()       { _pcs17 = 1; _pcs16 = 0;}

#define PIN_PD0_GPIO()      { _pds01 = 0; _pds00 = 0;}
#define PIN_PD0_COM4()      { _pds01 = 1; _pds00 = 0;}
#define PIN_PD0_SEG0()      { _pds01 = 1; _pds00 = 1;}

#define PIN_PD1_GPIO()      { _pds03 = 0; _pds02 = 0;}
#define PIN_PD1_COM5()      { _pds03 = 1; _pds02 = 0;}
#define PIN_PD1_SEG1()      { _pds03 = 1; _pds02 = 1;}

#define PIN_PD2_GPIO()      { _pds05 = 0; _pds04 = 0;}
#define PIN_PD2_COM6()      { _pds05 = 1; _pds04 = 0;}
#define PIN_PD2_SEG2()      { _pds05 = 1; _pds04 = 1;}

#define PIN_PD3_GPIO()      { _pds07 = 0; _pds06 = 0;}
#define PIN_PD3_COM7()      { _pds07 = 1; _pds06 = 0;}
#define PIN_PD3_SEG3()      { _pds07 = 1; _pds06 = 1;}

#define PIN_PD4_GPIO()      { _pds11 = 0; _pds10 = 0;}
#define PIN_PD4_SDO()       { _pds11 = 0; _pds10 = 1;}
#define PIN_PD4_TX0()       { _pds11 = 1; _pds10 = 0;}
#define PIN_PD4_SEG24()     { _pds11 = 1; _pds10 = 1;}

#define PIN_PD5_GPIO()      { _pds13 = 0; _pds12 = 0;}
#define PIN_PD5_SDI()       { _pds13 = 0; _pds12 = 1; _sdisdaps1 = 1; _sdisdaps0 = 1;}
#define PIN_PD5_SDA()       { _pds13 = 0; _pds12 = 1; _sdisdaps1 = 1; _sdisdaps0 = 1;}
#define PIN_PD5_RX0()       { _pds13 = 1; _pds12 = 0;}
#define PIN_PD5_TX0()       { _pds13 = 1; _pds12 = 0;}
#define PIN_PD5_SEG25()     { _pds13 = 1; _pds12 = 1;}

#define PIN_PD6_GPIO()      { _pds15 = 0; _pds14 = 0;}
#define PIN_PD6_INT4()      { _pds15 = 0; _pds14 = 0;}
#define PIN_PD6_PTP0B()     { _pds15 = 0; _pds14 = 1;}
#define PIN_PD6_OSC2()      { _pds15 = 1; _pds14 = 1;}

#define PIN_PE0_GPIO()      { _pes01 = 0; _pes00 = 0;}
#define PIN_PE0_SEG16()     { _pes01 = 1; _pes00 = 1;}

#define PIN_PE1_GPIO()      { _pes03 = 0; _pes02 = 0;}
#define PIN_PE1_SEG17()     { _pes03 = 1; _pes02 = 1;}

#define PIN_PE2_GPIO()      { _pes05 = 0; _pes04 = 0;}
#define PIN_PE2_SEG18()     { _pes05 = 1; _pes04 = 1;}

#define PIN_PE3_GPIO()      { _pes07 = 0; _pes06 = 0;}
#define PIN_PE3_SEG19()     { _pes07 = 1; _pes06 = 1;}

#define PIN_PE4_GPIO()      { _pes11 = 0; _pes10 = 0;}
#define PIN_PE4_SEG20()     { _pes11 = 1; _pes10 = 1;}

#define PIN_PE5_GPIO()      { _pes13 = 0; _pes12 = 0;}
#define PIN_PE5_SEG21()     { _pes13 = 1; _pes12 = 1;}

#define PIN_PE6_GPIO()      { _pes15 = 0; _pes14 = 0;}
#define PIN_PE6_SEG22()     { _pes15 = 1; _pes14 = 1;}

#define PIN_PE7_GPIO()      { _pes17 = 0; _pes16 = 0;}
#define PIN_PE7_SEG23()     { _pes17 = 1; _pes16 = 1;}

#define PIN_PF0_GPIO()      { _pfs01 = 0; _pfs00 = 0;}
#define PIN_PF0_SEG8()      { _pfs01 = 1; _pfs00 = 1;}

#define PIN_PF1_GPIO()      { _pfs03 = 0; _pfs02 = 0;}
#define PIN_PF1_SEG9()      { _pfs03 = 1; _pfs02 = 1;}

#define PIN_PF2_GPIO()      { _pfs05 = 0; _pfs04 = 0;}
#define PIN_PF2_SEG10()     { _pfs05 = 1; _pfs04 = 1;}

#define PIN_PF3_GPIO()      { _pfs07 = 0; _pfs06 = 0;}
#define PIN_PF3_SEG11()     { _pfs07 = 1; _pfs06 = 1;}

#define PIN_PF4_GPIO()      { _pfs11 = 0; _pfs10 = 0;}
#define PIN_PF4_SEG12()     { _pfs11 = 1; _pfs10 = 1;}

#define PIN_PF5_GPIO()      { _pfs13 = 0; _pfs12 = 0;}
#define PIN_PF5_SEG13()     { _pfs13 = 1; _pfs12 = 1;}

#define PIN_PF6_GPIO()      { _pfs15 = 0; _pfs14 = 0;}
#define PIN_PF6_SEG14()     { _pfs15 = 1; _pfs14 = 1;}

#define PIN_PF7_GPIO()      { _pfs17 = 0; _pfs16 = 0;}
#define PIN_PF7_SEG15()     { _pfs17 = 1; _pfs16 = 1;}

#define PIN_PG0_GPIO()      { _pgs01 = 0; _pgs00 = 0;}
#define PIN_PG0_C1()        { _pgs01 = 1; _pgs00 = 0;}
#define PIN_PG0_SEG33()     { _pgs01 = 1; _pgs00 = 1;}

#define PIN_PG1_GPIO()      { _pgs03 = 0; _pgs02 = 0;}
#define PIN_PG1_C2()        { _pgs03 = 1; _pgs02 = 0;}
#define PIN_PG1_SEG34()     { _pgs03 = 1; _pgs02 = 1;}

#define PIN_PG2_GPIO()      { _pgs05 = 0; _pgs04 = 0;}
#define PIN_PG2_V2()        { _pgs05 = 1; _pgs04 = 0;}
#define PIN_PG2_SEG35()     { _pgs05 = 1; _pgs04 = 1;}

#define PIN_PG3_GPIO()      { _pgs07 = 0; _pgs06 = 0;}
#define PIN_PG3_ATP()       { _pgs07 = 0; _pgs06 = 1;}
#define PIN_PG3_PWM1()      { _pgs07 = 0; _pgs06 = 1;}

#define PIN_PG4_GPIO()      { _pgs11 = 0; _pgs10 = 0;}
#define PIN_PG4_ATPB()      { _pgs11 = 0; _pgs10 = 1;}
#define PIN_PG4_PWM2()      { _pgs11 = 0; _pgs10 = 1;}

#define PIN_PC4_7_POWER_VDD()       { _pmps0 = 0; _pmps1 = 0;}
#define PIN_PA4_7_POWER_VDDIO()     { _pmps0 = 1; _pmps1 = 0;}
#define PIN_PA4_7_POWER_V33O()      { _pmps0 = 1; _pmps1 = 1;}

#define Pin_Lxt_Cfg()        { PIN_PA0_XT1(); PIN_PA2_XT2();}
#define Pin_Hxt_Cfg()        { PIN_PA1_OSC1(); PIN_PD6_OSC2();}

// clang-format on

#endif