/**
 * *************************************************************************************************************
 * @file Afe.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Afe firmware library
 * MCU / CFG Ver. :BH67F2495/1.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _Afe_H_
#define _Afe_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "..\driver\Adc24.h"
#include "..\board\BoardCfg.h"

/* user defined  UI-----------------------------------------------------------------------------------------*/
// !!! 若有需要修改请在BoardCfg.h文件中重新要修改的内容,此文件为自动生成文件，所有修改都可能被覆盖
#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 8000000    //!< 設置系統頻率，目前支援設置為 4000000,8000000,12000000
#endif
#ifndef SINE_WAVE_DYNAMIC_VPP
    #define SINE_WAVE_DYNAMIC_VPP true    //!< 动态调节sineWave 峰峰值，常用于生化节段，若不需要设置false可省ROM & RAM
#endif
#ifndef SINE_WAVE_VPP_MV
    #define SINE_WAVE_VPP_MV 200L    //!< sineWave 峰峰值，EIS_SINE_WAVE_DYNAMIC_VPP 为 false 时生效
#endif
#ifndef VOREG_VOLTAGE
    #define VOREG_VOLTAGE 2400L
#endif

/* Exported types ------------------------------------------------------------------------------------------*/
// clang-format off
#define VG_GND(connect)             { _vggnd = connect;}

#define DACn_To_Op1P(n, connect)    { _da##n##op1p = connect;}  //!< n = 1~2
#define DACn_To_Op2P(n, connect)    { _da##n##op2p = connect;}  //!< n = 1~2

#define AIn_To_adip(n, connect)     { _ai##n##adip = connect;} //!< n = 0~9 connect = true/false
#define AIn_To_adin(n, connect)     { _ai##n##adin = connect;} //!< n = 0~9 connect = true/false
#define AIn_To_DAC1(n, connect)     { _ai##n##da1 = connect;} //!< n = 0~7 connect = true/false
#define AIn_To_DAC2(n, connect)     { _ai##n##da2 = connect;} //!< n = 0~7 connect = true/false
#define AIn_To_SINO(n, connect)     { _ai##n##sino = connect;} //!< n = 0~4 connect = true/false
#define AIn_To_op1n(n, connect)     { _ai##n##op1n = connect;} //!< n = 0~4 connect = true/false
#define AIn_To_op1p(n, connect)     { _ai##n##op1p = connect;} //!< n = 5~9 connect = true/false
#define AIn_To_op1o(n, connect)     { _ai##n##op1o = connect;} //!< n = 5~9 connect = true/false
#define AIn_To_op2n(n, connect)     { _ai##n##op2n = connect;} //!< n = 0~4 connect = true/false
#define AIn_To_op2p(n, connect)     { _ai##n##op2p = connect;} //!< n = 5~9 connect = true/false
#define AIn_To_op2o(n, connect)     { _ai##n##op2o = connect;} //!< n = 5~9 connect = true/false
#define ADIP_AI_NC()         \
    {                     \
        _ai0adip = false; _ai1adip = false; _ai2adip = false; _ai3adip = false; _ai4adip = false; \
        _ai5adip = false; _ai6adip = false; _ai7adip = false; _ai8adip = false; _ai9adip = false; \
    }
#define ADIN_AI_NC()         \
    {                     \
        _ai0adin = false; _ai1adin = false; _ai2adin = false; _ai3adin = false; _ai4adin = false; \
        _ai5adin = false; _ai6adin = false; _ai7adin = false; _ai8adin = false; _ai9adin = false; \
    }
#define DAC1_AI_NC()         \
    {                     \
        _ai0da1 = false; _ai1da1 = false; _ai2da1 = false; _ai3da1 = false; \
        _ai4da1 = false; _ai5da1 = false; _ai6da1 = false; _ai7da1 = false; \
    }
#define DAC2_AI_NC()         \
    {                     \
        _ai0da2 = false; _ai1da2 = false; _ai2da2 = false; _ai3da2 = false; \
        _ai4da2 = false; _ai5da2 = false; _ai6da2 = false; _ai7da2 = false; \
    }
#define OP1N_AI_NC()   { _ai0op1n = false; _ai1op1n = false; _ai2op1n = false; _ai3op1n = false; _ai4op1n = false;}
#define OP1P_AI_NC()   { _ai5op1p = false; _ai6op1p = false; _ai7op1p = false; _ai8op1p = false; _ai9op1p = false;}
#define OP1O_AI_NC()   { _ai5op1o = false; _ai6op1o = false; _ai7op1o = false; _ai8op1o = false; _ai9op1o = false;}
#define OP2O_AI_NC()   { _ai5op2o = false; _ai6op2o = false; _ai7op2o = false; _ai8op2o = false; _ai9op2o = false;}
#define OP2N_AI_NC()   { _ai0op2n = false; _ai1op2n = false; _ai2op2n = false; _ai3op2n = false; _ai4op2n = false;}
#define OP2P_AI_NC()   { _ai5op2o = false; _ai6op2o = false; _ai7op2o = false; _ai8op2o = false; _ai9op2o = false;}
#define SINO_AI_NC()   { _ai0sino = false; _ai1sino = false; _ai2sino = false; _ai3sino = false; _ai4sino = false;}

// clang-format on
/* EIS------------------------------------------------*/
//!< ROM Size考慮只開啟需要使用的頻率，不要修改頻率對應的值
#define SINE_WAVE_FREQ_1KHZ    0     //!< 1khz
#define SINE_WAVE_FREQ_5KHZ    1     //!< 5khz
#define SINE_WAVE_FREQ_10KHZ   2     //!< 10khz
#define SINE_WAVE_FREQ_20KHZ   3     //!< 20khz
#define SINE_WAVE_FREQ_25KHZ   4     //!< 25khz
#define SINE_WAVE_FREQ_50KHZ   5     //!< 50khz
#define SINE_WAVE_FREQ_100KHZ  6     //!< 100khz
#define SINE_WAVE_FREQ_200KHZ  7     //!< 200khz
#define SINE_WAVE_FREQ_250KHZ  8     //!< 250khz
#define SINE_WAVE_FREQ_500KHZ  9     //!< 500khz
#define SINE_WAVE_FREQ_1000KHZ 10    //!< 1000khz
// #define SINE_WAVE_FREQ_1_5KHZ   11    //!< 1.5Khz
#define SINE_WAVE_FREQ_2KHZ 12    //!< 2khz
// #define SINE_WAVE_FREQ_1_5KHZ   11    //!< 1.5Khz

// OPA3 Gain
enum BOPA_GAIN {
    BOPA_GAINx1,
    BOPA_GAINx1_14,
    BOPA_GAINx1_31,
    BOPA_GAINx1_5,
    BOPA_GAINx1_73,
    BOPA_GAINx2,
    BOPA_GAINx2_33,
    BOPA_GAINx2_75,
    BOPA_GAINx3_285,
    BOPA_GAINx4,
    BOPA_GAINx5,
};

typedef struct {
    uint8_t freq;        //!< RW sine wave Frequency
    uint16_t vppMv;      //!< RW sine wave peak to peak voltage
    uint8_t bOpaGain;    //!< RW @see enum OPA_GAIN
} SineWave_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
//---Sine wave
void SineWave_Enable(SineWave_t *sine, uint8_t isIqMode);
void SineWave_Disable(void);

//----OPA n
#define OPAn_Enable(n)      {_opa##n##en = true;}     // n=1~3
#define OPAn_Disable(n)     {_opa##n##en = false;}    // n=1~3
void Opa1_VosCalibration(void);    //!< Opa Vos calibration
void Opa2_VosCalibration(void);    //!< Opa Vos calibration

#endif