/**
 * *************************************************************************************************************
 * @file Adc24.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Adc24 firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _ADC24_H_
#define _ADC24_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "BH67F2495.h"

/* Exported types ----------------------------------------------------------------------------------------*/
/*! adc sample rate enum */
typedef enum {
    ADC24_RATE_4HZ,
    ADC24_RATE_8HZ,
    ADC24_RATE_10HZ,
    ADC24_RATE_16HZ,
    ADC24_RATE_20HZ,
    ADC24_RATE_33HZ,
    ADC24_RATE_41HZ,
    ADC24_RATE_65HZ,
    ADC24_RATE_81HZ,
    ADC24_RATE_130HZ,
    ADC24_RATE_163HZ,
    ADC24_RATE_260HZ,
    ADC24_RATE_326HZ,
    ADC24_RATE_521HZ,
    ADC24_RATE_651HZ,
    ADC24_RATE_1302HZ,
    ADC24_RATE_488HZ,
    ADC24_RATE_390HZ,
} Adc24_SampleRate_e;

/*! Adc gain config */
typedef enum {
    ADC24_REFx1_GAINx1       = 0x00,    //!< Limited PGA input range adc_gain=1 Pga_gain=1
    ADC24_REFx1_GAINx2       = 0x01,    //!< Limited PGA input range adc_gain=1 Pga_gain=2
    ADC24_REFx1_GAINx4       = 0x02,    //!< Limited PGA input range adc_gain=1 Pga_gain=4
    ADC24_REFx1_GAINx8       = 0x03,    //!< Limited PGA input range adc_gain=1 Pga_gain=8
    ADC24_REFx1_GAINx16      = 0x04,    //!< Limited PGA input range adc_gain=1 Pga_gain=16
    ADC24_REFx1_GAINx32      = 0x05,    //!< Limited PGA input range adc_gain=1 Pga_gain=32
    ADC24_REFx1_GAINx64      = 0x0D,    //!< Limited PGA input range adc_gain=2 Pga_gain=32
    ADC24_REFx1_GAINx128     = 0x0E,    //!< Limited PGA input range adc_gain=2 Pga_gain=64
    ADC24_REFx1_GAINx256     = 0x0F,    //!< Limited PGA input range adc_gain=2 Pga_gain=128
    ADC24_REFx1_GAINx1BYPASS = 0x80,    //!< Minimal noise, but also minimal input impedance
    ADC24_REFx0_5_GAINx1     = 0x20,    //!< Limited PGA input range adc_gain=1 Pga_gain=1
    ADC24_REFx0_5_GAINx128   = 0x2E,    //!< Limited PGA input range adc_gain=4 Pga_gain=64
    ADC24_REFx1_GAINx1BUF    = 0x81,    //!< reference voltage fix x 1
} Adc24_Gain_e;

/*! Adc Dcset config */
typedef enum {
    ADC24_DCSET_0V      = (0 << 1),
    ADC24_DCSET_P_0_25V = (1 << 1),
    ADC24_DCSET_P_0_5V  = (2 << 1),
    ADC24_DCSET_P_0_75V = (3 << 1),
    ADC24_DCSET_N_0_25V = (5 << 1),
    ADC24_DCSET_N_0_5V  = (6 << 1),
    ADC24_DCSET_N_0_75V = (7 << 1),
} Adc24_DcSet_e;

/*! Adc channel negative config */
typedef enum {
    ADC24_CHP_ADIP_N_ADIN     = 0x01,
    ADC24_CHP_ADIN_N_ADIP     = 0x10,
    ADC24_CHP_MOD1OP_N_MOD1ON = 0x44,
    ADC24_CHP_MOD2OP_N_MOD2ON = 0x55,
    ADC24_CHP_DAC1O_N_AVSS    = 0x96,
    ADC24_CHP_DAC2O_N_AVSS    = 0x97,
    ADC24_CHP_AVSS_N_DAC1O    = 0x69,
    ADC24_CHP_AVSS_N_DAC2O    = 0x79,
    ADC24_CHP_AVDD5_N_AVDD6   = 0x88,
    ADC24_CHP_ADIP_N_AVSS     = 0x91
} Adc24_Channel_e;

/*! Adc reference voltage config */
typedef enum {
    ADC24_REF_DACVREF_AVSS = 0x00,
    ADC24_REF_VOREG_AVSS   = 0x01
} Adc24_RefVoltage_e;

/**
 * @brief adc config
 */
typedef struct
{
    uint8_t refVoltage;    //!< R/W @see Adc24_RefVoltage_e
    uint8_t sampleRate;    //!< R/W @see Adc24_SampleRate_e
    uint8_t gain;          //!< R/W @see Adc24_Gain_e
    uint8_t dcSet;         //!< R/W @see Adc24_DcSet_e
    uint8_t channel;       //!< R/W @see Adc24_Chanel_e
} Adc24_Cfg_t;

typedef struct
{
    union {
        struct {
            uint8_t byteLow;     //!< R adc data low byte
            uint8_t byteMid;     //!< R adc data mid byte
            uint8_t byteHigh;    //!< R adc data high byte
            uint8_t byteRes;     //!< R reserved
        } byte;

        int32_t adcData;    //!< R adc raw data
    } data;

    uint16_t samplingCnt;    //!< R adc sample count

    union {
        struct {
            uint8_t isReady : 1;    //!< R/W adc data is ready
        } b;

        uint8_t byte;
    } flag;
} Adc24_Source_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
extern volatile Adc24_Source_t adc24SourceData;
void Adc24_Cfg(Adc24_Cfg_t *Cfg);
void Adc24_Enable();
void Adc24_Disable();
void Adc24_Poling();
#define Adc24_Isr_Enable()   { _ade = 1;}
#define Adc24_Isr_Disable()  { _ade = 0;}
// clang-format on

#endif