/**
 * *************************************************************************************************************
 * @file Adc24.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Adc24 firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "stdbool.h"
#include "Adc24.h"
#include "AfePower.h"
#include "..\board\BoardCfg.h"

#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 12000000    //!< 設置系統頻率，目前支援設置為 12000000
#endif

// clang-format off
#define SET_ADC_ENABLE()			{ _adoff = 0; _adslp = 0;}
#define SET_ADC_DISABLE()			{ _adoff = 1; _adslp = 1; _pgabpbuf = 0;}
#define SET_ADC_START_CONVERT()		{ _adrst = 0; _adrst = 1; _adrst = 0; _adcdl = 0; _eoc = 0; }
#define SET_ADC_INPUT_SHORT(x)    	{ _inis = x;}

//!< adc data rate計算方式如下:
//!< FMCLK = fSYS/2/(ADCS+1) if ADCS=0x1F, FMCLK = fSYS
//!< SINC2 DataRate = FMCLK/(OSR*N*CHOP)
//!< SINC3 DataRate = FMCLK/(OSR*N)
#define FLMS30()            { _flms1=0; _flms0=0;}
#define FLMS12()            { _flms1=1; _flms0=0;}
#define CHOP1()             { _flms2=1;}
#define CHOP2()             { _flms2=0;}
#define OSR_32768()         { _ador3 = 0; _ador2=0; _ador1=0; _ador0=0;}
#define OSR_16384()         { _ador3 = 0; _ador2=0; _ador1=0; _ador0=1;}
#define OSR_8192()          { _ador3 = 0; _ador2=0; _ador1=1; _ador0=0;}
#define OSR_4096()          { _ador3 = 0; _ador2=0; _ador1=1; _ador0=1;}
#define OSR_2048()          { _ador3 = 0; _ador2=1; _ador1=0; _ador0=0;}
#define OSR_1024()          { _ador3 = 0; _ador2=1; _ador1=0; _ador0=1;}
#define OSR_512()           { _ador3 = 0; _ador2=1; _ador1=1; _ador0=0;}
#define OSR_256()           { _ador3 = 0; _ador2=1; _ador1=1; _ador0=1;}
#define OSR_128()           { _ador3 = 1; _ador2=0; _ador1=0; _ador0=0;}

#if SYS_CLOCK_FREQ == 4000000
#define SET_ADC_DATA_RATE2_5HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_32768();} // 5.08Hz
#define SET_ADC_DATA_RATE2_10HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_16384();} // 10.17Hz
#define SET_ADC_DATA_RATE2_20HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_8192(); } // 20.34Hz
#define SET_ADC_DATA_RATE2_41HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_4096(); } // 40.69Hz
#define SET_ADC_DATA_RATE2_81HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_2048(); } // 81.38Hz
#define SET_ADC_DATA_RATE2_163HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_1024(); } // 162.76Hz
#define SET_ADC_DATA_RATE2_326HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_512();  } // 325.52Hz
#define SET_ADC_DATA_RATE2_651HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_256();  } // 651.04Hz
#define SET_ADC_DATA_RATE2_1302HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS12(); OSR_128();  } // 1302.08Hz

#define SET_ADC_DATA_RATE2_2HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_32768();} // 2.03Hz
#define SET_ADC_DATA_RATE2_4HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_16384();} // 4.06Hz
#define SET_ADC_DATA_RATE2_8HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_8192(); } // 8.13Hz
#define SET_ADC_DATA_RATE2_16HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_4096(); } // 16.27Hz
#define SET_ADC_DATA_RATE2_33HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_2048(); } // 32.55Hz
#define SET_ADC_DATA_RATE2_65HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_1024(); } // 65.10Hz
#define SET_ADC_DATA_RATE2_130HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_512();  } // 130.20Hz
#define SET_ADC_DATA_RATE2_260HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_256();  } // 260.41Hz
#define SET_ADC_DATA_RATE2_521HZ()	{ _chop = 0xA0; _adcs=0x1F; CHOP2(); FLMS30(); OSR_128();  } // 520.83Hz

#define SET_ADC_DATA_RATE3_10HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_32768();} // 10.17Hz
#define SET_ADC_DATA_RATE3_20HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_16384();} // 20.34Hz
#define SET_ADC_DATA_RATE3_41HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_8192(); } // 40.69Hz
#define SET_ADC_DATA_RATE3_81HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_4096(); } // 81.38Hz
#define SET_ADC_DATA_RATE3_163HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_2048(); } // 162.76Hz
#define SET_ADC_DATA_RATE3_326HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_1024(); } // 325.52Hz
#define SET_ADC_DATA_RATE3_651HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_512();  } // 651.04Hz
#define SET_ADC_DATA_RATE3_1302HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_256();  } // 1302.08Hz
#define SET_ADC_DATA_RATE3_2604HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS12(); OSR_128();  } // 2604.16Hz

#define SET_ADC_DATA_RATE3_4HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_32768();} // 4.06Hz
#define SET_ADC_DATA_RATE3_8HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_16384();} // 8.13Hz
#define SET_ADC_DATA_RATE3_16HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_8192(); } // 16.27Hz
#define SET_ADC_DATA_RATE3_33HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_4096(); } // 32.55Hz
#define SET_ADC_DATA_RATE3_65HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_2048(); } // 65.10Hz
#define SET_ADC_DATA_RATE3_130HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_1024(); } // 130.20Hz
#define SET_ADC_DATA_RATE3_260HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_512();  } // 260.41Hz
#define SET_ADC_DATA_RATE3_521HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_256();  } // 520.83Hz
#define SET_ADC_DATA_RATE3_1042HZ()	{ _chop = 0xA3; _adcs=0x1F; CHOP1(); FLMS30(); OSR_128();  } // 1041.66Hz
#elif SYS_CLOCK_FREQ == 8000000
#define SET_ADC_DATA_RATE2_5HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_32768();} // 5.08Hz
#define SET_ADC_DATA_RATE2_10HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_16384();} // 10.17Hz
#define SET_ADC_DATA_RATE2_20HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_8192(); } // 20.34Hz
#define SET_ADC_DATA_RATE2_41HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_4096(); } // 40.69Hz
#define SET_ADC_DATA_RATE2_81HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_2048(); } // 81.38Hz
#define SET_ADC_DATA_RATE2_163HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_1024(); } // 162.76Hz
#define SET_ADC_DATA_RATE2_326HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_512();  } // 325.52Hz
#define SET_ADC_DATA_RATE2_651HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_256();  } // 651.04Hz
#define SET_ADC_DATA_RATE2_1302HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_128();  } // 1302.08Hz

#define SET_ADC_DATA_RATE2_2HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_32768();} // 2.03Hz
#define SET_ADC_DATA_RATE2_4HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_16384();} // 4.06Hz
#define SET_ADC_DATA_RATE2_8HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_8192(); } // 8.13Hz
#define SET_ADC_DATA_RATE2_16HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_4096(); } // 16.27Hz
#define SET_ADC_DATA_RATE2_33HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_2048(); } // 32.55Hz
#define SET_ADC_DATA_RATE2_65HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_1024(); } // 65.10Hz
#define SET_ADC_DATA_RATE2_130HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_512();  } // 130.20Hz
#define SET_ADC_DATA_RATE2_260HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_256();  } // 260.41Hz
#define SET_ADC_DATA_RATE2_521HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS30(); OSR_128();  } // 520.83Hz

#define SET_ADC_DATA_RATE3_10HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_32768();} // 10.17Hz
#define SET_ADC_DATA_RATE3_20HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_16384();} // 20.34Hz
#define SET_ADC_DATA_RATE3_41HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_8192(); } // 40.69Hz
#define SET_ADC_DATA_RATE3_81HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_4096(); } // 81.38Hz
#define SET_ADC_DATA_RATE3_163HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_2048(); } // 162.76Hz
#define SET_ADC_DATA_RATE3_326HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_1024(); } // 325.52Hz
#define SET_ADC_DATA_RATE3_651HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_512();  } // 651.04Hz
#define SET_ADC_DATA_RATE3_1302HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_256();  } // 1302.08Hz
#define SET_ADC_DATA_RATE3_2600HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS12(); OSR_128();  } // 2604.16Hz

#define SET_ADC_DATA_RATE3_4HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_32768();} // 4.06Hz
#define SET_ADC_DATA_RATE3_8HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_16384();} // 8.13Hz
#define SET_ADC_DATA_RATE3_16HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_8192(); } // 16.27Hz
#define SET_ADC_DATA_RATE3_33HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_4096(); } // 32.55Hz
#define SET_ADC_DATA_RATE3_65HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_2048(); } // 65.10Hz
#define SET_ADC_DATA_RATE3_130HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_1024(); } // 130.20Hz
#define SET_ADC_DATA_RATE3_260HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_512();  } // 260.41Hz
#define SET_ADC_DATA_RATE3_521HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_256();  } // 520.83Hz
#define SET_ADC_DATA_RATE3_1041HZ()	{ _chop = 0xA3; _adcs=0x00; CHOP1(); FLMS30(); OSR_128();  } // 1041.66Hz
#elif SYS_CLOCK_FREQ == 12000000
#define SET_ADC_DATA_RATE2_5HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_16384();} // 5.08Hz
#define SET_ADC_DATA_RATE2_10HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_8192(); } // 10.17Hz
#define SET_ADC_DATA_RATE2_20HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_4096(); } // 20.34Hz
#define SET_ADC_DATA_RATE2_41HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_2048(); } // 40.69Hz
#define SET_ADC_DATA_RATE2_81HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_1024(); } // 81.38Hz
#define SET_ADC_DATA_RATE2_163HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_512();  } // 162.76Hz
#define SET_ADC_DATA_RATE2_326HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_256();  } // 325.52Hz
#define SET_ADC_DATA_RATE2_488HZ()	{ _chop = 0xA0; _adcs=0x00; CHOP2(); FLMS12(); OSR_512();  } // 488.28Hz
#define SET_ADC_DATA_RATE2_651HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS12(); OSR_128();  } // 651.04Hz

#define SET_ADC_DATA_RATE2_4HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS30(); OSR_8192(); } // 4.06Hz
#define SET_ADC_DATA_RATE2_8HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS30(); OSR_4096(); } // 8.13Hz
#define SET_ADC_DATA_RATE2_16HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS30(); OSR_2048(); } // 16.27Hz
#define SET_ADC_DATA_RATE2_33HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS30(); OSR_1024(); } // 32.55Hz
#define SET_ADC_DATA_RATE2_65HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS30(); OSR_512();  } // 65.10Hz
#define SET_ADC_DATA_RATE2_130HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS30(); OSR_256();  } // 130.20Hz
#define SET_ADC_DATA_RATE2_260HZ()	{ _chop = 0xA0; _adcs=0x02; CHOP2(); FLMS30(); OSR_128();  } // 260.41Hz
#define SET_ADC_DATA_RATE2_390HZ()	{ _chop = 0xA0; _adcs=0x1f; CHOP2(); FLMS30(); OSR_512();  } // 390.62Hz

#define SET_ADC_DATA_RATE3_10HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_16384();} // 10.17Hz
#define SET_ADC_DATA_RATE3_20HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_8192(); } // 20.34Hz
#define SET_ADC_DATA_RATE3_41HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_4096(); } // 40.69Hz
#define SET_ADC_DATA_RATE3_81HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_2048(); } // 81.38Hz
#define SET_ADC_DATA_RATE3_163HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_1024(); } // 162.76Hz
#define SET_ADC_DATA_RATE3_326HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_512();  } // 325.52Hz
#define SET_ADC_DATA_RATE3_651HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_256();  } // 651.04Hz
#define SET_ADC_DATA_RATE3_1302HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS12(); OSR_128();  } // 1302.08Hz

#define SET_ADC_DATA_RATE3_4HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_16384();} // 4.06Hz
#define SET_ADC_DATA_RATE3_8HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_8192(); } // 8.13Hz
#define SET_ADC_DATA_RATE3_16HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_4096(); } // 16.27Hz
#define SET_ADC_DATA_RATE3_33HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_2048(); } // 32.55Hz
#define SET_ADC_DATA_RATE3_65HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_1024(); } // 65.10Hz
#define SET_ADC_DATA_RATE3_130HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_512();  } // 130.20Hz
#define SET_ADC_DATA_RATE3_260HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_256();  } // 260.41Hz
#define SET_ADC_DATA_RATE3_521HZ()	{ _chop = 0xA3; _adcs=0x02; CHOP1(); FLMS30(); OSR_128();  } // 520.83Hz
#endif
// clang-format on

volatile Adc24_Source_t adc24SourceData;

/**
 * @brief config adc sampleRate, gain, dcset, channel
 *
 * @param adcCfg @see AdcCfg_t
 */
void Adc24_Cfg(Adc24_Cfg_t *cfg)
{
    switch (cfg->sampleRate)
    {
        // case ADC24_RATE_4HZ: SET_ADC_DATA_RATE3_4HZ(); break;
        // case ADC24_RATE_8HZ: SET_ADC_DATA_RATE3_8HZ(); break;
        // case ADC24_RATE_10HZ: SET_ADC_DATA_RATE3_10HZ(); break;
        // case ADC24_RATE_16HZ: SET_ADC_DATA_RATE3_16HZ(); break;
        // case ADC24_RATE_20HZ: SET_ADC_DATA_RATE3_20HZ(); break;
        // case ADC24_RATE_33HZ: SET_ADC_DATA_RATE3_33HZ(); break;
        // case ADC24_RATE_41HZ: SET_ADC_DATA_RATE3_41HZ(); break;
        // case ADC24_RATE_65HZ: SET_ADC_DATA_RATE3_65HZ(); break;
        // case ADC24_RATE_81HZ: SET_ADC_DATA_RATE3_81HZ(); break;
        // case ADC24_RATE_130HZ: SET_ADC_DATA_RATE3_130HZ(); break;
        // case ADC24_RATE_163HZ: SET_ADC_DATA_RATE3_163HZ(); break;
        // case ADC24_RATE_260HZ: SET_ADC_DATA_RATE3_260HZ(); break;
        // case ADC24_RATE_326HZ: SET_ADC_DATA_RATE3_326HZ(); break;
        // case ADC24_RATE_521HZ: SET_ADC_DATA_RATE3_521HZ(); break;
        // case ADC24_RATE_651HZ: SET_ADC_DATA_RATE3_651HZ(); break;
        // case ADC24_RATE_1302HZ: SET_ADC_DATA_RATE3_1302HZ(); break;
        case ADC24_RATE_4HZ: SET_ADC_DATA_RATE2_4HZ(); break;
        case ADC24_RATE_8HZ: SET_ADC_DATA_RATE2_8HZ(); break;
        case ADC24_RATE_10HZ: SET_ADC_DATA_RATE2_10HZ(); break;
        case ADC24_RATE_16HZ: SET_ADC_DATA_RATE2_16HZ(); break;
        case ADC24_RATE_20HZ: SET_ADC_DATA_RATE2_20HZ(); break;
        case ADC24_RATE_33HZ: SET_ADC_DATA_RATE2_33HZ(); break;
        case ADC24_RATE_41HZ: SET_ADC_DATA_RATE2_41HZ(); break;
        case ADC24_RATE_65HZ: SET_ADC_DATA_RATE2_65HZ(); break;
        case ADC24_RATE_81HZ: SET_ADC_DATA_RATE2_81HZ(); break;
        case ADC24_RATE_130HZ: SET_ADC_DATA_RATE2_130HZ(); break;
        case ADC24_RATE_163HZ: SET_ADC_DATA_RATE2_163HZ(); break;
        case ADC24_RATE_260HZ: SET_ADC_DATA_RATE2_260HZ(); break;
        case ADC24_RATE_326HZ: SET_ADC_DATA_RATE2_326HZ(); break;
        case ADC24_RATE_651HZ: SET_ADC_DATA_RATE2_651HZ(); break;
#if (SYS_CLOCK_FREQ == 12000000)
        case ADC24_RATE_488HZ: SET_ADC_DATA_RATE2_488HZ(); break;
        case ADC24_RATE_390HZ: SET_ADC_DATA_RATE2_390HZ(); break;
#else
        case ADC24_RATE_521HZ: SET_ADC_DATA_RATE2_521HZ(); break;
        case ADC24_RATE_1302HZ: SET_ADC_DATA_RATE2_1302HZ(); break;
#endif
        default:
            break;
    }
    // adc gain configuration
    _pgac0 = cfg->gain;
    // adc channel
    _pgacs = cfg->channel;
    // dcset
    _pgac1 &= 0xF0;
    _pgac1 |= cfg->dcSet;
    // adc reference
    _vrefps = cfg->refVoltage;
}

/**
 * @brief adc convert start
 */
void Adc24_Enable()
{
    // SET_ADC_INPUT_SHORT(true);
    SET_ADC_ENABLE();
    SET_ADC_START_CONVERT();
    adc24SourceData.samplingCnt    = 0;
    adc24SourceData.flag.b.isReady = 0;
}

/**
 * @brief adc convert stop
 */
void Adc24_Disable()
{
    adc24SourceData.flag.b.isReady = 0;
    adc24SourceData.samplingCnt    = 0;
    SET_ADC_DISABLE();
}

void Adc24_Poling()
{
    if (_eoc == 1)
    {
        // ADC 轉換完成
        adc24SourceData.samplingCnt++;
        // 前三筆數據丟掉，第四筆才開始處理
        if (adc24SourceData.samplingCnt > 3)
        {
            // Read current ADC
            _adcdl                             = 1;
            adc24SourceData.data.byte.byteLow  = 0x00;
            adc24SourceData.data.byte.byteMid  = _adrl;
            adc24SourceData.data.byte.byteHigh = _adrm;
            adc24SourceData.data.byte.byteRes  = _adrh;
            _adcdl                             = 0;    // 數據讀取完成，取消鎖存
            adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
            adc24SourceData.flag.b.isReady     = 1;
        }
        _eoc = 0;
    }
}

//@------------ADC 中斷入口函數---------------@
DEFINE_ISR(ADC_ISR, 0x0C)
{
    if (_eoc == 1)
    {
        // ADC 轉換完成
        adc24SourceData.samplingCnt++;
        // 前三筆數據丟掉，第四筆才開始處理
        if (adc24SourceData.samplingCnt > 3)
        {
            // Read current ADC
            _adcdl                             = 1;
            adc24SourceData.data.byte.byteLow  = 0x00;
            adc24SourceData.data.byte.byteMid  = _adrl;
            adc24SourceData.data.byte.byteHigh = _adrm;
            adc24SourceData.data.byte.byteRes  = _adrh;
            _adcdl                             = 0;    // 數據讀取完成，取消鎖存
            adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
            adc24SourceData.flag.b.isReady     = 1;
        }
        _eoc = 0;
    }
}