/**
 * *************************************************************************************************************
 * @file EIS.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for EIS firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Eis.h"
#include <math.h>
#include <stdlib.h>
#include <BH67F2495.h>
#include "..\driver\stdbool.h"
#include "..\board\BoardCfg.h"
#include "..\driver\AfePower.h"
#include "..\driver\Afe.h"

#ifndef EIS_DEBUG
    #define EIS_DEBUG false
#endif

#if EIS_SAMPLING_RATE > ADC24_RATE_1300HZ
    #error "EIS_SAMPLING_RATE error"
#endif

#if EIS_DEBUG
uint8_t debugAdcCnt;
int16_t debugBuf[(EIS_SAMPLING_CNT * 4)];    // Rf_re,Rf_im,Rx_re,Rx_im
uint8_t debugAdcRate;
uint8_t debugAdcGain;
#endif

typedef struct
{
    int16_t rfZ;
#if EIS_PHASE_FUNCTION
    int16_t rfPhase;
#endif
    int16_t rxZ;
#if EIS_PHASE_FUNCTION
    int16_t rxPhase;
#endif
} ChannelAdcData_t;

ChannelAdcData_t eisChannelRaw;
static int32_t adcSum;
static int16_t *adcPointer;

#if EIS_PHASE_FUNCTION == true
    #define M_PI_1 3.14159265358979
    #define M_PI_2 1.57079632679489

/**
 * @brief 根據實部和虛部值計算相角值
 *
 * @param x 實部值,MOD1ON~MOD1OP
 * @param y 虛部值,MOD2ON~MOD2OP
 * @return double v 相角值
 */
double GetPhase(double x, double y)
{
    double v;
    if (fabs(x) >= fabs(y))
    {
        v = atan(y / x);
        if (x < 0.0)
        {
            if (y >= 0.0)
                v += M_PI_1;
            else
                v -= M_PI_1;
        }
    }
    else
    {
        v = -atan(x / y);
        if (y < 0.)
            v -= M_PI_2;
        else
            v += M_PI_2;
    }
    v = v * 1800 / M_PI_1;
    return v;
}
#endif

void Eis_aiMatrix(Eis_t *eis)
{
    // AC I2V OPA
    SINO_AI_NC();
    OP2O_AI_NC();
    OP2N_AI_NC();

    // Demodulator
    ADIP_AI_NC();
    ADIN_AI_NC();
    // clang-format off
    switch (eis->aiMatrix.sino)
    {
        case EIS_SINO_AI0:
            AIn_To_SINO(0, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adip(0, true)
            break;
        case EIS_SINO_AI1:
            AIn_To_SINO(1, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adip(1, true)
            break;
        case EIS_SINO_AI2:
            AIn_To_SINO(2, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adip(2, true)
            break;
        case EIS_SINO_AI3:
            AIn_To_SINO(3, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adip(3, true)
            break;
        case EIS_SINO_AI4:
            AIn_To_SINO(4, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adip(4, true)
            break;
        default:
            break;
    }
    switch (eis->aiMatrix.opn)
    {
        case EIS_OPN_AI0:
            AIn_To_op2n(0, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adin(0, true)
            else
                AIn_To_adip(0, true)
            break;
        case EIS_OPN_AI1:
            AIn_To_op2n(1, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adin(1, true)
            else
                AIn_To_adip(1, true)
            break;
        case EIS_OPN_AI2:
            AIn_To_op2n(2, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adin(2, true)
            else
                AIn_To_adip(2, true)
            break;
        case EIS_OPN_AI3:
            AIn_To_op2n(3, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adin(3, true)
            else
                AIn_To_adip(3, true)
            break;
        case EIS_OPN_AI4:
            AIn_To_op2n(4, true);
            if (eis->status.b.isMeasureRx)
                AIn_To_adin(4, true)
            else
                AIn_To_adip(4, true)
            break;
        default:
            break;
    }
    switch (eis->aiMatrix.opo)
    {
        case EIS_OPO_AI5:
            AIn_To_op2o(5, true);
            if (!eis->status.b.isMeasureRx)
                AIn_To_adin(5, true)
            break;
        case EIS_OPO_AI6:
            AIn_To_op2o(6, true);
            if (!eis->status.b.isMeasureRx)
                AIn_To_adin(6, true)
            break;
        case EIS_OPO_AI7:
            AIn_To_op2o(7, true);
            if (!eis->status.b.isMeasureRx)
                AIn_To_adin(7, true)
            break;
        case EIS_OPO_AI8:
            AIn_To_op2o(8, true);
            if (!eis->status.b.isMeasureRx)
                AIn_To_adin(8, true)
            break;
        case EIS_OPO_AI9:
            AIn_To_op2o(9, true);
            if (!eis->status.b.isMeasureRx)
                AIn_To_adin(9, true)
            break;
        default:
            break;
    }
    // clang-format on
    GCC_DELAY(10000);
    // ADC
    Adc24_Cfg_t adcCfg;
    adcCfg.dcSet      = ADC24_DCSET_0V;
    adcCfg.channel    = ADC24_CHP_MOD1OP_N_MOD1ON;
    adcCfg.refVoltage = ADC24_REF_VOREG_AVSS;
#if EIS_DEBUG == true
    adcCfg.gain       = debugAdcGain;
    adcCfg.sampleRate = debugAdcRate;
#else
    adcCfg.gain       = ADC24_REFx1_GAINx4;
    adcCfg.sampleRate = EIS_SAMPLING_RATE;
#endif
    Adc24_Cfg(&adcCfg);
    Adc24_Enable();
    adcSum = 0;
}

/**
 * @brief EIS 阻抗普測量
 *
 */
void Eis_Enable(Eis_t *eis)
{
    // DACO
    Dac_vref_Cfg(DAC_REF_VOREG);
    Dac2_Cfg(2048);
    Dac2_Enable();
    // I2V OPA2
    DACn_To_Op2P(2, true);
    Opa2_VosCalibration();    // OP2A OFFSET
    OPAn_Enable(2);
    // SINE WAVE
    SineWave_Enable(&eis->sineWave, true);
    eis->status.byte = 0x00;
    adcPointer       = &eisChannelRaw.rfZ;
    Eis_aiMatrix(eis);
#if EIS_DEBUG == true
    debugAdcCnt = 0;
#endif
}

void Eis_Loop(volatile Adc24_Source_t *adc24, Eis_t *eis)
{
#if EIS_DEBUG == true
    debugBuf[debugAdcCnt] = adc24->data.adcData >> 8;
    debugAdcCnt++;
#endif
    static int16_t adcRe;
    static int16_t adcIm;
    adcSum += adc24->data.adcData >> 8;
    if (adc24->samplingCnt < (EIS_SAMPLING_CNT + 3))
    {
        return;
    }
    // 满足采样次数，获取 Adc 平均值
    adcIm  = adcSum / EIS_SAMPLING_CNT;
    adcSum = 0;
    if (_pgacs == ADC24_CHP_MOD1OP_N_MOD1ON)
    {
        adcRe  = adcIm;
        _pgacs = ADC24_CHP_MOD2OP_N_MOD2ON;
        GCC_DELAY(10000);
        Adc24_Enable();
        return;
    }
    // Z-adc
    *adcPointer = (int16_t)sqrt((double)((int32_t)adcRe * adcRe + (int32_t)adcIm * adcIm));
    adcPointer++;
    // phase
#if EIS_PHASE_FUNCTION
    *adcPointer = GetPhase((double)adcRe, (double)adcIm);
    adcPointer++;
#endif

    if (eis->status.b.isMeasureRx)
    {
        eis->status.b.isMeasureRx = false;
        eis->impedanceZ           = (int32_t)((int32_t)EIS_RF_IMPEDANCE * eisChannelRaw.rxZ / eisChannelRaw.rfZ);
#if EIS_PHASE_FUNCTION
        eis->impedancePhase = eisChannelRaw.rfPhase - eisChannelRaw.rxPhase;
#endif
        eis->status.b.isReady = true;

        adcPointer = &eisChannelRaw.rfZ;
    }
    else
    {
        if (eisChannelRaw.rfZ < 100)    // 空載判斷
        {
            eis->status.b.isReady = true;
            eis->status.b.isNull  = true;

            adcPointer = &eisChannelRaw.rfZ;
        }
        else
        {
            eis->status.b.isNull      = false;
            eis->status.b.isMeasureRx = true;
        }
    }
    Eis_aiMatrix(eis);
}

void Eis_Disable(void)
{
    Adc24_Disable();
    OPAn_Disable(2);
    SineWave_Disable();
}