/**
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include <stdint.h>
#include "..\..\..\driver\wdt.h"
#include "..\..\..\driver\Oscillators.h"
#include "..\..\..\driver\Ram.h"
#include "..\..\..\driver\AfePower.h"
#include "..\..\..\driver\GPIO.h"
#include "..\..\..\driver\Adc24.h"
#include "..\..\..\driver\Uart.h"
#include "..\..\..\application\Eis.h"

Eis_t eis;
volatile uint8_t uartQueueBuf[20];    // 中断使用需要加 volatile
uint8_t uartTxBuf[70];

void EIS_EVM_TEST();

void main()
{
    // 判斷是否為上電復位或者非正常情況下的復位, 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
    if (_to == 0 || _pdf == 0)
    {
        // config sys clock
        Oscillators_Cfg();
        Ram_Clear();
        // config GPIO
        _pac = 0x00;
        _pa  = 0x00;
        _pbc = 0x00;
        _pb  = 0x00;
        _pcc = 0x00;
        _pc  = 0x00;
        _pdc = 0x00;
        _pd  = 0x00;
        _pec = 0x00;
        _pe  = 0x00;
        _pfc = 0x00;
        _pf  = 0x00;
        _pgc = 0x00;
        _pg  = 0x00;
        // Afe Power
        Voreg_Cfg(VOREG_2V4);
        Voreg_Enable();
        Viref_Cfg(0x80);    // Calibration viref, adjusted for different IC needs
        Viref_Enable();
        // config uart0
        uart0Status.rxBuf    = uartQueueBuf;            // 傳入緩存Buf地址
        uart0Status.rxBufLen = sizeof(uartQueueBuf);    // 傳入緩存Buf長度
        Uart_Cfg_t uartCfg;
        uartCfg.flag.b.addr   = false;
        uartCfg.flag.b.wakeUp = true;
        Uart0_Cfg(&uartCfg);
        Uart0_Enable();
        Uart0_Isr_Enable();
        // config aiMatrix
        eis.aiMatrix.sino = EIS_SINO_AI1;
        eis.aiMatrix.opn  = EIS_OPN_AI2;    // 可切換到AI2,AI3通道量測
        eis.aiMatrix.opo  = EIS_OPO_AI9;
        eis.sineWave.freq     = SINE_WAVE_FREQ_20KHZ;    // sineWave 频率
        eis.sineWave.bOpaGain = BOPA_GAINx1;
        eis.sineWave.vppMv    = 600;    // sineWave峰峰值
        Eis_Enable(&eis);
    }
    else
    {
        // WDT溢出復位初始化
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
        Adc24_Poling();
        if (adc24SourceData.flag.b.isReady)
        {
            adc24SourceData.flag.b.isReady = false;
            Eis_Loop(&adc24SourceData, &eis);
            if (eis.status.b.isNull)
            {
                // check  Papers  connect
                uint8_t txChar[] = "error: check Paper connect\r\n";
                Uart0_TxByte_Polling(txChar, sizeof(txChar));
            }
            else if (!eis.status.b.isReady)
            {
                // check  Papers  circuit
                uint8_t txChar[] = "measure error: no measure results\r\n";
                Uart0_TxByte_Polling(txChar, sizeof(txChar));
            }
            else
            {
#if EIS_PHASE_FUNCTION
                // impedance measurement is successful read impedance
                uint8_t txChar[] = "measure success: impedanceZ =      , impedancePhase =      \r\n";
                Int32ToString(eis.impedanceZ, &txChar[29]);
                Int32ToString(eis.impedancePhase, &txChar[53]);
                Uart0_TxByte_Polling(txChar, sizeof(txChar));
#else
                // impedance measurement is successful read impedance
                uint8_t txChar[] = "measure success:impedanceZ =      \r\n";
                Int32ToString(eis.impedanceZ, &txChar[28]);
                Uart0_TxByte_Polling(txChar, sizeof(txChar));
#endif
            }
        }
    }
}

void Adc_Cnt_Reset()
{
    adc24SourceData.samplingCnt = 0;
}