/**
 * *************************************************************************************************************
 * @file Spi.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Spi firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Spi.h"
#include "..\board\BoardCfg.h"

/**
 * @brief spi config
 *
 * @param Cfg @ref Spi_Cfg_t
 */
void Spi_Cfg(const Spi_Cfg_t *cfg)
{
#if defined(PIN_SCS_PB2)
    PIN_PB2_SCS();
#endif
#if defined(PIN_SCS_PA5)
    PIN_PA5_SCS();
#endif
#if defined(PIN_SCS_PC4)
    PIN_PC4_SCS();
#endif
#if defined(PIN_SCK_PB3)
    PIN_PB3_SCK();
#endif
#if defined(PIN_SCK_PA6)
    PIN_PA6_SCK();
#endif
#if defined(PIN_SCK_PC5)
    PIN_PC5_SCK();
#endif
#if defined(PIN_SDI_PD5)
    PIN_PD5_SDI();
#endif
#if defined(PIN_SDI_PA7)
    PIN_PA7_SDI();
#endif
#if defined(PIN_SDI_PC6)
    PIN_PC6_SDI();
#endif
#if defined(PIN_SDO_PC7)
    PIN_PC7_SDO();
#endif
#if defined(PIN_SDO_PD4)
    PIN_PD4_SDO();
#endif
#if defined(PIN_SDO_PA4)
    PIN_PA4_SDO();
#endif
    _simc0 = cfg->mode;
    _simc2 = cfg->csen + cfg->dataShift + cfg->sck_edge;
}

/**
 * @brief Spi 發送接收數據
 *
 * @param txData 發送的數據
 * @return uint8_t 接收的數據
 */
uint8_t Spi_TxRxByte(uint8_t txData)
{
    do
    {
        _wcol = 0x00;
        _simd = txData;
    } while (_wcol);
    while (!_trf)
    {
        ;
    }
    _trf = 0;
    return _simd;
}

DEFINE_ISR(SPI_ISR, 0x38)
{
    GCC_NOP();
    GCC_NOP();
    GCC_NOP();
}
