/**
 * *************************************************************************************************************
 * @file Lvr.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Lvr firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _LVR_H_
#define _LVR_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "stdbool.h"
#include "BH67F2495.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! the Low Voltage Reset section enum */
typedef enum {
    LVR_2_1V  = 0x55,
    LVR_2_55V = 0x33,
    LVR_3_15V = 0x99,
    LVR_3_8V  = 0xAA,
} Lvr_Voltage_e;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
/**
 * @brief the Low Voltage Reset configuration
 * @param type @see Lvr_Cfg_e
 */
#define Lvr_Cfg(type)       { _lvrc = type;}   //!< @see Lvr_Voltage_e
/**
 * @return true Low Voltage Reset Detected
 * @return false No Low Voltage Reset Detected
 *
 */
#define Lvr_IsDetected() _lvrf == true
#define Lvr_FlagClear()  { _lvrf = 0;}
// clang-format on

#endif