/**
 * *************************************************************************************************************
 * @file Lvd.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Lvd firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0
 *  # 主要功能
 *    * Low voltage detection configuration
 *    * Low voltage detection Enable
 *    * Low voltage detection Disable
 *    * Low voltage detection Status return
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _LVD_H_
#define _LVD_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "stdbool.h"
#include "BH67F2495.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! Low voltage detection enum */
typedef enum {
    LVD_LVDIN,    //!< When lvdin pin < 1.04V, Low voltage flag lvdo is 1
    LVD_2_2V,
    LVD_2_4V,
    LVD_2_7V,
    LVD_3_0V,
    LVD_3_3V,
    LVD_3_6V,
    LVD_4_0V,
} Lvd_Cfg_e;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
/**
 * @brief Low voltage detection configuration
 * @param type @see Lvd_Cfg_e
 */
#define Lvd_Cfg(type)    { _lvdc = type;}
#define Lvd_Enable()     { _lvden = 1; _vbgen = 1;}
#define Lvd_Disable()    { _lvden = 0; _vbgen = 0;}

/**
 * @note recommended to read after the lvd is enabled for 20us
 * @return true Low Voltage Detected
 * @return false No Low Voltage Detected
 *
 */
#define Lvd_IsDetected() _lvdo == true
// clang-format on

#endif