/**
 * *************************************************************************************************************
 * @file Afe.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Afe firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.1
 add 1.5KHz，优化70KHz和3.3KHz SineWave的输出

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Afe.h"
#include <BH67F2495.h>
#include "..\driver\stdbool.h"
#include "..\board\BoardCfg.h"
#include "..\driver\AfePower.h"

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 阻抗變設定 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// clang-format off
#define	SET_OPA3_GAIN(gain)		{ _opa3c &= 0xF0; _opa3c |= gain;}
// sineWave
#define Sine_Enable()           { _sgen = true;}
#define Sine_Disable()          { _sgen = false;}
#define SET_SINE_RESET()		{_sgiqrs = 1; _sgiqrs = 0;}
#define SET_SINE_MODE_IQ()	    { _iq_fwr = 0;}//!< Demodulator 輸出模式 IQ Mode  MOD1OP&MOD1ON 為實部信息,MOD2OP&MOD2ON 為虛部信息
#define SET_SINE_MODE_FWR()		{ _iq_fwr = 1;}//!< Demodulator 輸出模式 FWR Mode MOD1OP&MOD1ON 為Z值信息 ,MOD2OP&MOD2ON 無效
// sineWave Freq
static volatile int16_t SinDataRam[64] __attribute__ ((at(0x300)));
#if SYS_CLOCK_FREQ == 4000000
	#if defined(SINE_WAVE_FREQ_2_5KHZ)  && !defined(TABLE_64)
		#define TABLE_64
	#endif
	#if defined(SINE_WAVE_FREQ_70KHZ) && !defined(TABLE_56)
		#define TABLE_56
	#endif
	#if (defined(SINE_WAVE_FREQ_1KHZ)  || defined(SINE_WAVE_FREQ_5KHZ)  || \
	     defined(SINE_WAVE_FREQ_10KHZ) || defined(SINE_WAVE_FREQ_20KHZ) || \
	     defined(SINE_WAVE_FREQ_25KHZ) || defined(SINE_WAVE_FREQ_50KHZ) || \
	     defined(SINE_WAVE_FREQ_100KHZ) || defined(SINE_WAVE_FREQ_2KHZ)) && !defined(TABLE_40)
		#define TABLE_40
	#endif
	#if defined(SINE_WAVE_FREQ_1_5KHZ) && !defined(TABLE_36)
		#define TABLE_36
	#endif
	#if defined(SINE_WAVE_FREQ_200KHZ) && !defined(TABLE_20)
		#define TABLE_20
	#endif
	#if defined(SINE_WAVE_FREQ_250KHZ) && !defined(TABLE_16)
		#define TABLE_16
	#endif
	#if defined(SINE_WAVE_FREQ_3_3KHZ) && !defined(TABLE_12)
		#define TABLE_12
	#endif
	#if defined(SINE_WAVE_FREQ_500KHZ) && !defined(TABLE_8)
		#define TABLE_8
	#endif
	#if defined(SINE_WAVE_FREQ_1000KHZ) && !defined(TABLE_4)
		#define TABLE_4
	#endif
#endif
#if SYS_CLOCK_FREQ == 8000000
	#if (defined(SINE_WAVE_FREQ_1KHZ) || defined(SINE_WAVE_FREQ_2_5KHZ)|| \
	     defined(SINE_WAVE_FREQ_5KHZ) || defined(SINE_WAVE_FREQ_25KHZ))   \
	     && !defined(TABLE_64)
		#define TABLE_64
	#endif
	#if defined(SINE_WAVE_FREQ_50KHZ) && !defined(TABLE_60)
		#define TABLE_60
	#endif
	#if defined(SINE_WAVE_FREQ_70KHZ) && !defined(TABLE_56)
		#define TABLE_56
	#endif
	#if defined(SINE_WAVE_FREQ_1_5KHZ) && !defined(TABLE_48)
		#define TABLE_48
	#endif
	#if (defined(SINE_WAVE_FREQ_10KHZ) || defined(SINE_WAVE_FREQ_20KHZ)  || \
	     defined(SINE_WAVE_FREQ_50KHZ) || defined(SINE_WAVE_FREQ_100KHZ) || \
	     defined(SINE_WAVE_FREQ_200KHZ) || defined(SINE_WAVE_FREQ_2KHZ)) && !defined(TABLE_40)
		#define TABLE_40
	#endif
	#if defined(SINE_WAVE_FREQ_250KHZ) && !defined(TABLE_32)
		#define TABLE_32
	#endif
	#if defined(SINE_WAVE_FREQ_500KHZ) && !defined(TABLE_16)
		#define TABLE_16
	#endif
	#if defined(SINE_WAVE_FREQ_3_3KHZ) && !defined(TABLE_24)
		#define TABLE_24
	#endif
	#if defined(SINE_WAVE_FREQ_1000KHZ) && !defined(TABLE_8)
		#define TABLE_8
	#endif
#endif
#if SYS_CLOCK_FREQ == 12000000
	#if (defined(SINE_WAVE_FREQ_1KHZ) || defined(SINE_WAVE_FREQ_1_5KHZ)   || \
		 defined(SINE_WAVE_FREQ_2_5KHZ)) && !defined(TABLE_64)
	    #define TABLE_64
	#endif
	#if (defined(SINE_WAVE_FREQ_2KHZ) || defined(SINE_WAVE_FREQ_3_3KHZ)   || \
		 defined(SINE_WAVE_FREQ_70KHZ) || defined(SINE_WAVE_FREQ_200KHZ)) && !defined(TABLE_56)
	    #define TABLE_56
	#endif
	#if (defined(SINE_WAVE_FREQ_5KHZ) || defined(SINE_WAVE_FREQ_10KHZ)    || \
	 	 defined(SINE_WAVE_FREQ_5KHZ) || defined(SINE_WAVE_FREQ_10KHZ)) && !defined(TABLE_48)
		#define TABLE_48
	#endif
	#if (defined(SINE_WAVE_FREQ_20KHZ) || defined(SINE_WAVE_FREQ_25KHZ)    || \
	 	 defined(SINE_WAVE_FREQ_100KHZ)) && !defined(TABLE_40)
		#define TABLE_40
	#endif
	#if defined(SINE_WAVE_FREQ_500KHZ) && !defined(TABLE_24)
		#define TABLE_24
	#endif
	#if defined(SINE_WAVE_FREQ_1000KHZ) && !defined(TABLE_12)
		#define TABLE_12
	#endif
#endif
#if SINE_WAVE_DYNAMIC_VPP
    #define PEAK_SCALES 100L
#else
    #define PEAK_SCALES (SINE_WAVE_VPP_MV*100L/VOREG_VOLTAGE)
#endif
#define SINE(x)   	(x*PEAK_SCALES/100)
#ifdef TABLE_64
const int16_t SinData_Table64[64] = {
SINE(0),    SINE(50),   SINE(100),  SINE(148),  SINE(196),  SINE(241),  SINE(284),  SINE(324),  SINE(361),  SINE(395),
SINE(425),  SINE(451),  SINE(472),  SINE(489),  SINE(501),  SINE(509),  SINE(511),  SINE(509),  SINE(501),  SINE(489),
SINE(472),  SINE(451),  SINE(425),  SINE(395),  SINE(361),  SINE(324),  SINE(284),  SINE(241),  SINE(196),  SINE(148),
SINE(100),  SINE(50),   SINE(0),    SINE(-50),  SINE(-100), SINE(-148), SINE(-196), SINE(-241), SINE(-284), SINE(-324),
SINE(-361), SINE(-395), SINE(-425), SINE(-451), SINE(-472), SINE(-489), SINE(-501), SINE(-509), SINE(-511), SINE(-509),
SINE(-501), SINE(-489), SINE(-472), SINE(-451), SINE(-425), SINE(-395), SINE(-361), SINE(-324), SINE(-284), SINE(-241),
SINE(-196), SINE(-148), SINE(-100), SINE(-50),
};
#endif
#ifdef TABLE_60
const int16_t SinData_Table60[60] = {
SINE(0),    SINE(53),   SINE(106),  SINE(158),  SINE(208),  SINE(256),  SINE(300),  SINE(342),  SINE(380),  SINE(413),
SINE(443),  SINE(467),  SINE(486),  SINE(500),  SINE(508),  SINE(511),  SINE(508),  SINE(500),  SINE(486),  SINE(467),
SINE(443),  SINE(413),  SINE(380),  SINE(342),  SINE(300),  SINE(256),  SINE(208),  SINE(158),  SINE(106),  SINE(53),
SINE(0),    SINE(-53),  SINE(-106), SINE(-158), SINE(-208), SINE(-256), SINE(-300), SINE(-342), SINE(-380), SINE(-413),
SINE(-443), SINE(-467), SINE(-486), SINE(-500), SINE(-508), SINE(-511), SINE(-508), SINE(-500), SINE(-486), SINE(-467),
SINE(-443), SINE(-413), SINE(-380), SINE(-342), SINE(-300), SINE(-256), SINE(-208), SINE(-158), SINE(-106), SINE(-53),
};
#endif
#ifdef TABLE_56
const int16_t SinData_Table56[56] = {
SINE(0),    SINE(57),   SINE(114),  SINE(169),  SINE(222),  SINE(272),  SINE(319),  SINE(361),  SINE(400),  SINE(433),
SINE(460),  SINE(482),  SINE(498),  SINE(508),  SINE(511),  SINE(508),  SINE(498),  SINE(482),  SINE(460),  SINE(433),
SINE(400),  SINE(361),  SINE(319),  SINE(272),  SINE(222),  SINE(169),  SINE(114),  SINE(57),   SINE(0),    SINE(-57),
SINE(-114), SINE(-169), SINE(-222), SINE(-272), SINE(-319), SINE(-361), SINE(-400), SINE(-433), SINE(-460), SINE(-482),
SINE(-498), SINE(-508), SINE(-511), SINE(-508), SINE(-498), SINE(-482), SINE(-460), SINE(-433), SINE(-400), SINE(-361),
SINE(-319), SINE(-272), SINE(-222), SINE(-169), SINE(-114), SINE(-57),
};
#endif
#ifdef TABLE_48
const int16_t SinData_Table48[48] = {
SINE(0),    SINE(67),   SINE(132), SINE(196),   SINE(256), SINE(311),   SINE(361), SINE(405),   SINE(443),  SINE(472),
SINE(494),  SINE(507),  SINE(511),  SINE(507),  SINE(494),  SINE(472),  SINE(443),  SINE(405),  SINE(361),  SINE(311),
SINE(256),  SINE(196),  SINE(132),  SINE(67),   SINE(0),    SINE(-67),  SINE(-132), SINE(-196), SINE(-256), SINE(-311),
SINE(-361), SINE(-405), SINE(-443), SINE(-472), SINE(-494), SINE(-507), SINE(-511), SINE(-507), SINE(-494), SINE(-472),
SINE(-443), SINE(-405), SINE(-361), SINE(-311), SINE(-256), SINE(-196), SINE(-132), SINE(-67),
};
#endif
#ifdef TABLE_40
const int16_t SinData_Table40[40] = {
SINE(0),    SINE(80),   SINE(158),  SINE(232),  SINE(300),  SINE(361),  SINE(413),  SINE(455),  SINE(486),  SINE(505),
SINE(511),  SINE(505),  SINE(486),  SINE(455),  SINE(413),  SINE(361),  SINE(300),  SINE(232),  SINE(158),  SINE(80),
SINE(0),    SINE(-80),  SINE(-158), SINE(-232), SINE(-300), SINE(-361), SINE(-413), SINE(-455), SINE(-486), SINE(-505),
SINE(-511), SINE(-505), SINE(-486), SINE(-455), SINE(-413), SINE(-361), SINE(-300), SINE(-232), SINE(-158), SINE(-80),
};
#endif
#ifdef TABLE_36
const int16_t SinData_Table36[36] = {
SINE(0),    SINE(89),   SINE(175),  SINE(256),  SINE(328),  SINE(391),  SINE(443),  SINE(480),  SINE(503),  SINE(511),
SINE(503),  SINE(480),  SINE(443),  SINE(391),  SINE(328),  SINE(256),  SINE(175),  SINE(89),   SINE(0),    SINE(-89),
SINE(-175), SINE(-256), SINE(-328), SINE(-391), SINE(-443), SINE(-480), SINE(-503), SINE(-511), SINE(-503), SINE(-480),
SINE(-443), SINE(-391), SINE(-328), SINE(-256), SINE(-175), SINE(-89),
};
#endif
#ifdef TABLE_32
const int16_t SinData_Table32[32] = {
SINE(0),    SINE(100),  SINE(196),  SINE(284),  SINE(361),  SINE(425),  SINE(472),  SINE(501),  SINE(511),  SINE(501),
SINE(472),  SINE(425),  SINE(361),  SINE(284),  SINE(196),  SINE(100),  SINE(0),    SINE(-100), SINE(-196), SINE(-284),
SINE(-361), SINE(-425), SINE(-472), SINE(-501), SINE(-511), SINE(-501), SINE(-472), SINE(-425), SINE(-361), SINE(-284),
SINE(-196), SINE(-100),
};
#endif
#ifdef TABLE_24
const int16_t SinData_Table24[24] = {
SINE(0),    SINE(132),  SINE(256),  SINE(361),  SINE(443),  SINE(494),  SINE(511),  SINE(494),  SINE(443),  SINE(361),
SINE(256),  SINE(132),  SINE(0),    SINE(-132), SINE(-256), SINE(-361), SINE(-443), SINE(-494), SINE(-511), SINE(-494),
SINE(-443), SINE(-361), SINE(-256), SINE(-132),
};
#endif
#ifdef TABLE_20
const int16_t SinData_Table20[20] = {
SINE(0),    SINE(158),  SINE(300),  SINE(413),  SINE(486),  SINE(511),  SINE(486),  SINE(413),  SINE(300),  SINE(158),
SINE(0),    SINE(-158), SINE(-300), SINE(-413), SINE(-486), SINE(-511), SINE(-486), SINE(-413), SINE(-300), SINE(-158),
};
#endif
#ifdef TABLE_16
const int16_t SinData_Table16[16] = {
SINE(0),    SINE(196),  SINE(361),  SINE(472),  SINE(511),  SINE(472),  SINE(361),  SINE(196),  SINE(0),    SINE(-196),
SINE(-361), SINE(-472), SINE(-511), SINE(-472), SINE(-361), SINE(-196),
};
#endif
#ifdef TABLE_12
const int16_t SinData_Table12[12] = {
SINE(0),    SINE(256),  SINE(443),  SINE(511),  SINE(443),  SINE(256),  SINE(0),    SINE(-256), SINE(-443), SINE(-511),
SINE(-443), SINE(-256),
};
#endif
#ifdef TABLE_8
const int16_t SinData_Table8[8] = {
SINE(0),    SINE(361),  SINE(511),  SINE(361),  SINE(0),    SINE(-361), SINE(-511), SINE(-361),
};
#endif
#ifdef TABLE_4
const int16_t SinData_Table4[4] = {
SINE(0),    SINE(511),  SINE(0),    SINE(-511),
};
#endif

#if SYS_CLOCK_FREQ == 4000000
#define SET_SINE_TABLE_1KHz         SinData_Table40
#define SET_SINE_TABLE_1_5KHz       SinData_Table36
#define SET_SINE_TABLE_2KHz         SinData_Table40
#define SET_SINE_TABLE_2_5KHz       SinData_Table64
#define SET_SINE_TABLE_3_3KHz       SinData_Table12
#define SET_SINE_TABLE_5KHz         SinData_Table40
#define SET_SINE_TABLE_10KHz        SinData_Table40
#define SET_SINE_TABLE_20KHz        SinData_Table40
#define SET_SINE_TABLE_25KHz        SinData_Table40
#define SET_SINE_TABLE_50KHz        SinData_Table40
#define SET_SINE_TABLE_70KHz        SinData_Table56
#define SET_SINE_TABLE_100KHz       SinData_Table40
#define SET_SINE_TABLE_200KHz       SinData_Table20
#define SET_SINE_TABLE_250KHz       SinData_Table16
#define SET_SINE_TABLE_500KHz       SinData_Table8
#define SET_SINE_TABLE_1000KHz      SinData_Table4
#define SET_SINE_TABLE_NUM_1KHz     40
#define SET_SINE_TABLE_NUM_1_5KHz   36
#define SET_SINE_TABLE_NUM_2KHz     40
#define SET_SINE_TABLE_NUM_2_5KHz   64
#define SET_SINE_TABLE_NUM_3_3KHz   12
#define SET_SINE_TABLE_NUM_5KHz     40
#define SET_SINE_TABLE_NUM_10KHz    40
#define SET_SINE_TABLE_NUM_20KHz    40
#define SET_SINE_TABLE_NUM_25KHz    40
#define SET_SINE_TABLE_NUM_50KHz    40
#define SET_SINE_TABLE_NUM_70KHz    56
#define SET_SINE_TABLE_NUM_100KHz   40
#define SET_SINE_TABLE_NUM_200KHz   20
#define SET_SINE_TABLE_NUM_250KHz   16
#define SET_SINE_TABLE_NUM_500KHz   8
#define SET_SINE_TABLE_NUM_1000KHz  4
#define SET_SINE_FREQ_1KHz()		{ _sgn = 99; _sgdn = 39;}
#define SET_SINE_FREQ_1_5KHz()		{ _sgn = 73; _sgdn = 35;}  //!< 1501.5Hz
#define SET_SINE_FREQ_2KHz()		{ _sgn = 49; _sgdn = 39;}
#define SET_SINE_FREQ_2_5KHz()		{ _sgn = 24; _sgdn = 63;}
#define SET_SINE_FREQ_3_3KHz()		{ _sgn =100; _sgdn = 11;}  //!< 3.3003Khz
#define SET_SINE_FREQ_5KHz()		{ _sgn = 19; _sgdn = 39;}
#define SET_SINE_FREQ_10KHz()		{ _sgn =  9; _sgdn = 39;}
#define SET_SINE_FREQ_20KHz()		{ _sgn =  4; _sgdn = 39;}
#define SET_SINE_FREQ_25KHz()		{ _sgn =  3; _sgdn = 39;}
#define SET_SINE_FREQ_50KHz()       { _sgn =  1; _sgdn = 39;}
#define SET_SINE_FREQ_70KHz()		{ _sgn =  0; _sgdn = 55;}  //!< 71.428Khz
#define SET_SINE_FREQ_100KHz()		{ _sgn =  0; _sgdn = 39;}
#define SET_SINE_FREQ_200KHz()		{ _sgn =  0; _sgdn = 19;}
#define SET_SINE_FREQ_250KHz()		{ _sgn =  0; _sgdn = 15;}
#define SET_SINE_FREQ_500KHz()		{ _sgn =  0; _sgdn =  7;}
#define SET_SINE_FREQ_1000KHz()		{ _sgn =  0; _sgdn =  3;}
#endif
#if SYS_CLOCK_FREQ == 8000000
#define SET_SINE_TABLE_1KHz         SinData_Table64
#define SET_SINE_TABLE_1_5KHz       SinData_Table48
#define SET_SINE_TABLE_2KHz         SinData_Table40
#define SET_SINE_TABLE_2_5KHz       SinData_Table64
#define SET_SINE_TABLE_3_3KHz       SinData_Table24
#define SET_SINE_TABLE_5KHz         SinData_Table64
#define SET_SINE_TABLE_10KHz        SinData_Table40
#define SET_SINE_TABLE_20KHz        SinData_Table40
#define SET_SINE_TABLE_25KHz        SinData_Table64
#define SET_SINE_TABLE_50KHz        SinData_Table40
#define SET_SINE_TABLE_70KHz        SinData_Table56
#define SET_SINE_TABLE_100KHz       SinData_Table40
#define SET_SINE_TABLE_200KHz       SinData_Table40
#define SET_SINE_TABLE_250KHz       SinData_Table32
#define SET_SINE_TABLE_500KHz       SinData_Table16
#define SET_SINE_TABLE_1000KHz      SinData_Table8
#define SET_SINE_TABLE_NUM_1KHz     64
#define SET_SINE_TABLE_NUM_1_5KHz   48
#define SET_SINE_TABLE_NUM_2KHz     40
#define SET_SINE_TABLE_NUM_2_5KHz   64
#define SET_SINE_TABLE_NUM_3_3KHz   24
#define SET_SINE_TABLE_NUM_5KHz     64
#define SET_SINE_TABLE_NUM_10KHz    40
#define SET_SINE_TABLE_NUM_20KHz    40
#define SET_SINE_TABLE_NUM_25KHz    64
#define SET_SINE_TABLE_NUM_50KHz    40
#define SET_SINE_TABLE_NUM_70KHz    56
#define SET_SINE_TABLE_NUM_100KHz   40
#define SET_SINE_TABLE_NUM_200KHz   40
#define SET_SINE_TABLE_NUM_250KHz   32
#define SET_SINE_TABLE_NUM_500KHz   16
#define SET_SINE_TABLE_NUM_1000KHz  8
#define SET_SINE_FREQ_1KHz()		{ _sgn =124; _sgdn = 63;}
#define SET_SINE_FREQ_1_5KHz()		{ _sgn =110; _sgdn = 47;}  //!< 1501.5Hz
#define SET_SINE_FREQ_2KHz()		{ _sgn = 99; _sgdn = 39;}
#define SET_SINE_FREQ_2_5KHz()		{ _sgn = 49; _sgdn = 63;}
#define SET_SINE_FREQ_3_3KHz()		{ _sgn =100; _sgdn = 23;}  //!< 3.3003Khz
#define SET_SINE_FREQ_5KHz()		{ _sgn = 24; _sgdn = 63;}
#define SET_SINE_FREQ_10KHz()		{ _sgn = 19; _sgdn = 39;}
#define SET_SINE_FREQ_20KHz()		{ _sgn =  9; _sgdn = 39;}
#define SET_SINE_FREQ_25KHz()		{ _sgn =  4; _sgdn = 63;}
#define SET_SINE_FREQ_50KHz()		{ _sgn =  3; _sgdn = 39;}
#define SET_SINE_FREQ_70KHz()		{ _sgn =  1; _sgdn = 55;}  //!< 71.428Khz
#define SET_SINE_FREQ_100KHz()		{ _sgn =  1; _sgdn = 39;}
#define SET_SINE_FREQ_200KHz()		{ _sgn =  0; _sgdn = 39;}
#define SET_SINE_FREQ_250KHz()		{ _sgn =  0; _sgdn = 31;}
#define SET_SINE_FREQ_500KHz()		{ _sgn =  0; _sgdn = 15;}
#define SET_SINE_FREQ_1000KHz()		{ _sgn =  0; _sgdn =  7;}
#endif
#if SYS_CLOCK_FREQ == 12000000
#define SET_SINE_TABLE_1KHz         SinData_Table64
#define SET_SINE_TABLE_1_5KHz       SinData_Table64
#define SET_SINE_TABLE_2KHz         SinData_Table56
#define SET_SINE_TABLE_2_5KHz       SinData_Table64
#define SET_SINE_TABLE_3_3KHz       SinData_Table56
#define SET_SINE_TABLE_5KHz         SinData_Table48
#define SET_SINE_TABLE_10KHz        SinData_Table48
#define SET_SINE_TABLE_20KHz        SinData_Table40
#define SET_SINE_TABLE_25KHz        SinData_Table40
#define SET_SINE_TABLE_50KHz        SinData_Table48
#define SET_SINE_TABLE_70KHz        SinData_Table56
#define SET_SINE_TABLE_100KHz       SinData_Table40
#define SET_SINE_TABLE_200KHz       SinData_Table56
#define SET_SINE_TABLE_250KHz       SinData_Table48
#define SET_SINE_TABLE_500KHz       SinData_Table24
#define SET_SINE_TABLE_1000KHz      SinData_Table12
#define SET_SINE_TABLE_NUM_1KHz     64
#define SET_SINE_TABLE_NUM_1_5KHz   64
#define SET_SINE_TABLE_NUM_2KHz     56
#define SET_SINE_TABLE_NUM_2_5KHz   64
#define SET_SINE_TABLE_NUM_3_3KHz   56
#define SET_SINE_TABLE_NUM_5KHz     48
#define SET_SINE_TABLE_NUM_10KHz    48
#define SET_SINE_TABLE_NUM_20KHz    40
#define SET_SINE_TABLE_NUM_25KHz    40
#define SET_SINE_TABLE_NUM_50KHz    48
#define SET_SINE_TABLE_NUM_70KHz    56
#define SET_SINE_TABLE_NUM_100KHz   40
#define SET_SINE_TABLE_NUM_200KHz   56
#define SET_SINE_TABLE_NUM_250KHz   48
#define SET_SINE_TABLE_NUM_500KHz   24
#define SET_SINE_TABLE_NUM_1000KHz  12
#define SET_SINE_FREQ_1KHz()		{ _sgn =186; _sgdn = 63;}
#define SET_SINE_FREQ_1_5KHz()		{ _sgn =124; _sgdn = 63;}  //!< 1500Hz
#define SET_SINE_FREQ_2KHz()		{ _sgn =106; _sgdn = 55;}
#define SET_SINE_FREQ_2_5KHz()		{ _sgn = 74; _sgdn = 63;}
#define SET_SINE_FREQ_3_3KHz()		{ _sgn = 64; _sgdn = 55;}  //!< 3.3003Khz
#define SET_SINE_FREQ_5KHz()		{ _sgn = 49; _sgdn = 47;}
#define SET_SINE_FREQ_10KHz()		{ _sgn = 24; _sgdn = 47;}
#define SET_SINE_FREQ_20KHz()		{ _sgn = 14; _sgdn = 39;}
#define SET_SINE_FREQ_25KHz()		{ _sgn = 11; _sgdn = 39;}
#define SET_SINE_FREQ_50KHz()		{ _sgn =  4; _sgdn = 47;}
#define SET_SINE_FREQ_70KHz()		{ _sgn =  2; _sgdn = 55;}  //!< 71.428Khz
#define SET_SINE_FREQ_100KHz()		{ _sgn =  2; _sgdn = 39;}
#define SET_SINE_FREQ_200KHz()		{ _sgn =  0; _sgdn = 55;}
#define SET_SINE_FREQ_250KHz()		{ _sgn =  0; _sgdn = 47;}
#define SET_SINE_FREQ_500KHz()		{ _sgn =  0; _sgdn = 23;}
#define SET_SINE_FREQ_1000KHz()		{ _sgn =  0; _sgdn = 11;}
#endif
// clang-format on

/**
 * @brief SineWave使能
 * @note need set AI0~5 to SINO,then you can see the waveform
 *
 */
void SineWave_Enable(SineWave_t *sine, uint8_t isIqMode)
{
    SET_OPA3_GAIN(sine->bOpaGain);
    OPAn_Enable(3);    // reset 前OPA3必須開啟
    Sine_Disable();    // 載入Sine wave Data 前必須關閉 Sine 發生器
#if SINE_WAVE_DYNAMIC_VPP
    int32_t vppMv = sine->vppMv;
#endif
    uint8_t i;
    switch (sine->freq)
    {
#ifdef SINE_WAVE_FREQ_1KHZ
        case SINE_WAVE_FREQ_1KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_1KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_1KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_1KHz[i];
    #endif
            }
            SET_SINE_FREQ_1KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_1_5KHZ
        case SINE_WAVE_FREQ_1_5KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_1_5KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_1_5KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_1_5KHz[i];
    #endif
            }
            SET_SINE_FREQ_1_5KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_2KHZ
        case SINE_WAVE_FREQ_2KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_2KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_2KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_2KHz[i];
    #endif
            }
            SET_SINE_FREQ_2KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_2_5KHZ
        case SINE_WAVE_FREQ_2_5KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_2_5KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_2_5KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_2_5KHz[i];
    #endif
            }
            SET_SINE_FREQ_2_5KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_3_3KHZ
        case SINE_WAVE_FREQ_3_3KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_3_3KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_3_3KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_3_3KHz[i];
    #endif
            }
            SET_SINE_FREQ_3_3KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_5KHZ
        case SINE_WAVE_FREQ_5KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_5KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_5KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_5KHz[i];
    #endif
            }
            SET_SINE_FREQ_5KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_10KHZ
        case SINE_WAVE_FREQ_10KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_10KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_10KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_10KHz[i];
    #endif
            }
            SET_SINE_FREQ_10KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_20KHZ
        case SINE_WAVE_FREQ_20KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_20KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_20KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_20KHz[i];
    #endif
            }
            SET_SINE_FREQ_20KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_25KHZ
        case SINE_WAVE_FREQ_25KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_25KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_25KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_25KHz[i];
    #endif
            }
            SET_SINE_FREQ_25KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_50KHZ
        case SINE_WAVE_FREQ_50KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_50KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_50KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_50KHz[i];
    #endif
            }
            SET_SINE_FREQ_50KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_70KHZ
        case SINE_WAVE_FREQ_70KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_70KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_70KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_70KHz[i];
    #endif
            }
            SET_SINE_FREQ_70KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_100KHZ
        case SINE_WAVE_FREQ_100KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_100KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_100KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_100KHz[i];
    #endif
            }
            SET_SINE_FREQ_100KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_200KHZ
        case SINE_WAVE_FREQ_200KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_200KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_200KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_200KHz[i];
    #endif
            }
            SET_SINE_FREQ_200KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_250KHZ
        case SINE_WAVE_FREQ_250KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_250KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_250KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_250KHz[i];
    #endif
            }
            SET_SINE_FREQ_250KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_500KHZ
        case SINE_WAVE_FREQ_500KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_500KHz; i++)
            {
    #if SINE_WAVE_DYNAMIC_VPP
                SinDataRam[i] = (int16_t)(SET_SINE_TABLE_500KHz[i] * vppMv / VOREG_VOLTAGE);
    #else
                SinDataRam[i] = SET_SINE_TABLE_500KHz[i];
    #endif
            }
            SET_SINE_FREQ_500KHz();
            break;
#endif
#ifdef SINE_WAVE_FREQ_1000KHZ
        // 1000KHz 有嚴重的衰減，無法獲取準確的峰峰值，不建議使用
        case SINE_WAVE_FREQ_1000KHZ:
            for (i = 0; i < SET_SINE_TABLE_NUM_1000KHz; i++)
            {
                SinDataRam[i] = SET_SINE_TABLE_1000KHz[i];
            }
            SET_SINE_FREQ_1000KHz();
            break;
#endif
        default:
            break;
    }
    // offset to 0.5Voreg
    for (i = 0; i < 64; i++)
    {
        SinDataRam[i] += 512;
    }
    if (isIqMode)
    {
        SET_SINE_MODE_IQ();
    }
    else
    {
        SET_SINE_MODE_FWR();
    }
    SET_SINE_RESET();
    Sine_Enable();
}

void SineWave_Disable(void)
{
    Sine_Disable();
    OPAn_Disable(3);
}

void Opa1_VosCalibration(void)
{
#define OPA_REG    _opa1c
#define OPA_OUTPUT _op1do
    uint8_t i, opDo = 0, opVos1 = 0, opVos2 = 0;
    OPA_REG = 0xE0;    // enter calibration Vos mode and select DACnO as the reference input
    GCC_DELAY(1000);
    if (OPA_OUTPUT)
        opDo = true;
    else
        opDo = false;

    for (i = 0; i < 32; i++)
    {
        OPA_REG++;
        GCC_DELAY(1000);
        if (OPA_OUTPUT != opDo)
        {
            opVos1 = OPA_REG & 0x1f;
            break;
        }
    }

    OPA_REG = 0xFF;
    GCC_DELAY(1000);
    if (OPA_OUTPUT)
        opDo = true;
    else
        opDo = false;

    for (i = 0; i < 32; i++)
    {
        OPA_REG--;
        GCC_DELAY(1000);
        if (OPA_OUTPUT != opDo)
        {
            opVos2 = OPA_REG & 0x1f;
            break;
        }
    }
    OPA_REG = (opVos1 + opVos2) / 2;
    OPA_REG &= 0x1F;
#undef OPA_REG
#undef OPA_OUTPUT
}

void Opa2_VosCalibration(void)
{
#define OPA_REG    _opa2c
#define OPA_OUTPUT _op2do
    uint8_t i, opDo = 0, opVos1 = 0, opVos2 = 0;
    OPA_REG = 0xE0;    // enter calibration Vos mode and select DACnO as the reference input
    GCC_DELAY(1000);
    if (OPA_OUTPUT)
        opDo = true;
    else
        opDo = false;

    for (i = 0; i < 32; i++)
    {
        OPA_REG++;
        GCC_DELAY(1000);
        if (OPA_OUTPUT != opDo)
        {
            opVos1 = OPA_REG & 0x1f;
            break;
        }
    }

    OPA_REG = 0xFF;
    GCC_DELAY(1000);
    if (OPA_OUTPUT)
        opDo = true;
    else
        opDo = false;

    for (i = 0; i < 32; i++)
    {
        OPA_REG--;
        GCC_DELAY(1000);
        if (OPA_OUTPUT != opDo)
        {
            opVos2 = OPA_REG & 0x1f;
            break;
        }
    }
    OPA_REG = (opVos1 + opVos2) / 2;
    OPA_REG &= 0x1F;
#undef OPA_REG
#undef OPA_OUTPUT
}