/**
 * *************************************************************************************************************
 * @file EIS.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for EIS firmware library
 * MCU / CFG Ver. :BH67F2495/1.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _EIS_H_
#define _EIS_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "..\driver\Adc24.h"
#include "..\driver\Afe.h"
#include "..\board\BoardCfg.h"

/* user defined  UI-----------------------------------------------------------------------------------------*/
// !!! 若有需要修改请在BoardCfg.h文件中重新要修改的内容,此文件为自动生成文件，所有修改都可能被覆盖
#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 8000000    //!< 設置系統頻率，目前支援設置為 4000000,8000000,12000000
#endif
#ifndef EIS_SAMPLING_CNT
    #define EIS_SAMPLING_CNT 8    //!<量測次數
#endif
#ifndef EIS_SAMPLING_RATE
    #define EIS_SAMPLING_RATE ADC24_RATE_326HZ    //!< ADC 采集速率
#endif
#ifndef EIS_PHASE_FUNCTION
    #define EIS_PHASE_FUNCTION true    //!<是否需要相位功能
#endif
#ifndef EIS_RF_IMPEDANCE
    #define EIS_RF_IMPEDANCE 3000    //!< Rf參考阻值
#endif

/* Exported types ------------------------------------------------------------------------------------------*/
enum Eis_AiMatrix_SINO {
    EIS_SINO_AI0,
    EIS_SINO_AI1,
    EIS_SINO_AI2,
    EIS_SINO_AI3,
    EIS_SINO_AI4,
};

enum Eis_AiMatrix_OPN {
    EIS_OPN_AI0,
    EIS_OPN_AI1,
    EIS_OPN_AI2,
    EIS_OPN_AI3,
    EIS_OPN_AI4,
};

enum Eis_AiMatrix_OPO {
    EIS_OPO_AI5,
    EIS_OPO_AI6,
    EIS_OPO_AI7,
    EIS_OPO_AI8,
    EIS_OPO_AI9,
};

typedef struct {
    uint8_t sino;    //!< RW  @see enum Eis_AiMatrix_SINO
    uint8_t opn;     //!< RW @see enum Eis_AiMatrix_OPN
    uint8_t opo;     //!< RW @see enum Eis_AiMatrix_OPO
} Eis_AiMatrix_t;

typedef struct {
    union {
        struct {
            uint8_t isReady     : 1;    //!< R 完成一次結果的獲取
            uint8_t isNull      : 1;    //!< R 未偵測到待測物
            uint8_t isMeasureRx : 1;    //!< R 內部狀態控制
        } b;

        uint8_t byte;
    } status;    //!< R 量測狀態

    int32_t impedanceZ;    //!< R 阻抗值
#if EIS_PHASE_FUNCTION
    int16_t impedancePhase;    //!< R 阻抗相位角
#endif
    Eis_AiMatrix_t aiMatrix;    //!< RW Eis開關矩陣配置
    SineWave_t sineWave;        //!< RW Eis sineWave配置
} Eis_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// EIS 電化學阻抗譜
void Eis_Enable(Eis_t *eis);
void Eis_Loop(volatile Adc24_Source_t *adc24, Eis_t *eis);
void Eis_Disable(void);

#endif