/**
 * *************************************************************************************************************
 * @file BodyScales.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for BodyScales firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0
 * # 主要功能
 * * 自動標定,標定重量固定為50Kg/50Kg/50Kg
 * * 手動標定,標定重量固定為50Kg/50Kg/50Kg
 * * 穩定重量解鎖,重量用戶可自行設置
 * * 臨時重量解鎖,重量用戶可自行設置
 * * 自動喚醒,重量用戶可自行設置

 * 零点更新规则

 * (稳定重量值) <= (显式更新值),立即更新零点值

   1. (显式更新值) == (静默更新值) 关闭零点更新提示，isUpdateZero 无效

   2. (显式更新值) > (静默更新值)

      LoadDown后 (静默更新值) < 稳定重量值 < (显式更新值) 置位 isUpdateZero 用于需要显示 零点更新状态的产品

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _BODY_SCALES_H_
#define _BODY_SCALES_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "..\driver\stdbool.h"
#include "..\board\BoardCfg.h"

/* user defined  UI-----------------------------------------------------------------------------------------*/
// !!! 若有需要修改请在BoardCfg.h文件中重新要修改的内容,此文件为自动生成文件，所有修改都可能被覆盖
#ifndef BODY_SCALES_RESOLUTION
    #define BODY_SCALES_RESOLUTION (50)    //!< 最小解析度 50g 0.1斤
#endif
#ifndef BODY_SCALES_MIN
    #define BODY_SCALES_MIN (2000 / BODY_SCALES_RESOLUTION)    //!< 起秤重量，小于此重量重量强制清除为0
#endif
#ifndef BODY_SCALES_OVERLOAD
    #define BODY_SCALES_OVERLOAD (183000 / BODY_SCALES_RESOLUTION)    //!< 超载重量 必须大于最大量程
#endif
#ifndef BODY_SCALES_AUTOON
    #define BODY_SCALES_AUTOON (5000 / BODY_SCALES_RESOLUTION)    //!< 开机/自动唤醒重量
#endif
#ifndef WEIGHT_UNLOCK_TEMP
    #define WEIGHT_UNLOCK_TEMP (5000 / BODY_SCALES_RESOLUTION)    //!< 变化重量不下秤解鎖值 0 必须下称才能解锁
#endif
#ifndef WEIGHT_UNLOCK_STATE
    #define WEIGHT_UNLOCK_STATE (300 / BODY_SCALES_RESOLUTION)    //!< 穩定重量不下秤解锁值 0 必须下称才能解锁
#endif
#ifndef BODY_SCALES_MEMORY_CNT
    #define BODY_SCALES_MEMORY_CNT 0    //!< 多少笔记忆值,   0 不做记忆
#endif
#ifndef WEIGHT_MEMORY_WEIGHT
    #define WEIGHT_MEMORY_WEIGHT (200 / BODY_SCALES_RESOLUTION)    //!< 记忆的重量值
#endif
#ifndef WEIGHT_AUTO_ON
    #define WEIGHT_AUTO_ON true    //!< 自动上称功能是否开启
#endif
#ifndef BODY_SCALES_ZERO_UPDATE_EXPLICIT
    #define BODY_SCALES_ZERO_UPDATE_EXPLICIT (3000 / BODY_SCALES_RESOLUTION)    //!< 显式更新值
#endif
#ifndef BODY_SCALES_ZERO_UPDATE_SILENCE
    #define BODY_SCALES_ZERO_UPDATE_SILENCE (3000 / BODY_SCALES_RESOLUTION)    //!< 静默更新值
#endif
#ifndef ADC_DATA_BITS_IS16
    #define ADC_DATA_BITS_IS16 false    //!< 重量计算是否采用16bit 可以节省ROM和RAM，但是精度稍差
#endif

/* user defined fitter-------------------------------------------------------------------------------------*/
#ifndef STABLE_CNT
    #define STABLE_CNT 8    //!< 數值越小，称重越快,精度越差  建議 8 ~ 16
#endif
#ifndef STABLE_THRESHOLD
    #define STABLE_THRESHOLD 100    //!< 數值越大，称重越快,精度越差  建議 2 * Span (Span: 最小解析度对应的Adc 值)
#endif

/* user defined calibrations------------------------------------------------------------------------------*/
#ifndef BODY_SCALES_CAL_AUTO
    #define BODY_SCALES_CAL_AUTO true    //!< 是否允许自动标定
#endif
#ifndef BODY_SCALES_CAL_WEIGHT_FIX
    #define BODY_SCALES_CAL_WEIGHT_FIX true    //!< 校准重量固定 FALSE:允许软件随时调整 true:固定不能调整
#endif
#if !defined(BODY_SCALES_CAL1) || !defined(BODY_SCALES_CAL2) || !defined(BODY_SCALES_CAL3)
    #define BODY_SCALES_CAL1 (50000 / BODY_SCALES_RESOLUTION)    //!< 重量校準點1
    #define BODY_SCALES_CAL2 (50000 / BODY_SCALES_RESOLUTION)    //!< 重量校準點2
    #define BODY_SCALES_CAL3 (50000 / BODY_SCALES_RESOLUTION)    //!< 重量校準點3
#endif
#ifndef BODY_SCALES_CAL_CHECK
    #define BODY_SCALES_CAL_CHECK 750    //!< 三段砝碼容差ADC。 比如1kg 对应的ADC值
#endif
#ifndef BODY_SCALES_CAL_ADC_PER
    #define BODY_SCALES_CAL_ADC_PER 5000    //!< 標定砝碼最小ADC值，开发阶段方便调试可设置10Kg以上内码，正式生产设置为40Kg以上
#endif
#ifndef BODY_SCALES_EEPROM_START
    #define BODY_SCALES_EEPROM_START 0x00    //!< EEPROM數據存儲開始位置
#endif
#if ADC_DATA_BITS_IS16
    #define typedefAdc              int16_t
    #define BODY_SCALES_EEPROM_STOP (BODY_SCALES_EEPROM_START + 1 + 2 * 4 + 2 * 1 + 2 * WEIGHT_CAL_CNT)
#else
    #define typedefAdc              int32_t
    #define BODY_SCALES_EEPROM_STOP (BODY_SCALES_EEPROM_START + 1 + 4 * 4 + 2 * 1 + 2 * WEIGHT_CAL_CNT)
#endif
/* Exported types ----------------------------------------------------------------------------------------*/
typedef enum {
    BODY_SCALES_STATE_NULL,
    BODY_SCALES_STATE_PREPARE     = 1,     //!< 稱重準備中
    BODY_SCALES_STATE_NOLOAD      = 2,     //!< 空載/當前重量 < BODY_SCALES_MIN
    BODY_SCALES_STATE_LOADUP      = 3,     //!< 有上稱動作/鎖定狀態下加載解鎖重量,重量由0點變成>最小稱重重量
    BODY_SCALES_STATE_LOAD_OK     = 4,     //!< 完成一次稱重測量
    BODY_SCALES_STATE_LOAD_FIX    = 5,     //!< 完成一次稱重測量后重量穩定沒有解鎖
    BODY_SCALES_STATE_LOAD_DOWN   = 6,     //!< 下秤動作
    BODY_SCALES_STATE_OVERLOAD    = 7,     //!< 超重,當前重量大於最大稱重重量
    BODY_SCALES_STATE_AUTOON_FAST = 8,     //!< 快速ADC自動上稱判斷
    BODY_SCALES_STATE_AUTOON_SLOW = 9,     //!< 慢速ADC自動上稱判斷
    BODY_SCALES_STATE_AUTOON_PASS = 10,    //!< 自動上稱成功
    BODY_SCALES_STATE_AUTOON_FAIL = 11,    //!< 自動上秤失敗
    BODY_SCALES_STATE_CAL         = 12,    //!< 当前处于标定状态
} BodyScalesStatus_e;

typedef enum {
    BODY_SCALES_CAL_STATUS_CAL0,     //!< 正在標定零點
    BODY_SCALES_CAL_STATUS_CAL1,     //!< 正在標定第1點
    BODY_SCALES_CAL_STATUS_CAL2,     //!< 正在標定第2點
    BODY_SCALES_CAL_STATUS_CAL3,     //!< 正在標定第3點
    BODY_SCALES_CAL_STATUS_CHECK,    //!< 標定判斷
    BODY_SCALES_CAL_STATUS_PASS,     //!< 標定成功
    BODY_SCALES_CAL_STATUS_FAIL,     //!< 標定失敗
} BodyScalesStatusCal_e;

/*! Scales data  struct */
typedef struct {
    uint8_t status;    //!<@see BodyScalesStatus_e

    union {
        struct {
            uint8_t isNeedTare   : 1;    //!< RW 去皮,當前重量為穩定重量時當前重量為0
            uint8_t isUpdateZero : 1;    //!< RW 更新了零点，称重结束后，下称后残余重量大于 BODY_SCALES_ZERO_UPDATE_AUTO
        } b;

        uint8_t byte;
    } flag;

    int16_t weightStable;    //!< R 穩定重量值,最小分辨率放大10倍, 若最小分辨率设置为50，500表示重量為50.0斤
    int16_t weightReally;    //!< R 当前重量值,最小分辨率放大10倍, 若最小分辨率设置为50，500表示重量為50.0斤
    typedefAdc adcReally;    //!< R 重量Adc值
    uint8_t calStatus;       //!< R 校准状态，读取 @see BodyScalesStatusCal_e
    typedefAdc adcCal0;      //!< R 零點/空载重量 -> 校准的ADC值
    typedefAdc adcCal1;      //!< R 第1個標定重量 -> 校准的ADC值
    typedefAdc adcCal2;      //!< R 第2個標定重量 -> 校准的ADC值
    typedefAdc adcCal3;      //!< R 第3個標定重量 -> 校准的ADC值
    int16_t autoOnData;      //!< R ACD值 - 自動上稱需求的ADC值
    typedefAdc adc0;         //!< R 零點/空载重量 -> 校准中的ADC值
    typedefAdc adc1;         //!< R 第1個標定重量 -> 校准中的ADC值
    typedefAdc adc2;         //!< R 第2個標定重量 -> 校准中的ADC值
    typedefAdc adc3;         //!< R 第3個標定重量 -> 校准中的ADC值
} BodyScales_t;

/* Exported Variables --------------------------------------------------------------------------------------*/
extern const uint8_t BodyScales_Ver[3];    // version

/* Exported functions --------------------------------------------------------------------------------------*/
void BodyScales_EnterWeighting(BodyScales_t *scales, bool isPowerOn);
void BodyScales_EnterCalibration(BodyScales_t *scales);
void BodyScales_EnterAutoOn(BodyScales_t *scales);
void BodyScales_Loop(volatile int32_t *adcSourceData, BodyScales_t *scales);
void WeightMemoryClr();    //!< Clears the memory for weight measurement

#endif