/**
 * *************************************************************************************************************
 * @file Bia.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Bia firmware library
 * MCU / CFG Ver. :BH67F2495/1.0
 * Version = 1.0.0
 * # 電路AFE連接示意：
 * AI3-SINO
 * AI4-FIL-OP2N
 * AI5-RF1-OP2O
 * AI6-RF2-OP2O
 * AI7-FIR-OP2O
 * AI8-FVR-ADIP
 * AI9-FVL-ADIN
 * > SINO-FIL之间： 2.7K电阻 + 104电容
 * > FIL-RF1之间 : RF1电阻
 * > FIL-RF2之间 : RF2电阻
 * > FIL、FVL接待测电阻左侧、FIR、FVR接待测电阻右侧
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _BIA_H_
#define _BIA_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "..\board\BoardCfg.h"

/* user defined --------------------------------------------------------------------------------------------*/
// !!! 若有需要修改请在 BoardCfg.h文件中重新要修改的内容,此文件为自动生成文件，所有修改都可能被覆盖
// !!! 若搭配Lib使用，则此修改无效，需要修改请联系悠健
#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 4000000    //!< 設置系統頻率，目前支援設置為 12000000
#endif
#ifndef SINE_WAVE_VPP_MV
    #define SINE_WAVE_VPP_MV 1200L    //!< sineWave 峰峰值
#endif
#ifndef VOREG_VOLTAGE
    #define VOREG_VOLTAGE 2400L    //!< 2400,2600,2200,2300
#endif
#ifndef RF1_IMPEDANCE
    #define RF1_IMPEDANCE 200    //!< RF1 參考電阻值
#endif
#ifndef RF2_IMPEDANCE
    #define RF2_IMPEDANCE 1000    //!< RF2 參考電阻值
#endif
#ifndef IMPEDANCE_RANGER_MAX
    #define IMPEDANCE_RANGER_MAX 1200    //!< 阻抗最大值，超過此值測量狀態為BIA_ERROR_RANGER(可根據應用調整，1200為按人體雙手/雙腳設置)
#endif
#ifndef IMPEDANCE_RANGER_MIN
    #define IMPEDANCE_RANGER_MIN 200    //!< 阻抗最小值，超過此值測量狀態為BIA_ERROR_RANGER(可根據應用調整，200為按人體雙手/雙腳設置)
#endif
#ifndef BIA_PHASE_FUNCTION
    #define BIA_PHASE_FUNCTION false   //!<是否需要相位功能
#endif

/* Exported types ------------------------------------------------------------------------------------------*/
//!< ROM Size考慮只開啟需要使用的頻率，不要修改頻率對應的值
#define SINE_WAVE_FREQ_1KHZ    0     //!< 1khz
#define SINE_WAVE_FREQ_5KHZ    1     //!< 5khz
#define SINE_WAVE_FREQ_10KHZ   2     //!< 10khz
#define SINE_WAVE_FREQ_20KHZ   3     //!< 20khz
#define SINE_WAVE_FREQ_25KHZ   4     //!< 25khz
#define SINE_WAVE_FREQ_50KHZ   5     //!< 50khz
#define SINE_WAVE_FREQ_100KHZ  6     //!< 100khz
#define SINE_WAVE_FREQ_200KHZ  7     //!< 200khz
#define SINE_WAVE_FREQ_250KHZ  8     //!< 250khz
#define SINE_WAVE_FREQ_500KHZ  9     //!< 500khz
#define SINE_WAVE_FREQ_1000KHZ 10    //!< 1000khz
// #define SINE_WAVE_FREQ_1_5KHZ   11    //!< 1.5Khz
#define SINE_WAVE_FREQ_2KHZ 12    //!< 2khz
// #define SINE_WAVE_FREQ_1_5KHZ   11    //!< 1.5Khz

#define BIA_ELECTRODE_FIL 0x01
#define BIA_ELECTRODE_FIR 0x02
#define BIA_ELECTRODE_FVL 0x04
#define BIA_ELECTRODE_FVR 0x08

enum BIA_STATUS_t {
    BIA_CHECK_ELECTRODE = 0x01,    //!< 电极接触检测中
    BIA_MEASURE         = 0x02,    //!< 量測中
    BIA_SUCCESS         = 0x03,    //!< 量測成功
    BIA_ERROR_RANGER    = 0x04,    //!< 量測失敗-數據異常，通常超过范围异常阻抗值造成，也可能为线材和连接异常(10~1600Ω,建议单臂阻抗<800Ω)
    BIA_ERROR_REPEAT    = 0x05,    //!< 量測失敗-重複異常,通常为测量时姿势改变等
};

typedef struct {
    uint8_t status;             //!< R  阻抗量測狀態讀取
    uint8_t electrodeStatus;    //!< R 电极连接状态 @see
    uint8_t sineWaveFreq;       //!< RW 測量頻率
    int16_t impedance;          //!< 阻抗值
#if BIA_PHASE_FUNCTION
    int16_t phase;    //!< R 阻抗相位角
#endif
} Bia_t;

/* Exported Variables --------------------------------------------------------------------------------------*/
extern uint8_t const BiaVersion[3];    // version

/* Exported functions --------------------------------------------------------------------------------------*/
void Bia_Enable(Bia_t *Bia);
void Bia_Loop(volatile int32_t *Adc24Data, Bia_t *Bia);
void Bia_Disable(void);
void Adc_Cnt_Reset(void);    //!< 在外部實現清除ADC cnt計數，防止庫內部開始ADC start 沒有跳過前面3筆

#endif