//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2019 BY HOLTEK SEMICONDUCTOR INC
//  File Name : MasterII.c
//  Description: IO simulation IIC host
//___________________________________________________________________
//___________________________________________________________________
#include "MasterIIC.h"

#define IIC_DELAY_CNT	1

/********************************************************************
Function: IIC Start
INPUT	:
OUTPUT	:
NOTE	: IIC Start: when CLK is high,SDA change from high to low
********************************************************************/
static void fun_IIC_Start()
{
	GCC_DELAY(IIC_DELAY_CNT);
	IIC_SCL_IO = 0;
	IIC_SDA_IO = 0;
	IIC_SDA = 1;
	IIC_SCL = 1;
	GCC_DELAY(IIC_DELAY_CNT);
	IIC_SDA = 0;
	GCC_DELAY(IIC_DELAY_CNT);
	IIC_SCL = 0;
}
/********************************************************************
Function: IIC Stop
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
static void fun_IIC_Stop()
{
	IIC_SDA = 0;
	IIC_SDA_IO = 0;
	GCC_DELAY(IIC_DELAY_CNT);
	IIC_SCL = 1;
	GCC_DELAY(IIC_DELAY_CNT);
	IIC_SDA = 1;
	GCC_DELAY(IIC_DELAY_CNT);
}
/********************************************************************
Function: IIC oeACK~򱵦
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_IIC_Ack()
{
	IIC_SDA_IO=0;//set SDA as output
	IIC_SDA=0;GCC_DELAY(IIC_DELAY_CNT);//SDA=0
	IIC_SCL=1;GCC_DELAY(IIC_DELAY_CNT);//SCL=1
	IIC_SCL=0;GCC_DELAY(IIC_DELAY_CNT);//SCL=0
	IIC_SDA=1;GCC_DELAY(IIC_DELAY_CNT);//SDA=1
	GCC_DELAY(80);
}

//**********************************
//NoAck(1) signal
//**********************************
void fun_IIC_NoAck(void)
{
	IIC_SDA_IO=0;//set SDA as output
	IIC_SDA=1;GCC_DELAY(IIC_DELAY_CNT);//SDA=1
	IIC_SCL=1;GCC_DELAY(IIC_DELAY_CNT);//SCL=1
	IIC_SCL=0;GCC_DELAY(IIC_DELAY_CNT);//SCL=0
	GCC_DELAY(80);
}
/********************************************************************
Function: IIC Wait ACK
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void  fun_IIC_WaitACK()
{
	volatile unsigned char i=0;
	IIC_SDA_IO = 1;
	GCC_DELAY(IIC_DELAY_CNT);
	IIC_SCL = 1;		
	while((IIC_SDA == 1)&&(i<250))
	{
	 	i++;
	}
	IIC_SCL = 0;
	GCC_DELAY(80);
}
/********************************************************************
Function: IIC Write Byte
INPUT	: WData
OUTPUT	:
NOTE	:
********************************************************************/
static void fun_IIC_WByte(unsigned char WData)
{
 	unsigned char i;
	IIC_SDA_IO = 0; 
 	for(i=0;i<8;i++)
 	{
 		IIC_SCL = 0;
 		GCC_DELAY(IIC_DELAY_CNT);
 		if(WData&0x80)
 		{
 	 		IIC_SDA = 1;
 		}
 		else
 		{
 			IIC_SDA = 0;
 		}
 		GCC_DELAY(IIC_DELAY_CNT);
 		IIC_SCL = 1;
 		GCC_DELAY(IIC_DELAY_CNT);
 		WData<<=1;
 	}
 	IIC_SCL = 0;
	IIC_SDA_IO = 1;

}
/********************************************************************
Function: IIC Read Byte
INPUT	:
OUTPUT	: RData
NOTE	:
********************************************************************/
static unsigned char fun_IIC_RByte(unsigned char Ack)
{
	unsigned char i,RData=0;
	IIC_SDA_IO = 1;
 	IIC_SCL = 0;
 	GCC_DELAY(IIC_DELAY_CNT);
 	IIC_SCL = 1;
	for(i=0;i<8;i++)
	{
		IIC_SCL=1;
		GCC_DELAY(IIC_DELAY_CNT);
		RData=(RData<<1)|IIC_SDA;
		IIC_SCL=0;
		GCC_DELAY(IIC_DELAY_CNT);
	}
	if (Ack){
		fun_IIC_Ack();
	}
	else{
		fun_IIC_NoAck();
	}
	return RData;
}

/********************************************************************
Function: IIC Send command to Modular
INPUT	:
OUTPUT	: 
NOTE	:
********************************************************************/
void	fun_IRSensor_SendCOM(u8 lu8v_com,u16 lu16v_data)
{
		fun_IIC_Start();
		fun_IIC_WByte(IIC_SLAVE_ADDRESS);
		fun_IIC_WaitACK();
		fun_IIC_WByte(lu8v_com);
		fun_IIC_WaitACK();
		fun_IIC_WByte(lu16v_data & 0x00ff);
		fun_IIC_WaitACK();
		fun_IIC_WByte(lu16v_data >> 8);
		fun_IIC_WaitACK();		
		fun_IIC_WByte((lu16v_data >> 8) + (lu16v_data & 0x00ff) + lu8v_com);
		fun_IIC_WaitACK();
		fun_IIC_Stop();
		GCC_DELAY(IIC_DELAY_CNT);
}


/********************************************************************
Function: IIC Read ReadTemp from Modular
INPUT	:
OUTPUT	: 
NOTE	:
********************************************************************/
u16	fun_IRSensor_ReadTemp(u8 lu8v_com)
{
	volatile u16 		lu16v_tempbyte1;
	volatile u16 		lu16v_tempbyte2;
	volatile u8 		lu8v_i;
	volatile u8 		lu8v_checksum;	
	fun_IIC_Start();
	fun_IIC_WByte(IIC_SLAVE_ADDRESS);		
	fun_IIC_WaitACK();
	fun_IIC_WByte(lu8v_com);		
	fun_IIC_WaitACK();	
	GCC_DELAY(800);
	fun_IIC_Start();
	fun_IIC_WByte(IIC_SLAVE_ADDRESS + 1);		
	fun_IIC_WaitACK();
	lu16v_tempbyte1 		= fun_IIC_RByte(1);GCC_DELAY(50);
	lu16v_tempbyte2 		= fun_IIC_RByte(1);GCC_DELAY(50);
	lu8v_checksum			= fun_IIC_RByte(0);GCC_DELAY(50);
	fun_IIC_Stop();
	lu8v_i = lu16v_tempbyte1 + lu16v_tempbyte2;
	if(lu8v_checksum == lu8v_i)
	{
		return	(lu16v_tempbyte1 + ((lu16v_tempbyte2)<<8));
	}
	return	0;
}

