/************************************************************
* Temperature and Humidity Digital Sensor BM25S2021-1 example code
* Arduino IDE version: 1.8.12
* Arduino Board: UNO R3
* Wire Connection:
*   module pin 1 (VDD) connects to UNO pin 5V
*   module pin 2 (SDA) connects to UNO pin A4
*   module pin 3 (GND) connects to UNO pin GND
*   module pin 5 (SCL) connects to UNO pin A5
* Created on 2020/7/22 by Best Modules Corp.
*************************************************************/
#include <Wire.h>

void setup() {
  Wire.begin();
  Serial.begin(9600);
}
char counter;
int I2C_Receive_Buffer[10],cal_result;

bool CRC16_CHECK(void);
void loop() {
  
  //=======================Write cmd to slave===========================
  Wire.beginTransmission(0x5c);   // Send start cmd and Slave Address (0x5C)
  Wire.write(0x03);               // Function Code 0x03, fixed value
  Wire.write(0x00);               // Start address of sensor data to read
  Wire.write(0x04);               // number of bytes to read
  Wire.endTransmission();         //Send stop cmd
  delay(10);
  
  //=======================Read 8-byte Data form slave===========================
  //the 8 bytes data: Function code; data length;  4-byte sensor data; 2-byte CRC 
  Wire.requestFrom(0x5c,8);       
  counter = 0;
  while(Wire.available())         
  {
    I2C_Receive_Buffer[counter++] = Wire.read();
  }
  
  if(CRC16_CHECK())
  {
  
    //=======================Display===========================
    cal_result = I2C_Receive_Buffer[2]*256 + I2C_Receive_Buffer[3];
    Serial.print("Humidity : ");
    Serial.print((float)cal_result/10,1);
    Serial.println(" %RH");
    Serial.print("Temperature : ");
    cal_result = I2C_Receive_Buffer[4]*256 + I2C_Receive_Buffer[5];
    Serial.print((float)cal_result/10,1);
    Serial.print(" °C");
    Serial.println("\r\n");
  }
  else
  {
    Serial.print(" CRC Check Error ");
    Serial.println("\r\n");
  }
  
  delay(2000);                    //read once every 2 seconds
}
bool CRC16_CHECK(void)
{
  unsigned short CRC16;
  unsigned char CRC_check1,CRC_check2;
  //=======================Check CRC16=======================
  CRC16 = 0xFFFF;
  for(int i=0;i<6;i++)
  {
    CRC16 ^= I2C_Receive_Buffer[i];
    for(int j=0;j<8;j++)
    {
      if(CRC16 & 0x01)
      {
        CRC16 >>= 1;
        CRC16 ^= 0xA001;
      }
      else
      {
        CRC16 >>= 1;
      }
    } 
  }
  CRC_check1 = CRC16 & 0x00FF;
  CRC_check2 = (CRC16 & 0xFF00) >> 8;
  if((CRC_check1 == I2C_Receive_Buffer[6]) && (CRC_check2 == I2C_Receive_Buffer[7]))
  {
    return 1;
  }
  return 0;
}
