/*****************************************************************
File:         setWarnValue
Description:  Reset the modular,Please ensure that the baud rate
              of the Serial Monitor is 115200.
******************************************************************/

#include <BM25S4421_1.h>
#include <SoftwareSerial.h>
//BM25S4421_1 myPH(7,6);//SoftwareSerial RX TX pin of arduino UNO and BMduino
BM25S4421_1 myPH(&Serial1);//HardwareSerial of BMduino BMCOM1
uint8_t ID;
float highwarnValue,lowwarnValue;
void setup() 
{
    ID = 3;
    highwarnValue = 12.00;
	  lowwarnValue = 2.00;
    myPH.UARTbegin();
    Serial.begin(115200);
    delay(1000);      
}

void loop() 
{               
    myPH.setWarn(ID,highwarnValue,lowwarnValue);
	  Serial.print("High alarm pH value:");
	  Serial.print(highwarnValue,2);
	  Serial.print(" and low alarm pH value:");
	  Serial.print(lowwarnValue,2);
	  Serial.println(" has set"); 
    highwarnValue = 0;
    lowwarnValue = 0;
    highwarnValue = myPH.readHighWarn(ID);
    lowwarnValue = myPH.readLowWarn(ID);
    Serial.print("Get high alarm pH value:");
    Serial.print(highwarnValue,2);
    Serial.print(" and low alarm pH value:");
    Serial.println(lowwarnValue,2);
    while(1);                                                                   
}
