 /*****************************************************************
File:             BM25S4421_1->cpp
Author:           BESTMODULE
Description:      Define classes and required variables if this class 
				  has parameters,input parameters when this class defined 
				  the class(this function) can call its mumbers in current
				  function,or by called outside else
History：         
V1.0.1-- initial version；2023-10-18；Arduino IDE : ≥v1.8.13
******************************************************************/
#include  "BM25S4421_1.h"
#include <SoftwareSerial.h>
unsigned char checkSum,flagcommode=0,uint8_tSWRxbuff[15]={0};
/**********************************************************
Description: Constructor
Parameters: *theSerial: Wire object if your board has more than one UART interface      
                         parameter range:
                                         BMduino UNO: &Serial、&Serial1、&Serial2、&Serial3、&Serial4
                                         Arduino UNO：&Serial
Return:      None    
Others:      None
**********************************************************/
BM25S4421_1::BM25S4421_1(HardwareSerial*theSerial)
{
  _Serial = theSerial;
  softSerial = NULL;
  checksum=0;
}
/**********************************************************
Description: Constructor
Parameters: *wire:IIC communication interface selection
			addr:Slave address
Return:      None    
Others:      None
**********************************************************/
BM25S4421_1::BM25S4421_1(TwoWire *wire,uint8_t addr)
{
	_iicAddr = addr;
	_wire = wire;
}
/**********************************************************
Description: Constructor
Parameters:  rxPin: Receiver pin of the UART
             txPin: Send signal pin of UART         
Return:      None    
Others:   	 None
**********************************************************/
BM25S4421_1::BM25S4421_1(uint8_t rxPin,uint8_t txPin)
{
  _Serial = NULL;
  _rxPin = rxPin;
  _txPin = txPin;
  softSerial = new SoftwareSerial(_rxPin,_txPin);
  checksum=0;
}
/**********************************************************
Description: Set the baudrate of the serial communicates 
			 with module

Parameters:  baudRate:(default 9600bps)  
Output:      None
Return:      None    
Others:      None
**********************************************************/
void BM25S4421_1::UARTbegin(uint32_t baudRate)
{
	checksum=0;	
	flagcommode = 1;
	if(softSerial != NULL)
	{	
		softSerial->begin(baudRate);
		softSerial->setTimeout(50);				//set softwareUart boudrate	
	}
	else
	{
		_Serial->begin(baudRate);		
		_Serial->setTimeout(50);					//set hardwareUart timeout		
	}		
}

/**********************************************************
Description: Set the clock and timeout and for IIC conmmunication 
			 with module
Parameters:  clock:Clock frequency of IIC communication
			 timeout:The timeout time for IIC communication
Output:      None
Return:      None    
Others:      None
**********************************************************/
void BM25S4421_1::IICbegin(uint32_t clock, uint32_t timeout)
{
	checksum=0;	
	flagcommode = 2;
  _wire->begin();
  _wire->setClock(clock);
  _wire->setWireTimeout(timeout, false);
}

/**********************************************************
Description:Get pH value
Parameters: ID:Modular identification code  
Return:     PHValue:PH value of water       
Others:     None 
**********************************************************/
float  BM25S4421_1::readPH(uint8_t ID)
{
  float PHValue = 0;/*PH value*/
  float NTCValue = 0;/*NTC value*/
  readData(ID,&PHValue,&NTCValue);  
  return PHValue; 
}
/**********************************************************
Description:Get temperature
Parameters: ID:Modular identification code              
Return:     NTCValue:Water temperature      
Others:     None 
**********************************************************/
float  BM25S4421_1::readTemp(uint8_t ID)
{
  float PHValue = 0;/*PH value*/
  float NTCValue = 0;/*NTC value*/
  readData(ID,&PHValue,&NTCValue);  
  return NTCValue; 
}
/**********************************************************
Description:Get PH value and Temperature
Parameters: ID:Modular identification code 			      
			getPHValue:Variable for storing current PH value
			getNTCValue:Variable for storing current NTC value 			
Return:     0xaa:CHECK_OK 
			0x01:NO_MODULE 
			0x02:NO_TDS_MODULE 
			0x03:TIMEOUT 
			0x04:CHECKSUM_EEROR  
			0x05:COMMAND_EEROR	
			0x06:CHANNEL_EEROR
			0x07:ID_ERROR
Others:     None 
**********************************************************/

uint8_t  BM25S4421_1::readData(uint8_t ID,float *getPHValue,float *getTempValue)
{
	uint8_t check,i;
	uint8_tSWRxbuff[0] = 0;
	checkSum = HEAD1 + HEAD2 + CLASS + ID + CMD1_GETPHNTC + CMD1_TX_LENGTH;
	checkSum =~checkSum;
	checkSum = checkSum + uint8_t(1);
	if(flagcommode == 1)
	{
		if(softSerial != NULL)
		{
			softSerial->write(HEAD1); 
			softSerial->write(HEAD2); 
			softSerial->write(CLASS); 
			softSerial->write(ID); 
			softSerial->write(CMD1_GETPHNTC);
			softSerial->write(CMD1_TX_LENGTH);
			softSerial->write(checkSum);		
		}
		else
		{
			_Serial->write(HEAD1); 
			_Serial->write(HEAD2); 
			_Serial->write(CLASS); 
			_Serial->write(ID); 
			_Serial->write(CMD1_GETPHNTC);
			_Serial->write(CMD1_TX_LENGTH);
			_Serial->write(checkSum);			
		}

		checkSum = 0;	
		check = getData(uint8_tSWRxbuff,CMD1_GETPHNTC,ID);
	}
	else if(flagcommode == 2)
	{
		if(_wire != NULL)
		{
		while(_wire->available()>0)
		{
		  _wire->read();
		}
		_wire->beginTransmission(_iicAddr);
		_wire->write(HEAD1);
		_wire->write(HEAD2);
		_wire->write(CLASS);
		_wire->write(ID);
		_wire->write(CMD1_GETPHNTC);
		_wire->write(CMD1_TX_LENGTH);
		_wire->write(checkSum);
		_wire->endTransmission();
		}

		checkSum = 0; 

		delay(50);
		check = IICgetData(uint8_tSWRxbuff,CMD1_GETPHNTC,ID);
	}
	
	if(check == CHECK_OK)
	{
		*getPHValue = float((uint16_t(uint8_tSWRxbuff[6])<<8) + uint8_tSWRxbuff[7])/100; 
		*getTempValue = float((uint16_t(uint8_tSWRxbuff[8])<<8) + uint8_tSWRxbuff[9])/10;
	}
	else
	{
		*getPHValue = 0;
		*getTempValue = 0;
	}
	for(i = 0;i<15;i++)
	{
		uint8_tSWRxbuff[i] = 0;
	}	
	return check;	
}
/**********************************************************
Description:
Parameters: ID:Modular identification code
			HighWarnValue:PH alarm upper limit
			LowWarnValue:PH alarm lower limit 
Return:     0xaa:success 
			0xbb:fail   
Others:     None 
**********************************************************/
uint8_t  BM25S4421_1::setWarn(uint8_t ID,float HighWarnValue,float LowWarnValue)
{
	uint16_t uint16_tHighWarnValue,uint16_tLowWarnValue;
	uint8_t result,check,i;
	
	uint16_tHighWarnValue = uint16_t(HighWarnValue*100);
	uint16_tLowWarnValue = uint16_t(LowWarnValue*100);

	checkSum = HEAD1 + HEAD2 + CLASS + ID + CMD3_SETWARN + CMD3_TX_LENGTH + uint8_t(uint16_tHighWarnValue>>8) + uint8_t(uint16_tHighWarnValue) + uint8_t(uint16_tLowWarnValue>>8) + uint8_t(uint16_tLowWarnValue);
	checkSum =~checkSum;
	checkSum = checkSum + uint8_t(1);
	if(flagcommode == 1)
	{
		if(softSerial != NULL)
		{
			softSerial->write(HEAD1); 
			softSerial->write(HEAD2); 
			softSerial->write(CLASS); 
			softSerial->write(ID); 
			softSerial->write(CMD3_SETWARN);
			softSerial->write(CMD3_TX_LENGTH);
			softSerial->write(uint8_t(uint16_tHighWarnValue>>8));
			softSerial->write(uint8_t(uint16_tHighWarnValue));
			softSerial->write(uint8_t(uint16_tLowWarnValue>>8));
			softSerial->write(uint8_t(uint16_tLowWarnValue));
			softSerial->write(checkSum);    
		}
		else
		{
			_Serial->write(HEAD1); 
			_Serial->write(HEAD2); 
			_Serial->write(CLASS); 
			_Serial->write(ID); 
			_Serial->write(CMD3_SETWARN);
			_Serial->write(CMD3_TX_LENGTH);
			_Serial->write(uint8_t(uint16_tHighWarnValue>>8));
			_Serial->write(uint8_t(uint16_tHighWarnValue));
			_Serial->write(uint8_t(uint16_tLowWarnValue>>8));
			_Serial->write(uint8_t(uint16_tLowWarnValue));
			_Serial->write(checkSum);
		} 
		check = getData(uint8_tSWRxbuff,CMD3_SETWARN,ID);
	}
	else if(flagcommode == 2)
	{
		if(_wire != NULL)
		{
			while(_wire->available()>0)
			{
				_wire->read();
			}
			_wire->beginTransmission(_iicAddr);
			_wire->write(HEAD1);
			_wire->write(HEAD2);
			_wire->write(CLASS);
			_wire->write(ID);
			_wire->write(CMD3_SETWARN);
			_wire->write(CMD3_TX_LENGTH);
			_wire->write(uint8_t(uint16_tHighWarnValue>>8));
			_wire->write(uint8_t(uint16_tHighWarnValue));
			_wire->write(uint8_t(uint16_tLowWarnValue>>8));
			_wire->write(uint8_t(uint16_tLowWarnValue));
			_wire->write(checkSum);
			_wire->endTransmission();
		}

		checkSum = 0; 
		delay(50);  
		check = IICgetData(uint8_tSWRxbuff,CMD3_SETWARN,ID);
	}

	result = CHECK_FAIL;
	if(check == CHECK_OK&&uint8_tSWRxbuff[6] == 1)
	{
		result = CHECK_OK;
	}
	for(i = 0;i<15;i++)
	{
		uint8_tSWRxbuff[i] = 0;
	} 
	return result;   
}

/**********************************************************
Description:Get 
Parameters: ID:Modular identification code              
Return:     ReadHighWarn:     
Others:     None 
**********************************************************/
float   BM25S4421_1::readHighWarn(uint8_t ID)
{
  float ReadHighWarn = 0;
  float ReadLowWarn = 0;
  readWarnData(ID,&ReadHighWarn,&ReadLowWarn);
  return ReadHighWarn;
}

/**********************************************************
Description:Get 
Parameters: ID:Modular identification code              
Return:     ReadLowWarn:     
Others:     None 
**********************************************************/
float   BM25S4421_1::readLowWarn(uint8_t ID)
{
  float ReadHighWarn = 0;
  float ReadLowWarn = 0;
  readWarnData(ID,&ReadHighWarn,&ReadLowWarn);
  return ReadLowWarn;
}

/**********************************************************
Description:
Parameters: ID:Modular identification code
            getHighWarnValue:
            getLowWarnValue:	    
Return:     0xaa:success 
			0xbb:fail
Others:     None 
**********************************************************/
uint8_t  BM25S4421_1::readWarnData(uint8_t ID,float *getHighWarnValue,float *getLowWarnValue)
{
	uint8_t check,i,result;
	uint8_tSWRxbuff[0] = 0;
	checkSum = HEAD1 + HEAD2 + CLASS + ID + CMD4_READWARN + CMD4_TX_LENGTH;
	checkSum =~checkSum;
	checkSum = checkSum + uint8_t(1);
	if(flagcommode == 1)
	{
		if(softSerial != NULL)
		{
			softSerial->write(HEAD1); 
			softSerial->write(HEAD2); 
			softSerial->write(CLASS); 
			softSerial->write(ID); 
			softSerial->write(CMD4_READWARN);
			softSerial->write(CMD4_TX_LENGTH);
			softSerial->write(checkSum);    
		}
		else
		{
			_Serial->write(HEAD1); 
			_Serial->write(HEAD2); 
			_Serial->write(CLASS); 
			_Serial->write(ID); 
			_Serial->write(CMD4_READWARN);
			_Serial->write(CMD4_TX_LENGTH);
			_Serial->write(checkSum);     
		}
		checksum = 0;
		check = getData(uint8_tSWRxbuff,CMD4_READWARN,ID);
	}
	else if(flagcommode == 2)
	{
		if(_wire != NULL)
		{
			while(_wire->available()>0)
			{
				_wire->read();
			}
			_wire->beginTransmission(_iicAddr);
			_wire->write(HEAD1);
			_wire->write(HEAD2);
			_wire->write(CLASS);
			_wire->write(ID);
			_wire->write(CMD4_READWARN);
			_wire->write(CMD4_TX_LENGTH);
			_wire->write(checkSum);
			_wire->endTransmission();
		}

		checkSum = 0; 
		delay(50);  
		check = IICgetData(uint8_tSWRxbuff,CMD4_READWARN,ID);
	}


  result = CHECK_FAIL;
  
  if(check == CHECK_OK)
  {
    *getHighWarnValue = float((uint16_t(uint8_tSWRxbuff[6])<<8) + uint8_tSWRxbuff[7]);
    *getLowWarnValue = float((uint16_t(uint8_tSWRxbuff[8])<<8) + uint8_tSWRxbuff[9]);
    *getHighWarnValue = *getHighWarnValue / 100;
    *getLowWarnValue = *getLowWarnValue / 100;
	result = CHECK_OK;
  }
  else
  {
    *getHighWarnValue = 0;
    *getLowWarnValue = 0;
  }
  for(i = 0;i<15;i++)
  {
    uint8_tSWRxbuff[i] = 0;
  }
  
  return result;
}


/**********************************************************
Description:
Parameters: ID:Modular identification code   
    New_ID:New modular identification code
Return:     0xaa:success 
			0xbb:fail 
Others:     None 
**********************************************************/
uint8_t  BM25S4421_1::setID(uint8_t ID,uint8_t New_ID)
{
	uint8_t check,i,result;
	uint8_tSWRxbuff[0] = 0;
	checkSum = HEAD1 + HEAD2 + CLASS + ID + CMD0_SETID + CMD0_TX_LENGTH + New_ID;
	checkSum =~checkSum;
  checkSum = checkSum + uint8_t(1);
	if(softSerial != NULL)
	{
		softSerial->write(HEAD1); 
		softSerial->write(HEAD2); 
		softSerial->write(CLASS); 
		softSerial->write(ID); 
		softSerial->write(CMD0_SETID);
		softSerial->write(CMD0_TX_LENGTH);
		softSerial->write(New_ID);
		softSerial->write(checkSum);    
	}
	else
	{
		_Serial->write(HEAD1); 
		_Serial->write(HEAD2); 
		_Serial->write(CLASS); 
		_Serial->write(ID); 
		_Serial->write(CMD0_SETID);
		_Serial->write(CMD0_TX_LENGTH);
		_Serial->write(New_ID);
		_Serial->write(checkSum);     
	}

	checkSum = 0; 
	result = CHECK_FAIL;
	check = getData(uint8_tSWRxbuff,CMD0_SETID,New_ID);
	if((check == CHECK_OK)&&(uint8_tSWRxbuff[3] == New_ID)&&(uint8_tSWRxbuff[6] == 1))
	{
		result = CHECK_OK;
	}
	for(i = 0;i<15;i++)
	{
		uint8_tSWRxbuff[i] = 0;
	} 
	return result; 
}
/**********************************************************
Description:
Parameters: ID:Modular identification code   
Return:     0xaa:success 
			0xbb:fail 
Others:     None 
**********************************************************/
uint8_t  BM25S4421_1::sleep(uint8_t ID)
{
	uint8_t check,i,result;
	uint8_tSWRxbuff[0] = 0;
	checkSum = HEAD1 + HEAD2 + CLASS + ID + CMD5_SLEEP + CMD5_TX_LENGTH;
	checkSum =~checkSum;
	checkSum = checkSum + uint8_t(1);
	if(flagcommode == 1)
	{
		if(softSerial != NULL)
		{
			softSerial->write(HEAD1); 
			softSerial->write(HEAD2); 
			softSerial->write(CLASS); 
			softSerial->write(ID); 
			softSerial->write(CMD5_SLEEP);
			softSerial->write(CMD5_TX_LENGTH);
			softSerial->write(checkSum);    
		}
		else
		{
			_Serial->write(HEAD1); 
			_Serial->write(HEAD2); 
			_Serial->write(CLASS); 
			_Serial->write(ID); 
			_Serial->write(CMD5_SLEEP);
			_Serial->write(CMD5_TX_LENGTH);
			_Serial->write(checkSum);     
		}
		checkSum = 0; 
		check = getData(uint8_tSWRxbuff,CMD5_SLEEP,ID);
	}
	else if(flagcommode == 2)
	{
		if(_wire != NULL)
		{
			while(_wire->available()>0)
			{
				_wire->read();
			}
			_wire->beginTransmission(_iicAddr);
			_wire->write(HEAD1);
			_wire->write(HEAD2);
			_wire->write(CLASS);
			_wire->write(ID);
			_wire->write(CMD5_SLEEP);
			_wire->write(CMD5_TX_LENGTH);
			_wire->write(checkSum);
			_wire->endTransmission();
		}

		checkSum = 0; 
		delay(50);  
		check = IICgetData(uint8_tSWRxbuff,CMD5_SLEEP,ID);
	}

	result = CHECK_FAIL;
	if(check == CHECK_OK)
	{
		result = CHECK_OK;
	}
	for(i = 0;i<15;i++)
	{
		uint8_tSWRxbuff[i] = 0;
	} 
	return result; 
}
/**********************************************************
Description:
Parameters: ID:Modular identification code   
Return:     0xaa:success 
			0xbb:fail 
Others:     None 
**********************************************************/
uint8_t  BM25S4421_1::reset(uint8_t ID)
{
	uint8_t check,i,result;
	uint8_tSWRxbuff[0] = 0;
	checkSum = HEAD1 + HEAD2 + CLASS + ID + CMD6_RESET + CMD6_TX_LENGTH;
	checkSum =~checkSum;
	checkSum = checkSum + uint8_t(1);
	if(flagcommode == 1)
	{
		if(softSerial != NULL)
		{
			softSerial->write(HEAD1); 
			softSerial->write(HEAD2); 
			softSerial->write(CLASS); 
			softSerial->write(ID); 
			softSerial->write(CMD6_RESET);
			softSerial->write(CMD6_TX_LENGTH);
			softSerial->write(checkSum);    
		}
		else
		{
			_Serial->write(HEAD1); 
			_Serial->write(HEAD2); 
			_Serial->write(CLASS); 
			_Serial->write(ID); 
			_Serial->write(CMD6_RESET);
			_Serial->write(CMD6_TX_LENGTH);
			_Serial->write(checkSum);     
		}
		checkSum = 0; 
		check = getData(uint8_tSWRxbuff,CMD6_RESET,ID);
	}
	else if(flagcommode == 2)
	{
		if(_wire != NULL)
		{
			while(_wire->available()>0)
		{
			_wire->read();
		}
		_wire->beginTransmission(_iicAddr);
		_wire->write(HEAD1);
		_wire->write(HEAD2);
		_wire->write(CLASS);
		_wire->write(ID);
		_wire->write(CMD6_RESET);
		_wire->write(CMD6_TX_LENGTH);
		_wire->write(checkSum);
		_wire->endTransmission();
		}

		checkSum = 0; 
		delay(50);  
		check = IICgetData(uint8_tSWRxbuff,CMD6_RESET,ID);
	}
	
	result = CHECK_FAIL;
	if(check == CHECK_OK)
	{
		result = CHECK_OK;
	}
	for(i = 0;i<15;i++)
	{
		uint8_tSWRxbuff[i] = 0;
	} 
	return result; 
}


/**********************************************************
Description:UART read Data 
Parameters: buff:buff for storing uart receive data    			 
Return:     1:CHECKSUM_OK 
			2:NO_MODULE 
			3:NO_PH_MODULE 
			4:TIMEOUT 
			5:CHECKSUM_EEROR  
			6:COMMAND_EEROR	        
Others:   	None   
**********************************************************/
uint8_t  BM25S4421_1::getData(uint8_t *buff,uint8_t cmmand,uint8_t ID)
{
	uint8_t i,length;
  if(cmmand == CMD0_SETID)
    length = CMD0_RX_LENGTH;
  else if(cmmand == CMD1_GETPHNTC)
    length = CMD1_RX_LENGTH;
  else if(cmmand == CMD2_CALIBRATIONPH)
    length = CMD2_RX_LENGTH;
  else if(cmmand == CMD3_SETWARN)
    length = CMD3_RX_LENGTH;
  else if(cmmand == CMD4_READWARN)
    length = CMD4_RX_LENGTH;
  else if(cmmand == CMD5_SLEEP)
    length = CMD5_RX_LENGTH;
  else if(cmmand == CMD6_RESET)
    length = CMD6_RX_LENGTH;
  else if(cmmand == CMD10_CALIBRATE_NTC)
    length = CMD10_RX_LENGTH;
  else if(cmmand == CMD14_READ_SLOPE)
    length = CMD14_RX_LENGTH;
  else if(cmmand == CMD15_SETNTCTYPE)
    length = CMD15_RX_LENGTH;
  else if(cmmand == CMD16_READNTCTYPE)
    length = CMD16_RX_LENGTH;
  else if(cmmand == CMD17_CLEAR_NTC_CALIBRATION)
    length = CMD17_RX_LENGTH;
  length = length + 7;
	
	if(softSerial != NULL)
	{		
		if(softSerial->readBytes(buff, 1) != 0)
		{
			
			while(buff[0] != HEAD1)	
			{		
				
				if(softSerial->readBytes(buff, 1) == 0)
				{
					return NO_MODULE;
				}
			}
			
			softSerial->readBytes(buff, length - 1);
			for(i = length - 1;i>0;i--)
			{

				buff[i] = buff[i-1];
			}
			buff[0] = HEAD1;
			
		}
	}
	else
	{
		if(_Serial->readBytes(buff, 1) != 0)
		{
			while(buff[0] != HEAD1)	
			{		
				if(_Serial->readBytes(buff, 1) == 0)
				{
					return NO_MODULE;
				}
			}
			_Serial->readBytes(buff, length - 1);
			for(i = length - 1;i>0;i--)
			{

				buff[i] = buff[i-1];
			}
			buff[0] = HEAD1;
		}		
	}		
	if(buff[0]!=HEAD1&&buff[1]!=HEAD2)
		return NO_MODULE;
	if(buff[2]!=CLASS)
		return NO_PH_MODULE; 
	if(buff[3]!=ID)
		return ID_ERROR;         
	if(buff[4]!=cmmand+0x80)
		return COMMAND_EEROR;	
	checkSum = 0; 

	for(i = 0;i<length;i++)
	{				
		checkSum = checkSum + buff[i]; 
	}
//	checkSum++;
	if(checkSum == 0)
	{	
		return CHECK_OK;
	}	
	else
	{
		return CHECKSUM_EEROR;
	}				
	return TIMEOUT;
}

/**********************************************************
Description:IIC read Data 
Parameters: buff:buff for storing uart receive data           
Return:     1:CHECKSUM_OK 
      2:NO_MODULE 
      3:NO_PH_MODULE 
      4:TIMEOUT 
      5:CHECKSUM_EEROR  
      6:COMMAND_EEROR         
Others:     None   
**********************************************************/
uint8_t  BM25S4421_1::IICgetData(uint8_t *buff,uint8_t cmmand,uint8_t ID)
{
	uint8_t i,length;

	if(cmmand == CMD1_GETPHNTC)
		length = CMD1_RX_LENGTH;
	else if(cmmand == CMD3_SETWARN)
		length = CMD3_RX_LENGTH;
	else if(cmmand == CMD4_READWARN)
		length = CMD4_RX_LENGTH;
	else if(cmmand == CMD5_SLEEP)
		length = CMD5_RX_LENGTH;
	else if(cmmand == CMD6_RESET)
		length = CMD6_RX_LENGTH;
	length = length + 7;

	_wire->requestFrom(_iicAddr,length);
	if(_wire->available()==length)
	{
		for(i=0;i<length;i++)
		{
		  buff[i] = _wire->read();
		}
	}
	else
	{
	return TIMEOUT;
	}

	if(buff[0]!=HEAD1&&buff[1]!=HEAD2)
	return NO_MODULE;
	if(buff[2]!=CLASS)
	return NO_PH_MODULE; 
	if(buff[3]!=ID)
	return ID_ERROR;         
	if(buff[4]!=cmmand+0x80)
	return COMMAND_EEROR; 
	checkSum = 0; 

	for(i = 0;i<length;i++)
	{       
		checkSum = checkSum + buff[i]; 
	}

	if(checkSum == 0)
	{ 
		return CHECK_OK;
	} 
	else
	{
		return CHECKSUM_EEROR;
	}       

}
