/*****************************************************************
File:         setWarnValue
Description:  Reset the modular,Please ensure that the baud rate
              of the Serial Monitor is 115200.
******************************************************************/

#include <BM25S4421_1.h>
#include <SoftwareSerial.h>
#define BM25S4421_1_ADDR  0X03
BM25S4421_1 myPH(&Wire1,BM25S4421_1_ADDR);

uint8_t ID;
float highwarnValue,lowwarnValue;
void setup() 
{
    ID = 3;
    highwarnValue = 12.00;
	  lowwarnValue = 2.00;
    myPH.IICbegin(100000);
    Serial.begin(115200);
    delay(1000);      
}

void loop() 
{               
    myPH.setWarn(ID,highwarnValue,lowwarnValue);
	  Serial.print("High alarm pH value:");
	  Serial.print(highwarnValue,2);
	  Serial.print(" and low alarm pH value:");
	  Serial.print(lowwarnValue,2);
	  Serial.println(" has set"); 
    highwarnValue = 0;
    lowwarnValue = 0;
    highwarnValue = myPH.readHighWarn(ID);
    lowwarnValue = myPH.readLowWarn(ID);
    Serial.print("Get high alarm pH value:");
    Serial.print(highwarnValue,2);
    Serial.print(" and low alarm pH value:");
    Serial.println(lowwarnValue,2);
    while(1);                                                                   
}
