/*****************************************************************
File:        readPH
Description: power on to obtain the current PH/NTC values directly.
             After successful reception, print the current PH/NTC 
             value every second in the serial port,Please ensure that 
             the baud rate of the Serial Monitor is 115200.
******************************************************************/
#include <BM25S4421_1.h>
#include <SoftwareSerial.h>
#define BM25S4421_1_ADDR  0X03
BM25S4421_1 myPH(&Wire1,BM25S4421_1_ADDR);

uint8_t ID;
float PHValue ;
float TempValue ;

void setup() 
{
    ID = 3;
    myPH.IICbegin(100000);
    Serial.begin(115200); 
  	delay(1000);
          
}

void loop() 
{      
    PHValue  = myPH.readPH(ID);
    if(PHValue == float(15.0))
    {
      Serial.println("pH data above measurement upper limit");
    }
    else if(PHValue == float(654.36))
    {
      Serial.println("pH data below the lower measurement limit");
    }
    else
    {
      Serial.print("pH");  
      Serial.print(" value is ");
      Serial.println(PHValue,2);
    }
            
    TempValue = myPH.readTemp(ID);
    if(TempValue == float(150.0))
	  {
		  Serial.println("NTC interface short circuit");
	  }
	  else if(TempValue == float(6503.6))
	  {
		  Serial.println("NTC interface open circuit");
	  }
  	else
  	{
  		Serial.print("temperature");
  		Serial.print(" value is ");                    
  		Serial.print(TempValue,1); 
  		Serial.println(" ℃");
  	}
         
    delay(4000);
}
