/*****************************************************************
File:             BM25S4421_1.h
Author:           BESTMODULE
Description:      Define classes and required variables
History：         
V1.0.1-- initial version；2023-10-18；Arduino IDE : ≥v1.8.13
******************************************************************/

#ifndef BM25S4421_1_h_
#define BM25S4421_1_h_
#include "Arduino.h"
#include <SoftwareSerial.h>
#include <Wire.h>



 class BM25S4421_1
 {
	public:
		BM25S4421_1(HardwareSerial*theSerial=&Serial);
		BM25S4421_1(uint8_t rxPin,uint8_t txPin);
		BM25S4421_1(TwoWire *wire, uint8_t addr);
		void      UARTbegin(uint32_t baudRate = 9600);
		void	  IICbegin(uint32_t clock, uint32_t timeout = 25000);
		float  	  readPH(uint8_t ID);
		float  	  readTemp(uint8_t ID);
		uint8_t   setWarn(uint8_t ID,float HighWarnValue,float LowWarnValue);
		float     readHighWarn(uint8_t ID);
		float	    readLowWarn(uint8_t ID);
		uint8_t	  setID(uint8_t ID,uint8_t New_ID);
		uint8_t	  sleep(uint8_t ID);
		uint8_t   reset(uint8_t ID);			      
   
	private: 
		uint8_t   readWarnData(uint8_t ID,float *getHighWarnValue,float *getLowWarnValue);
		uint8_t   readData(uint8_t ID,float *getPHValue,float *getTempValue);
		uint8_t   getData(uint8_t *buff,uint8_t cmmand,uint8_t ID);
		uint8_t   IICgetData(uint8_t *buff,uint8_t cmmand,uint8_t ID);
		uint8_t   checksum,flagcommode;
		uint8_t   _rxPin;
		uint8_t   _txPin;
		uint8_t   _iicAddr;
		HardwareSerial*_Serial;
		SoftwareSerial *softSerial ;		
		TwoWire* _wire;
 };
//Communication check code
#define  CHECK_FAIL  		uint8_t(0Xbb)/*Error communication*/
#define  CHECK_OK  			uint8_t(0Xaa)/*Correct communication*/
#define  NO_MODULE  		uint8_t(0X01)/*No module access*/
#define  NO_PH_MODULE  	uint8_t(0X02)/*No PH module access*/
#define  TIMEOUT  			uint8_t(0X03)/*Communication timeout*/
#define  CHECKSUM_EEROR  	uint8_t(0X04)/*Receive checksum error*/
#define  COMMAND_EEROR  	uint8_t(0X05)/*The receive command is incorrect*/
#define  CHANNEL_EEROR    	uint8_t(0X06)/*the input channel is incorrect*/
#define  ID_ERROR         	uint8_t(0X07)/*the return ID is incorrect*/
#define  CAL_NTC_EEROR      uint8_t(0X08)/*the return ID is incorrect*/
#define  CAL_TYPE_EEROR     uint8_t(0X09)/*the return ID is incorrect*/
#define  CAL_PH400_SUCCESS  uint8_t(0X20)
#define  CAL_PH686_SUCCESS  uint8_t(0X21)
#define  CAL_PH918_SUCCESS  uint8_t(0X22)
#define  CAL_NTC_FAIL       uint8_t(0X23)

//Read data command

#define HEAD1             	uint8_t(0x42)
#define HEAD2             	uint8_t(0x4D)
#define CLASS             	uint8_t(0x63)
#define DEFAULTID         	uint8_t(0X03)

#define CMD0_SETID			    uint8_t(0x00)
#define CMD0_TX_LENGTH    	uint8_t(0x01)  
#define CMD0_RX_LENGTH    	uint8_t(0x01)

#define CMD1_GETPHNTC       uint8_t(0x01)
#define CMD1_TX_LENGTH    	uint8_t(0x00)  
#define CMD1_RX_LENGTH    	uint8_t(0x04)

#define CMD2_CALIBRATIONPH  uint8_t(0x02)
#define CMD2_TX_LENGTH    	uint8_t(0x00)  
#define CMD2_RX_LENGTH    	uint8_t(0x02)

#define CMD3_SETWARN      	uint8_t(0x03)
#define CMD3_TX_LENGTH    	uint8_t(0x04)
#define CMD3_RX_LENGTH    	uint8_t(0x01)

#define CMD4_READWARN     	uint8_t(0x04)
#define CMD4_TX_LENGTH    	uint8_t(0x00)
#define CMD4_RX_LENGTH    	uint8_t(0x04)

#define CMD5_SLEEP        	uint8_t(0X05)
#define CMD5_TX_LENGTH    	uint8_t(0X00)
#define CMD5_RX_LENGTH    	uint8_t(0X00)

#define CMD6_RESET       	  uint8_t(0X06)
#define CMD6_TX_LENGTH   	  uint8_t(0X00)
#define CMD6_RX_LENGTH   	  uint8_t(0X00)

#define CMD10_CALIBRATE_NTC   uint8_t(0X0A)
#define CMD10_TX_LENGTH     uint8_t(0X00)
#define CMD10_RX_LENGTH     uint8_t(0X02)

#define CMD14_READ_SLOPE    uint8_t(0X0E)
#define CMD14_TX_LENGTH   	uint8_t(0X00)
#define CMD14_RX_LENGTH   	uint8_t(0X02)

#define CMD15_SETNTCTYPE    uint8_t(0X0F)
#define CMD15_TX_LENGTH     uint8_t(0X01)
#define CMD15_RX_LENGTH     uint8_t(0X01)

#define CMD16_READNTCTYPE   uint8_t(0X10)
#define CMD16_TX_LENGTH     uint8_t(0X00)
#define CMD16_RX_LENGTH     uint8_t(0X01)

#define CMD17_CLEAR_NTC_CALIBRATION   uint8_t(0X11)
#define CMD17_TX_LENGTH     uint8_t(0X00)
#define CMD17_RX_LENGTH     uint8_t(0X01)

#endif
