;******************************************************************  
;That can't be modified by user.
;******************************************************************  
INCLUDE	"NPH_RX_MCU.inc"


;==================================================================
;==================================================================
PUBLIC	_NPH_RX_ISR
PUBLIC	_dataProcess
public  _setting_time

if(Leading_code==1)	
Leading_H_CNT		EQU		1	
Leading_L_CNT		EQU		36
endif

if(Leading_code==2)	
Leading_H_CNT		EQU		1	
Leading_L_CNT		EQU		23
endif

if(Leading_code==3)	
Leading_H_CNT		EQU		1	
Leading_L_CNT		EQU		31
endif

if(Start_Format==3)
START_H_CNT			EQU		4	
START_L_CNT			EQU		2	
endif

if(Bit_Format==1)
DTA_0_H_CNT			EQU		2	
DTA_0_L_CNT			EQU		1	
DTA_1_H_CNT			EQU		1	
DTA_1_L_CNT			EQU		2	

DTA_HL_CNT			EQU		1	
DTA_WIDTH_CNT		EQU		3

else

DTA_0_H_CNT			EQU		1	
DTA_0_L_CNT			EQU		3	
DTA_1_H_CNT			EQU		3	
DTA_1_L_CNT			EQU		1	

DTA_HL_CNT			EQU		1	
DTA_WIDTH_CNT		EQU		4	

endif


;--------------------------------------------------------
ERR_CNT				EQU		((TXN)/4+1)	
START_ERR_CNT		EQU		((TXN)/4+1)

if(Leading_code!=4)
	LEADING_LB			EQU		((Leading_L_CNT-2)*TXN)
if(LEADING_LB > 230)
	LEADING_LB_CNT		EQU		(255-(TXN*2))
else
	LEADING_LB_CNT		EQU		LEADING_LB		
endif
endif

;==================================================================
NPH_RX_DS		.SECTION	'data'

mSTS1			DB		?
mACC1			DB		?


_mRFData		DB		5 dup(?)
public	_mRFData

mTemp			DB		?
mDataTmp		DB		?

mTRxBits		DB		?
mTRxCnt			DB		?
mTRxLoCnt		DB		?
mTRxHiCnt		DB		?


_fRxBusy		DBIT
PUBLIC	_fRxBusy
fTRxTgl			DBIT
fTRxLevel		DBIT

_fRxFmtFnd		DBIT
PUBLIC	_fRxFmtFnd
_fRxDtaOk		DBIT
public		_fRxDtaOk

fRxStep			DBIT
fLastBit		DBIT

_fsetting_time DBIT
public _fsetting_time

mmmm			DB		?

mData			DB		?
mCRC_CHECK		DB		?
mBrig			DB		?

;**************************************************************
;**************************************************************			
NPH_RX_CS    .SECTION  PARA	'code'  ;			

;==================================================================
; RX ISR : 
;==================================================================
_NPH_RX_ISR:
			SNZ		RX_TMF
			RETI
		  	CLR		RX_TMF
		    
	    	MOV		A,ACC
	    	MOV		mACC1,A
	    	MOV		A,STATUS
	    	MOV		mSTS1,A
	    	
;-------- Rx Begin
	Rx_Begin:
        	SNZ		RFDATA
         	JMP		Rx_Lo
		Rx_Hi:
			SZ		fTRxLevel
			JMP		$1
			SET		fTRxLevel
			SET		fTRxTgl
			JMP		RxProcedure
		$1:			
			INC		mTRxHiCnt
			JMP		RxProcedure
		
		Rx_Lo:
if(Bit_Format==2)
			SZ		fLastBit
			JMP		lastbit	
endif		
			SNZ		fTRxLevel
			JMP		$0			
			CLR		fTRxLevel
			SET		fTRxTgl
			JMP		RxProcedure

		$0:			
			INC		mTRxLoCnt
			SZ		Z
			SET		mTRxLoCnt
			JMP		RxProcedure
lastbit:
			SET		fTRxLevel
			SET		fTRxTgl	
;==================================================================
; ouput : fRxFmtFnd
;==================================================================		
RxProcedure:
			SNZ		fTRxTgl
			JMP		Rx_End
			
			CLR		fTRxTgl			
if(Bit_Format==1)
			SZ		fTRxLevel
else
			SNZ		fTRxLevel
endif			
			JMP		Rx_End
if((Leading_code==1) OR (Leading_code==2))			
			SZ		fRxStep
			JMP		rp_cnt
					
			MOV		A,mTRxLoCnt
			SUB		A,LEADING_LB_CNT
			SNZ		C
			JMP		rp_Lp0
			
		rp_cnt:
			SNZ		fRxStep
			JMP		rp_ChkStr

elseif(Leading_code==3)			
			SZ		fRxStep
			JMP		rp_cnt
					
			MOV		A,mTRxLoCnt
			SUB		A,LEADING_LB_CNT
			SNZ		C
			JMP		rp_Lp0
			
		rp_cnt:
			snz		fRxStep
			JMP		rp_ChkStr
			
elseif(Start_Format==3)
			SZ		fRxStep
			JMP		rp_cnt
		
			
			MOV		A,mTRxLoCnt
			SUB		A,(START_L_CNT*TXN)-START_ERR_CNT
			SNZ		C
			JMP		rp_Lp0
			
		rp_cnt:
			SNZ		fRxStep
			JMP		rp_ChkStr
endif
			JMP		rp_ChkDta
			
	rp_End:			
			CLR		_fRxBusy
			
	rp_Lp_rst:
			CLR		fRxStep
			clr     fLastBit
	
	rp_Lp0:
			CLR		mTRxBits
	rp_Lp0_c:
			CLR		mTRxHiCnt
			CLR		mTRxLoCnt
			
			JMP		Rx_End			
if((Leading_code==1)	OR (Leading_code==2))						
rp_ChkStr:				
			MOV		A,mTRxHiCnt
			SUB		A,(Leading_H_CNT*TXN)-ERR_CNT
			SNZ		C
			JMP		rp_Lp_rst
	
			MOV		A,mTRxHiCnt
			SUB		A,(Leading_H_CNT*TXN)+ERR_CNT
			SZ			C
			JMP		rp_Lp_rst
			
			MOV		A,mTRxLoCnt
			SUB		A,LEADING_LB_CNT
			SNZ		C
			JMP		rp_Lp_rst
						
			CLR		mTRxBits					
			SET		fRxStep
			JMP		rp_Lp0
elseif(Leading_code==3)							
rp_ChkStr:				
			MOV		A,mTRxHiCnt
			SUB		A,(Leading_H_CNT*TXN)-ERR_CNT
			SNZ		C
			JMP		rp_Lp_rst
	
			MOV		A,mTRxHiCnt
			SUB		A,(Leading_H_CNT*TXN)+ERR_CNT
			SZ			C
			JMP		rp_Lp_rst
			
			MOV		A,mTRxLoCnt
			SUB		A,LEADING_LB_CNT
			SNZ		C
			JMP		rp_Lp_rst
						
			CLR		mTRxBits					
			SET		fRxStep
			JMP		rp_Lp0
					
elseif(Start_Format==3)
rp_ChkStr:				
			MOV		A,mTRxHiCnt
			SUB		A,(START_H_CNT*TXN)-ERR_CNT
			SNZ		C
			JMP		rp_Lp_rst
	
			MOV		A,mTRxHiCnt
			SUB		A,(START_H_CNT*TXN)+ERR_CNT+1
			SZ			C
			JMP		rp_Lp_rst
			
			MOV		A,mTRxLoCnt
			SUB		A,(START_L_CNT*TXN)+START_ERR_CNT
			SZ			C
			JMP		rp_Lp_rst
						
			CLR		mTRxBits					
			SET		fRxStep
			JMP		rp_Lp0
endif						
rp_ChkDta:
			MOV		A,mTRxHiCnt
			SUB		A,(DTA_HL_CNT*TXN)-ERR_CNT
			SNZ		C
			JMP		rp_Lp_rst
				
			MOV		A,mTRxHiCnt
			ADD		A,mTRxLoCnt
			SUB		A,(DTA_WIDTH_CNT*TXN)+ERR_CNT+1
			SZ			C
			JMP		rp_Lp_rst
if(END_Format==1)	
			SZ			fLastBit
			JMP		LastBitCheck			
	if(Bit_Format==2)			
			MOV		A,mTRxHiCnt
			SUB		A,mTRxLoCnt
	else			
			MOV		A,mTRxLoCnt
			SUB		A,mTRxHiCnt
	endif
			JMP		Data_Shift
	LastBitCheck:
			MOV		A,mTRxHiCnt
			SUB		A,(TXN*2)
	Data_Shift:	
else								
	if(Bit_Format==2)			
			MOV		A,mTRxHiCnt
			SUB		A,mTRxLoCnt
	else			
			MOV		A,mTRxLoCnt
			SUB		A,mTRxHiCnt
	endif
endif		
			
			RRC		_mRFData[4]
			RRC		_mRFData[3]
			RRC		_mRFData[2]
			RRC		_mRFData[1]
			RRC		_mRFData[0]
			
			INC		mTRxBits
if(Bit_Format==2)
	if(END_Format==1)		
			MOV		A,(Addr_W+Data_W+CRC_BIT-1)
			XOR		A,mTRxBits
			SZ			Z
			SET		fLastBit
	endif							
endif				
			MOV		A,mTRxBits
			SUB		A,(Addr_W+Data_W+CRC_BIT)   ;DATA BITS
			SNZ		C
			JMP		rp_Lp0_c
					
			CLR		mTRxHiCnt
			CLR		mTRxLoCnt
						
 			SET		_fRxFmtFnd	
 			CLR		fRxStep	
 			CLR		fLastBit													
	Rx_End:
			MOV		A,mSTS1
         MOV		STATUS,A            
         MOV		A,mACC1
        	RETI

;**************************************************************
;output: _mRFData[2:0] = mAddr, _mRFData[3] = mRFData
;**************************************************************			
DATA_PROCESS	.SECTION	PARA	'code'  
_dataProcess	proc
			CLR		_fRxDtaOk
						
			CLR		mCRC_CHECK
			MOV		A,CRC_BIT+1
			MOV		mTemp,A
	cd_lp:			
			SDZ		mTemp
			JMP		$+2
			JMP		cd_cnt
			CLR		C
			RLC		_mRFData[0]
			RLC		_mRFData[1]
			RLC		_mRFData[2]
			RLC		_mRFData[3]
			RLC		_mRFData[4]
			RLC		mCRC_CHECK
			JMP		cd_lp
			
	cd_cnt:			
	if(CRC_BIT!=0)
			MOV		A,40-(((Addr_W+Data_W+7) >> 3) << 3)
	else
			MOV		A,40-(Addr_W+Data_W)
	endif
			MOV		mTemp,A
	ad_lp:
			CLR		C
			RRC		_mRFData[4]
			RRC		_mRFData[3]
			RRC		_mRFData[2]
			RRC		_mRFData[1]
			RRC		_mRFData[0]
			SDZ		mTemp
			JMP		ad_lp
			
	if(CRC_BIT!=0)
			CLR		mData
			
			MOV		A,(Addr_W+Data_W) >> 3
			MOV		mDataTmp,A			
			MOV		A,(8-((Addr_W+Data_W) & 07h)) & 07h
			MOV		mTemp,A
			SZ		mTemp
			INC		mDataTmp
			
			MOV		A,OFFSET _mRFData[0]
			MOV		MP0,A
			CALL		CRC8_NB	
												
			MOV		A,(8-((Addr_W+Data_W) & 07h)) & 07h
			MOV		mTemp,A
			SZ		mTemp
			CALL	CRC8_RR
		
		if(CRC_BIT==4)			
			MOV		A,mData																
			AND		A,00Fh
			MOV		mData,A
		endif
	endif			
		
	if(Addr_W==8)
			MOV		A,_mRFData[1]
			MOV		_mRFData[3],A
			CLR		_mRFData[1]			
	elseif(Addr_W==16)
			MOV		A,_mRFData[2]
			MOV		_mRFData[3],A
			CLR		_mRFData[2]
	elseif(Addr_W==20)
			SWAPA		_mRFData[3]
			AND		A,0F0h
			MOV		_mRFData[3],A	
			SWAPA		_mRFData[2]
			AND		A,00Fh
			ORM		A,_mRFData[3]
			MOV		A,0Fh
			ANDM		A,_mRFData[2]
	elseif(Addr_W==22)
			MOV		A,_mRFData[2]
			RLC		ACC
			RLC		_mRFData[3]			
			RLC		ACC
			RLC		_mRFData[3]			
			MOV		A,03Fh
			ANDM		A,_mRFData[2]	
	endif	
					
		if(CRC_BIT!=0)			
			MOV		A,mCRC_CHECK
			XOR		A,mData
			SZ			Z
		endif
			SET		_fRxDtaOk			
			
			RET	
_dataProcess	endp
				
;******************************************************************
; CRC Polynomial : X^8 + X^5 + X^4 + 1
; Initial Value : 00h
; Order : LSB->MSB
;******************************************************************  
CRC8_NB:
	cn_Lp:
			MOV		A,IAR0
         XORM		A,mData
            
         CLR		ACC
            
			SZ			mData.0
			XOR		A,05EH		;initial 00h, data 01h
            
			SZ			mData.1
			XOR		A,0BCH		;initial 00h, data 02h
            
			SZ			mData.2
			XOR		A,061H		;initial 00h, data 04h
            
			SZ			mData.3
			XOR		A,0C2H		;initial 00h, data 08h
                       
			SZ			mData.4
			XOR		A,09DH		;initial 00h, data 10h
            
			SZ			mData.5
			XOR		A,023H		;initial 00h, data 20h
            
			SZ			mData.6
			XOR		A,046H		;initial 00h, data 40h

			SZ			mData.7
			XOR		A,08CH		;initial 00h, data 80h
            
			MOV		mData,A
            
			INC		MP0
			
			SDZ		mDataTmp
			JMP		cn_Lp           
                        
			RET            

;******************************************************************  
;CRC8_RL:
;	cl_Lp:
;			CLR		C
;			RLC		_mRFData[0]
;			RLC		_mRFData[1]
;			RLC		_mRFData[2]
;			RLC		_mRFData[3]
;			SDZ		mTemp
;			JMP		cl_Lp
;			RET
			
;******************************************************************  
CRC8_RR:
	cr_Lp:
			CLR		C
			RRC		_mRFData[3]
			RRC		_mRFData[2]
			RRC		_mRFData[1]
			RRC		_mRFData[0]
			SDZ		mTemp
			JMP		cr_Lp
			RET			


_setting_time:
           clr     CTMAF
           clr     MF1F
           	MOV		A,ACC
	    	MOV		mACC1,A
	    	MOV		A,STATUS
	    	MOV		mSTS1,A
           
           sz      _fsetting_time
           jmp     setting_on
           clr     PAC3
           set     PA3
           mov     A,0baH
           mov     CTMAL,A
           mov     A,0dbH
           mov     CTMAH,A
           
           clr     PBC6
           set     PB6
           set     _fsetting_time
           
           mov     A,mSTS1
           mov     STATUS,A
           mov     A,mACC1
           reti
           
setting_on:
           mov     A,06aH
           mov     CTMAL,A
           mov     A,018H
           mov     CTMAH,A
           clr     PBC6
           clr     PB6
           set     PAC3   
           clr     _fsetting_time
           mov     A,mSTS1
           mov     STATUS,A
           mov     A,mACC1
           reti
           
            