/*****************************************************************
File:             BM22S3221-1.h
Author:           BEST MODULES Corp.
Description:      Define classes and required variables
History：         
V1.0.2-- 2nd version；2022-11-21；Arduino IDE : v1.8.13

******************************************************************/

#ifndef  _BM22S3221_h_
#define  _BM22S3221_h_
#include <Arduino.h>
#include <SoftwareSerial.h>
#define  UART_BAUD 9600
#define TRUE (1)
#define FALSE (0)
#define  debug 0

class BM22S3221_1
{
    public:
    BM22S3221_1(uint8_t statusPin,HardwareSerial*theSerial);
    BM22S3221_1(uint8_t statusPin,uint8_t rxPin, uint8_t txPin);
    void begin();
    
    uint8_t resetModule();                  //command U00
    uint8_t getVerDate(uint8_t buff[]);     //command U01
	  //uint8_t calibrateModule();				    //command U02 is not implemented.
    uint8_t getInfoPackage(uint8_t buff[]); //command U03    
    uint8_t restoreDefault();               //command U04

    uint8_t isAutoTx();                     //command R01
    uint8_t getStatusPinActiveMode();       //command R02
    uint8_t getStatus();                    //command R03
    uint8_t getADValueH();                  //command R04	
    uint8_t getADValueL();                  //command R05      
    uint8_t getRefValueH();                 //command R06	
    uint8_t getRefValueL();                 //command R07		
    uint8_t getCOValueH();                 //command R08	
    uint8_t getCOValueL();                 //command R09	
    uint8_t getAlarmThresholdH();          	//command R10	
    uint8_t getAlarmThresholdL();           //command R11
    uint8_t getExitAlarm();          		    //command R12	

    uint8_t setAutoTx(uint8_t state);               //command W01
    uint8_t setStatusPinActiveMode(uint8_t state);  //command W02
    uint8_t setAlarmThresholdH(uint8_t value);      //command W03
    uint8_t setAlarmThresholdL(uint8_t value);   	  //command W04
    uint8_t setExitAlarmThreshold(uint8_t value);   //command W05
    
    uint8_t autoRx(uint8_t buff[]);
        
    private:
    void readData(uint8_t buff[]);
    void writeData(uint8_t buff[], uint8_t datalength);
    void clear_UART_FIFO();
    uint8_t _rxPin;
    uint8_t _txPin;
    uint8_t _statusPin;
    HardwareSerial*_serial =NULL;
    SoftwareSerial *_softSerial =NULL;
};

#endif
