/*************************************************
This sketch reads the CO sensor module BM22S3221-1 information and
monitor the CO concentration of the air.

Wire COnnection between BM22S3221-1 and Arduino Uno:
BM22S3221-1 pin 1 (VDD) connect to Arduino Uno pin 5V
BM22S3221-1 pin 2 (VSS) connect to Arduino Uno pin GND
BM22S3221-1 pin 3 (RX) connect to Arduino Uno pin 3
BM22S3221-1 pin 4 (TX) connect to Arduino Uno pin 2
BM22S3221-1 pin 5 (STATUS) connect to Arduino Uno pin 8

If you use a 16x2 character LCD with I2C interface,
connect SCL to Arduino Uno pin SCL
connect SDA to Arduino Uno pin SDA
connect VCC to Arduino Uno pin 5V
connect GDN to Arduino Uno pin GND

And download the LiquidCrystal_I2C library:
In Arduino IDE >> Tools >> Manage Libraries...,
search LiquidCrystal I2C, and install
**************************************************/
#include "BM22S3221-1.h"
//#include <LiquidCrystal_I2C.h>
//LiquidCrystal_I2C lcd(0x27, 16, 2);

#define rxPin 2     // Software UART RX pin
#define txPin 3     // Software UART TX pin
#define statusPin 8 // STATUS Pin：D8
#define LED 13      // LED Pin：D13

uint16_t COValue,ADValue;
uint8_t rtn=0, moduleInfo[32] = {0}; // buffer to store module information

BM22S3221_1 CO(statusPin, rxPin, txPin); //Softeware serial

void setup()
{
  CO.begin(); // Initialize Softeware serial, baud rate 9600, Set pin8 as input 
  Serial.begin(9600);
  CO.setAutoTx(8); // enable the module's auto transmit function
  delay(500); // wait module stable
  // initialize the 16x2 LCD module
  //lcd.init();
  //lcd.backlight();
}

void loop()
{
  /*read module's status by U03 command or by autoTx funciton, 
    detect status, show status on serial monitor or 16x2 character LCD */
  // U03: get getStatus()
  //rtn = CO.getInfoPackage(moduleInfo);
  //Serial.println(rtn);
  //for(uint8_t i=0; i<32; i++){Serial.println(moduleInfo[i], HEX);}

  rtn = CO.autoRx(moduleInfo); 
  if (rtn == 0){
    for (uint8_t i=0; i<32; i++){
      Serial.print(i);
      Serial.print(": 0x");
      Serial.println(moduleInfo[i], HEX);
    }  
    if ((moduleInfo[12]&0x01) == 0){
      Serial.println("preheating");
      //lcd.clear(); lcd.setCursor(1,0); lcd.print("Preheating");
      //lcd.setCursor(1,1);lcd.print(moduleInfo[14]);lcd.setCursor(5,1);lcd.print("seconds"); 
    }
    else if((moduleInfo[13]&0x80) != 0){
      COValue = (uint16_t)(moduleInfo[9]<<8) + (uint16_t)(moduleInfo[10]);
      Serial.print("alarm, CO concentration = ");
      Serial.print(COValue);Serial.println(" ppm");
      //lcd.clear(); lcd.setCursor(1,0); lcd.print("alarm");    
      //lcd.setCursor(1,1);lcd.print(COValue);lcd.setCursor(5,1);lcd.print("ppm");
    }
    else if((moduleInfo[13]&0x40) != 0){
      Serial.println("fault");
      //lcd.clear(); lcd.setCursor(1,0); lcd.print("module fault");      
    }  
    else{
      COValue = (uint16_t)(moduleInfo[9]<<8) + (uint16_t)(moduleInfo[10]);
      Serial.print("normal, CO concentration = ");
      Serial.print(COValue); Serial.println(" ppm");
      //lcd.clear(); lcd.setCursor(0,0); lcd.print("normal");   
      //lcd.setCursor(0,1);lcd.print(COValue);lcd.setCursor(4,1);lcd.print("ppm");                 
    }      
  } 
  else {
    Serial.println(" read error");
    //lcd.clear(); lcd.setCursor(0,0); lcd.print("read error");
  }
  delay(300);
}
