/*****************************************************************
File:         BM32S4021-1_demo.ino
Description:  
connection method: 
******************************************************************/
#include "BMD31M090.h"
#include "Bitmap.h"
#include "BM32S4021-1.h"
BM32S4021_1   BMS31(22,&Serial1);                               
BMD31M090     BMD31(128, 64, &Wire2);
uint8_t irStatus = 0;
uint16_t Time = 501;
void setup()
{
  Serial.begin(9600);
  BMD31.begin();
  BMS31.begin();  
  displayInitial();
  delay(2000);
  BMD31.clearDisplay();
  BMD31.display();
}

void loop()
{
  delay(1);
  if(Time < 500)
  {
   Time++;
   if(Time == 500)
   {
    BMD31.clearDisplay();
    BMD31.display();
   }
  }
  if(BMS31.isInfoAvailable()== true)
   {
    irStatus = 0;
    irStatus = BMS31.readInfoPackage(); 
    if(irStatus&0x01) 
    {
     displaysLideLeft();
     Time = 0;
    }
    if(irStatus&0x02)
    {  
     displaysLideRight();
     Time = 0;
    }
   if(irStatus&0x04)
    {  
     Serial.print("aa:");
     displaySlideForward();
     Time = 0;
    }
    if(irStatus&0x08)
    {  
     displaySlideBack();
     Time = 0;
    }
    if(irStatus&0x10) 
    {
     displayRise();
     Time = 0; 
    }
    if(irStatus&0x20)
    {  
     displayDescend();
     Time = 0; 
    }
   }
}


void displayInitial(void)
{
  BMD31.clearDisplay();
  BMD31.display();
  BMD31.setFont(FontTable_8X16);
  BMD31.drawString(25,3,(u8*)"BMS31K402"); 
}


void displaysLideLeft(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(44, 24, slideLeft, 40, 17,1);
  BMD31.display();
}

void displaysLideRight(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(44, 24, slideRight, 40, 17,1);
  BMD31.display();
}

void displaySlideForward(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(56, 12, slideForward, 17, 40,1);
  BMD31.display();
}

void displaySlideBack(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(56, 12, slideBack, 17, 40,1);
  BMD31.display();
}

void displayRise(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(54, 22, round_Small, 20, 20,1);
  BMD31.display();
  delay(200);
  BMD31.clearDisplay();
  BMD31.drawBitmap(44, 12, round_medium, 40, 40,1);
  BMD31.display();
  delay(200);
  BMD31.clearDisplay();
  BMD31.drawBitmap(34, 2, round_large, 60, 60,1);
  BMD31.display();
  delay(200);
}

void displayDescend(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(34, 2, round_large, 60, 60,1);
  BMD31.display();
  delay(200);
  BMD31.clearDisplay();
  BMD31.drawBitmap(44, 12, round_medium, 40, 40,1);
  BMD31.display();
  delay(200);
  BMD31.clearDisplay();
  BMD31.drawBitmap(54, 22, round_Small, 20, 20,1);
  BMD31.display();
  delay(200);
}
