/*****************************************************************
File:             BM32S4021-1.h
Author:           BESTMODULES
Description:      Define classes and required variables
Version:          V1.0.1   -- 2024-01-08
******************************************************************/
#ifndef _BM32S4021_1_H_
#define _BM32S4021_1_H_

#include "Arduino.h"
#include <SoftwareSerial.h>

#define PASSIVE  0x00
#define AUTO     0x01

#define CHECK_OK       0x00
#define CHECK_ERROR    0x01
#define TIMEOUT_ERROR  0x02


class BM32S4021_1
{
  public:
    BM32S4021_1(uint8_t intPin,HardwareSerial *theSerial  = &Serial);
    BM32S4021_1(uint8_t intPin,uint8_t rxPin,uint8_t txPin);
    void begin();

    uint8_t getINT();
    uint8_t getIRStatus();
    bool isInfoAvailable();
    uint8_t readInfoPackage();
    uint8_t distanceLearning();
    uint8_t getIRGestureNum(); 
    uint16_t getFWVer(); 
    void reset(); 
   
    uint8_t getMode();
    uint8_t getIRDebounce(); 
    uint8_t getGestureThreshold();
    uint8_t getIRQTrigerTime(); 
    uint8_t getIRContinutyGestureTime();
    uint8_t getIRFastestGestureTime();
    uint8_t getIRSlowestGestureTime(); 
    uint8_t getGestureHoverTime();  
    
    uint8_t setMode(uint8_t mode = AUTO);
    uint8_t setIRDebounce(uint8_t  debounce = 2);  
    uint8_t setGestureThreshold(uint8_t  threshold = 16); 
    uint8_t setIRQTrigerTime(uint8_t  irTime = 40); 
    uint8_t setIRContinutyGestureTime(uint8_t  irTime = 30);
    uint8_t setIRFastestGestureTime(uint8_t  irTime = 0);  
    uint8_t setIRSlowestGestureTime(uint8_t  irTime = 80); 
    
  private:
    uint8_t readIR1Ref(); 
    uint8_t readIR2Ref(); 
    uint8_t readIrA2_A5(uint8_t  buff[]);
    uint8_t getIR1Current();
    uint8_t getIR2Current(); 
    uint8_t setIR1Current(uint8_t  current); 
    uint8_t setIR2Current(uint8_t  current); 
    uint8_t checksum(uint8_t len,uint8_t data[]); 
    void writeBytes(uint8_t wbuf[], uint8_t wlen);
    uint8_t readBytes(uint8_t rbuf[], uint8_t rlen, uint16_t timeOut = 5000);
    uint8_t _intPin;
    uint8_t _rxPin;
    uint8_t _txPin;
    uint8_t _recBuf[6]={0};
    HardwareSerial *_hardSerial = NULL;
    SoftwareSerial *_softSerial = NULL ;   
};

#endif
