#ifndef __BITMAP_H
#define __BITMAP_H

/*============================================================
   |Using Image2LCD Software conversion, setting as bellow    |
   |1. Output file type: C array (*.c)                        |
   |2. Scan mode: Horizon Scan                                |
   |3. Bits Pixel: monochrome                                 |
   |4. Max Width and Height: 128 (Width) / 64 (Height)        |
   |5. Select "MSB First"                                     |
    ----------------------------------------------------------
   |Using LCD Assistant Software conversion, setting as bellow|
   |1. Byte orientation: Horizontal                           |
   |2. Size: According your image size                        |
   |3. Size endianness: Little                                |
   |4. Pixels/byte: 8                                         |
  ============================================================*/

const uint8_t BestModule_LOGO [] PROGMEM =
{
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00,
0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x03, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x01, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, 0x00, 0x03, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x07, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x1F, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x7F, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, 0xFF, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x03, 0xFF, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x7F, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x03, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x3F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x0F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x0F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x07,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x07,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x03,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x03,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x07,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0x0F, 0xF0, 0x00, 0x00, 0x07,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x07,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x0F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x0F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, 0x1F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00, 0x3F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x7F,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x03, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x07, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x1F, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x3F, 0xFF,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0xFF, 0xFE,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x03, 0xFF, 0x80,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x1F, 0xF0, 0x00,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xFE, 0x00, 0x00,
0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x0F, 0x80, 0x00, 0x00,
0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xF0, 0x00, 0x00, 0x00,
0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFC, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFC, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t BestModule_LOGOandName[] PROGMEM =
{
0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x01, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0xE0, 0x0F, 0xFF, 0x03, 0xFF, 0xE0, 0xFE, 0x1F, 0xFF, 0xC0,
0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x60, 0x0F, 0xFF, 0xC3, 0xFF, 0xE1, 0xFF, 0x1F, 0xFF, 0xC0,
0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x60, 0x0F, 0xC7, 0xE3, 0xF0, 0x43, 0x83, 0x81, 0xFC, 0x40,
0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x60, 0x0F, 0xC7, 0xE3, 0xF0, 0x07, 0x01, 0x80, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0xE0, 0x0F, 0xC3, 0xE3, 0xF0, 0x07, 0x01, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0xE0, 0x0F, 0xC3, 0xE3, 0xF0, 0x07, 0x01, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0xE0, 0x0F, 0xC3, 0xE3, 0xF0, 0x07, 0x81, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0xE0, 0x0F, 0xC3, 0xE3, 0xF0, 0x07, 0xC1, 0x00, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0x3C, 0x01, 0xE0, 0x0F, 0xC3, 0xE3, 0xF0, 0x07, 0xF0, 0x00, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xFC, 0x01, 0xE0, 0x0F, 0xC7, 0xC3, 0xF0, 0x07, 0xFC, 0x00, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xFC, 0x03, 0xE0, 0x0F, 0xCF, 0x83, 0xFF, 0x87, 0xFE, 0x00, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xFC, 0x07, 0xE0, 0x0F, 0xFF, 0x03, 0xFF, 0x83, 0xFF, 0x00, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xFC, 0x07, 0xE0, 0x0F, 0xFF, 0xC3, 0xF0, 0x01, 0xFF, 0x80, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xF8, 0x0F, 0xE0, 0x0F, 0xC7, 0xE3, 0xF0, 0x01, 0xFF, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xF0, 0x07, 0xE0, 0x0F, 0xC3, 0xE3, 0xF0, 0x00, 0x7F, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x01, 0xE0, 0x0F, 0xC3, 0xF3, 0xF0, 0x00, 0x3F, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x00, 0xE0, 0x0F, 0xC3, 0xF3, 0xF0, 0x06, 0x0F, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0x80, 0xE0, 0x00, 0x60, 0x0F, 0xC3, 0xF3, 0xF0, 0x0E, 0x07, 0xE0, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xC0, 0xE0, 0x00, 0x60, 0x0F, 0xC3, 0xF3, 0xF0, 0x0E, 0x03, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0x00, 0x20, 0x0F, 0xC3, 0xF3, 0xF0, 0x06, 0x03, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0x00, 0x20, 0x0F, 0xC3, 0xF3, 0xF0, 0x06, 0x03, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xF0, 0xE0, 0x00, 0x20, 0x0F, 0xC7, 0xE3, 0xF0, 0x07, 0x03, 0xC0, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xF0, 0xE0, 0x00, 0x20, 0x0F, 0xFF, 0xE3, 0xFF, 0xF3, 0xCF, 0x80, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xF0, 0xE0, 0x00, 0x20, 0x0F, 0xFF, 0xC3, 0xFF, 0xF1, 0xFF, 0x00, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xF0, 0xE0, 0x00, 0x20, 0x07, 0xFE, 0x03, 0xFF, 0xE0, 0xFC, 0x00, 0xFC, 0x00,
0xFF, 0xFF, 0xFF, 0xF0, 0xE7, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFF, 0xFF, 0xFF, 0x00, 0xFE, 0x00, 0x60, 0x0F, 0x3C, 0x7C, 0x7F, 0x1C, 0x4E, 0x0F, 0xC7, 0xC0,
0xFF, 0xFF, 0xFC, 0x00, 0xF8, 0x00, 0xE0, 0x0F, 0x3C, 0xEE, 0x73, 0x9C, 0x4E, 0x0E, 0x0C, 0xC0,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x00, 0xE0, 0x0F, 0x3C, 0xCE, 0x73, 0x9C, 0x4E, 0x0E, 0x0C, 0x40,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x01, 0xE0, 0x0F, 0x3D, 0xCF, 0x73, 0x9C, 0x4E, 0x0E, 0x0E, 0x40,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x01, 0xE0, 0x0F, 0xFD, 0xC7, 0x73, 0x9C, 0x4E, 0x0F, 0x8F, 0x80,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x03, 0xE0, 0x0F, 0xFD, 0xC7, 0x73, 0x9C, 0x4E, 0x0F, 0xCF, 0xC0,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x07, 0xE0, 0x0F, 0xFD, 0xC7, 0x73, 0x9C, 0x4E, 0x0E, 0x07, 0xE0,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x07, 0xE0, 0x0F, 0xDD, 0xC7, 0x73, 0x9C, 0x4E, 0x0E, 0x09, 0xE0,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x0F, 0x80, 0x0D, 0xDD, 0xCE, 0x73, 0x9C, 0x4E, 0x0E, 0x08, 0xE0,
0xFF, 0xFF, 0xFC, 0x00, 0xE0, 0x1E, 0x00, 0x0D, 0xDC, 0xEE, 0x73, 0x9C, 0x4E, 0x0E, 0x08, 0xE0,
0x7F, 0xFF, 0xFC, 0x00, 0xE0, 0x30, 0x00, 0x0D, 0x9C, 0xFE, 0x77, 0x1F, 0xCE, 0x0E, 0x0D, 0xC0,
0x3F, 0xFF, 0xFC, 0x00, 0xE0, 0xC0, 0x00, 0x0D, 0x9C, 0x78, 0x7E, 0x0F, 0x8F, 0xEF, 0xE7, 0x80,
0x0F, 0xFF, 0xFC, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x03, 0xFF, 0xFC, 0x00, 0xEC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xFF, 0xFC, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x3F, 0xFC, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x0F, 0xFC, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x03, 0xFC, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xFC, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x3D, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const unsigned char round_large[480] = { /* 0X10,0X01,0X00,0X3C,0X00,0X3C, */
0X00,0X00,0X00,0X7F,0XE0,0X00,0X00,0X00,0X00,0X00,0X07,0XC0,0X3E,0X00,0X00,0X00,
0X00,0X00,0X3C,0X00,0X03,0XC0,0X00,0X00,0X00,0X00,0XE0,0X00,0X00,0X70,0X00,0X00,
0X00,0X03,0X80,0X00,0X00,0X1C,0X00,0X00,0X00,0X06,0X00,0X00,0X00,0X06,0X00,0X00,
0X00,0X18,0X00,0X00,0X00,0X01,0X80,0X00,0X00,0X30,0X00,0X00,0X00,0X00,0XC0,0X00,
0X00,0X60,0X00,0X00,0X00,0X00,0X60,0X00,0X00,0XC0,0X00,0X00,0X00,0X00,0X30,0X00,
0X01,0X80,0X00,0X00,0X00,0X00,0X18,0X00,0X03,0X00,0X00,0X00,0X00,0X00,0X0C,0X00,
0X02,0X00,0X00,0X00,0X00,0X00,0X04,0X00,0X04,0X00,0X00,0X00,0X00,0X00,0X02,0X00,
0X0C,0X00,0X00,0X00,0X00,0X00,0X03,0X00,0X08,0X00,0X00,0X00,0X00,0X00,0X01,0X00,
0X18,0X00,0X00,0X00,0X00,0X00,0X01,0X80,0X10,0X00,0X00,0X00,0X00,0X00,0X00,0X80,
0X30,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,0X20,0X00,0X00,0X00,0X00,0X00,0X00,0X40,
0X20,0X00,0X00,0X00,0X00,0X00,0X00,0X40,0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X60,
0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X20,0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X20,
0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X20,0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X30,
0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,
0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,
0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,
0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X10,
0XC0,0X00,0X00,0X00,0X00,0X00,0X00,0X30,0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X20,
0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X20,0X40,0X00,0X00,0X00,0X00,0X00,0X00,0X20,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X60,0X20,0X00,0X00,0X00,0X00,0X00,0X00,0X40,
0X20,0X00,0X00,0X00,0X00,0X00,0X00,0X40,0X30,0X00,0X00,0X00,0X00,0X00,0X00,0XC0,
0X10,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0X18,0X00,0X00,0X00,0X00,0X00,0X01,0X80,
0X08,0X00,0X00,0X00,0X00,0X00,0X01,0X00,0X0C,0X00,0X00,0X00,0X00,0X00,0X03,0X00,
0X04,0X00,0X00,0X00,0X00,0X00,0X02,0X00,0X02,0X00,0X00,0X00,0X00,0X00,0X04,0X00,
0X03,0X00,0X00,0X00,0X00,0X00,0X0C,0X00,0X01,0X80,0X00,0X00,0X00,0X00,0X18,0X00,
0X00,0XC0,0X00,0X00,0X00,0X00,0X30,0X00,0X00,0X60,0X00,0X00,0X00,0X00,0X60,0X00,
0X00,0X30,0X00,0X00,0X00,0X00,0XC0,0X00,0X00,0X18,0X00,0X00,0X00,0X01,0X80,0X00,
0X00,0X06,0X00,0X00,0X00,0X06,0X00,0X00,0X00,0X03,0X80,0X00,0X00,0X1C,0X00,0X00,
0X00,0X00,0XE0,0X00,0X00,0X70,0X00,0X00,0X00,0X00,0X3C,0X00,0X03,0XC0,0X00,0X00,
0X00,0X00,0X07,0XC0,0X3E,0X00,0X00,0X00,0X00,0X00,0X00,0X7F,0XE0,0X00,0X00,0X00,
};


const unsigned char round_medium[200] = { /* 0X10,0X01,0X00,0X28,0X00,0X28, */
0X00,0X00,0XFF,0X00,0X00,0X00,0X0F,0X00,0XF0,0X00,0X00,0X38,0X00,0X1C,0X00,0X00,
0X60,0X00,0X06,0X00,0X01,0X80,0X00,0X01,0X80,0X03,0X00,0X00,0X00,0XC0,0X06,0X00,
0X00,0X00,0X60,0X0C,0X00,0X00,0X00,0X30,0X08,0X00,0X00,0X00,0X10,0X10,0X00,0X00,
0X00,0X08,0X30,0X00,0X00,0X00,0X0C,0X20,0X00,0X00,0X00,0X04,0X60,0X00,0X00,0X00,
0X06,0X40,0X00,0X00,0X00,0X02,0X40,0X00,0X00,0X00,0X02,0X40,0X00,0X00,0X00,0X02,
0X80,0X00,0X00,0X00,0X01,0X80,0X00,0X00,0X00,0X01,0X80,0X00,0X00,0X00,0X01,0X80,
0X00,0X00,0X00,0X01,0X80,0X00,0X00,0X00,0X01,0X80,0X00,0X00,0X00,0X01,0X80,0X00,
0X00,0X00,0X01,0X80,0X00,0X00,0X00,0X01,0X40,0X00,0X00,0X00,0X03,0X40,0X00,0X00,
0X00,0X02,0X40,0X00,0X00,0X00,0X02,0X60,0X00,0X00,0X00,0X06,0X20,0X00,0X00,0X00,
0X04,0X30,0X00,0X00,0X00,0X0C,0X10,0X00,0X00,0X00,0X08,0X08,0X00,0X00,0X00,0X10,
0X0C,0X00,0X00,0X00,0X30,0X06,0X00,0X00,0X00,0X60,0X03,0X00,0X00,0X00,0XC0,0X01,
0X80,0X00,0X01,0X80,0X00,0X60,0X00,0X06,0X00,0X00,0X38,0X00,0X1C,0X00,0X00,0X0F,
0X00,0XF0,0X00,0X00,0X00,0XFF,0X80,0X00,};



const unsigned char round_Small[60] = { /* 0X10,0X01,0X00,0X14,0X00,0X14, */
0X01,0XF8,0X00,0X04,0X02,0X00,0X10,0X00,0X80,0X20,0X00,0X40,0X00,0X00,0X00,0X40,
0X00,0X20,0X00,0X00,0X00,0X80,0X00,0X10,0X80,0X00,0X10,0X80,0X00,0X10,0X80,0X00,
0X10,0X80,0X00,0X10,0X80,0X00,0X10,0X00,0X00,0X00,0X40,0X00,0X20,0X00,0X00,0X00,
0X20,0X00,0X40,0X10,0X00,0X80,0X04,0X02,0X00,0X01,0XF8,0X00,};


const unsigned char slideForward[120] = { /* 0X10,0X01,0X00,0X11,0X00,0X28, */
0X00,0X80,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X03,0XE0,0X00,0X03,0XE0,0X00,0X07,
0XF0,0X00,0X07,0XF8,0X00,0X0F,0XF8,0X00,0X1F,0XFC,0X00,0X1F,0XFC,0X00,0X3F,0XFE,
0X00,0X3D,0XDE,0X00,0X79,0XCF,0X00,0X79,0XCF,0X00,0XF1,0XC7,0X80,0X61,0XC3,0X00,
0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,
0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,
0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,
0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,
0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,};

const unsigned char slideBack[120] = { /* 0X10,0X01,0X00,0X11,0X00,0X28, */
0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,
0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,
0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,
0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X01,
0XC0,0X00,0X01,0XC0,0X00,0X01,0XC0,0X00,0X61,0XC3,0X00,0XF1,0XC7,0X80,0X79,0XCF,
0X00,0X79,0XCF,0X00,0X3D,0XDE,0X00,0X3F,0XFE,0X00,0X1F,0XFC,0X00,0X1F,0XFC,0X00,
0X0F,0XF8,0X00,0X0F,0XF0,0X00,0X07,0XF0,0X00,0X03,0XE0,0X00,0X03,0XE0,0X00,0X01,
0XC0,0X00,0X01,0XC0,0X00,0X00,0X80,0X00,};

const unsigned char slideLeft[85] = { /* 0X10,0X01,0X00,0X28,0X00,0X11, */
0X00,0X02,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,0X00,0X3F,0X00,0X00,0X00,0X00,
0XFE,0X00,0X00,0X00,0X03,0XFC,0X00,0X00,0X00,0X07,0XF0,0X00,0X00,0X00,0X1F,0XE0,
0X00,0X00,0X00,0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0X7F,0XFF,0XFF,
0XFF,0XFF,0X1F,0XE0,0X00,0X00,0X00,0X07,0XF0,0X00,0X00,0X00,0X01,0XFC,0X00,0X00,
0X00,0X00,0XFE,0X00,0X00,0X00,0X00,0X3F,0X00,0X00,0X00,0X00,0X0F,0X00,0X00,0X00,
0X00,0X02,0X00,0X00,0X00,};

const unsigned char slideRight[85] = { /* 0X10,0X01,0X00,0X28,0X00,0X11, */
0X00,0X00,0X00,0X40,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0XFC,0X00,0X00,
0X00,0X00,0X7F,0X00,0X00,0X00,0X00,0X3F,0X80,0X00,0X00,0X00,0X0F,0XE0,0X00,0X00,
0X00,0X07,0XF8,0XFF,0XFF,0XFF,0XFF,0XFE,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,
0XFF,0XFE,0X00,0X00,0X00,0X07,0XF8,0X00,0X00,0X00,0X0F,0XE0,0X00,0X00,0X00,0X3F,
0XC0,0X00,0X00,0X00,0X7F,0X00,0X00,0X00,0X00,0XFC,0X00,0X00,0X00,0X00,0XF0,0X00,
0X00,0X00,0X00,0X40,0X00,};



#endif
