
#define Head 0xFA
#define Get_WaterLevel_CMD  0X01
#define Get_Temperature_CMD 0X02
#define Get_ID_CMD          0x05


void setup() {
  Serial.begin(9600);
  Serial1.begin(38400);
  while(!Serial);
  while(!Serial1);
  Serial.println("Water level digital sensor testing");
  Serial.println("Get ID...");
  uint8_t WaterSensor_ID[8];
  Read_WaterSensor_ID(WaterSensor_ID);
  Serial.print("ID:");
  for(int i = 0; i < 8; i++)
  {
    Serial.print(WaterSensor_ID[i]);
    Serial.print(" ");
  }
  Serial.println();
}

void loop() {
  int WaterSensor_value = 0;

  Serial.println("Get WaterLevel...");
  WaterSensor_value = Read_WaterSensor_Value();
  Serial.print("WaterLevel: ");
  Serial.print(WaterSensor_value);
  Serial.println("mmH2O");

  delay(1000);
}

void Read_WaterSensor_ID(uint8_t* ID)
{
  uint8_t length = 0;
  uint16_t checksum = 0;
  uint8_t TXdata[4];
  TXdata[0] = Head;
  TXdata[1] = Get_ID_CMD;
  TXdata[2] = length;
  checksum = TXdata[1] + TXdata[2];
  for(int i = 0; i < length; i++)
  {
    checksum = checksum + TXdata[3 + i];
  }
  TXdata[length + 3] = checksum;
  Serial1.write(TXdata, length + 4);

  delay(10);
  uint8_t RXdata[12];
  if(Serial1.available())
  {
    Serial1.readBytes(RXdata,12);
    checksum = 0;
    for(int i = 0; i < 10; i++)
    {
      checksum += RXdata[1 + i];
    }
    if((checksum%256) == RXdata[11])
    {
      for(int i = 0; i < 8; i++)
      {
        ID[i] = RXdata[i + 3];
      }  
    }
  }  
}

uint16_t Read_WaterSensor_Value()
{
  uint8_t length = 0;
  uint16_t checksum = 0;
  uint8_t TXdata[4];
  TXdata[0] = Head;
  TXdata[1] = Get_WaterLevel_CMD;
  TXdata[2] = length;
  checksum = TXdata[1] + TXdata[2];
  for(int i = 0; i < length; i++)
  {
    checksum = checksum + TXdata[3 + i];
  }
  TXdata[length + 3] = checksum;
  Serial1.write(TXdata, length + 4);

  delay(10);
  uint8_t RXdata[6];
  uint16_t value = 0;
  if(Serial1.available())
  {
    Serial1.readBytes(RXdata,6);
    value = RXdata[4] * 256 + RXdata[3];
    uint8_t checksum = RXdata[1] + RXdata[2] + RXdata[3] + RXdata[4];
    if(value > 32767){value = 0; }
    if(checksum != RXdata[5])
    {
      value = 0;
    }
  } 
  return value;
}

float Read_WaterSensor_Temperature()
{
  uint8_t length = 0;
  uint16_t checksum = 0;
  uint8_t TXdata[4];
  TXdata[0] = Head;
  TXdata[1] = Get_Temperature_CMD;
  TXdata[2] = length;
  checksum = TXdata[1] + TXdata[2];
  for(int i = 0; i < length; i++)
  {
    checksum = checksum + TXdata[3 + i];
  }
  TXdata[length + 3] = checksum;
  Serial1.write(TXdata, length + 4);

  delay(10);
  uint8_t RXdata[6];
  float value = 0;
  if(Serial1.available())
  {
    Serial1.readBytes(RXdata,6);
    value = RXdata[4] * 256 + RXdata[3];
    uint8_t checksum = RXdata[1] + RXdata[2] + RXdata[3] + RXdata[4];
    if(value > 32767){value = value - 65536; }
    value = value / 10.0;
    if(checksum != RXdata[5])
    {
      value = 0;
    }
  }  
  return value;
}

