#!/bin/bash
set -ex

# 显示帮助信息
usage() {
    echo "用法: \$0"
    echo "功能: 删除指定文件和文件夹,并创建压缩包"
}

# 如果传入了参数,则显示帮助信息并退出
if [ $# -ne 0 ]; then
    usage
    exit 1
fi

# 获取当前.sh文件所在目录
current_folder="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

# 进入当前目录
cd "$current_folder" || exit

# 获取当前日期,比如:20230324
date_var=$(date +"%Y%m%d")

# 获取目录名称
dir_name=$(basename "$current_folder")

# 设置压缩包名称
zip_file_name="$dir_name"_"$date_var".zip










# 删除文件夹名称符合数字10以上的所有文件夹
find . -type d -name '[1-9][0-9]*.*' -exec rm -rf {} +

# 删除指定的文件夹和以"!"开头的文件夹和文件
find . \( -name ".output" -o -name ".vscode" -o -name ".git" -o -name "!*" -o -name ".gitlab-ci.yml" \) -exec rm -rf {} +

# 删除其他指定后缀的文件（.gitignore, .gitmodules, .bat, .sh, .git, .clang-format）
find . \( -name "*.gitignore" -o -name "*.gitmodules" -o -name "*.bat" -o -name "*.sh" -o -name ".git" -o -name ".clang-format" \) -exec rm -f {} +

# 创建压缩包
zip -r "$zip_file_name" .

# 结束脚本
exit 0
