/**
 * *************************************************************************************************************
 * @file PTM.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for PTM firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _PTM_H_
#define _PTM_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH66F2475.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! timer Counter Clock selection enum */
typedef enum {
    PTM_CLOCK_FSYS_4   = (0x00 << 4),
    PTM_CLOCK_FSYS     = (0x01 << 4),
    PTM_CLOCK_FH_16    = (0x02 << 4),
    PTM_CLOCK_FH_64    = (0x03 << 4),
    PTM_CLOCK_FSUB     = (0x04 << 4),
    PTM_CLOCK_PIN_RISE = (0x06 << 4),
    PTM_CLOCK_PIN_FALL = (0x07 << 4),
} PTM_Clock_e;

/*! PTM count clear mode enum */
typedef enum {
    PTM_COUNT_CLEAR_P_MATCH,
    PTM_COUNT_CLEAR_A_MATCH,
} PTM_CountClear_e;

/*! compare match output mode enum */
typedef enum {
    PTM_COMPAREMATCH_KEEP_L               = (0x00 << 3),
    PTM_COMPAREMATCH_KEEP_H               = (0x01 << 3),
    PTM_COMPAREMATCH_INIT_H_OUTPUT_L      = (0x03 << 3),
    PTM_COMPAREMATCH_INIT_L_OUTPUT_H      = (0x04 << 3),
    PTM_COMPAREMATCH_INIT_L_OUTPUT_TOGGLE = (0x06 << 3),
    PTM_COMPAREMATCH_INIT_H_OUTPUT_TOGGLE = (0x07 << 3),
} PTM_CompareMatch_Output_e;

/*! compare match output configuration */
typedef struct {
    uint8_t clockSource;    //!< RW @see PTM_Clock_e
    uint8_t outputMode;     //!< RW @see PTM_CompareMatch_Output_e
    uint8_t countClear;     //!< RW @see PTM_CountClear_e
    bool pinInvert;
    uint16_t count;
} PTM_Cfg_CompareMatchOutputMode_t;

/*! Capture Input Mode output mode enum */
typedef enum {
    PTM_CAPTURE_EDGE_RISE    = (0x00 << 4),
    PTM_CAPTURE_EDGE_FALL    = (0x01 << 4),
    PTM_CAPTURE_EDGE_DUAL    = (0x02 << 4),
    PTM_CAPTURE_EDGE_DISABLE = (0x03 << 4),
} PTM_CaptureInput_Edge_e;

/*! Capture Input Mode Trigger Pin */
typedef enum {
    PTM_CAPTURE_PIN_PTPI = (0x00 << 1),
    PTM_CAPTURE_PIN_PTCK = (0x01 << 1),
} PTM_CaptureInput_Pin_e;

/*! Capture input configuration */
typedef struct {
    uint8_t clockSource;    //!< RW @see PTM_Clock_e
    uint8_t inputEdge;      //!< RW @see PTM_CaptureInput_Edge_e
    uint8_t inputPin;       //!< RW @see PTM_CaptureInput_Pin_e
    uint16_t maxCount;
} PTM_Cfg_CaptureInput_t;

/*! pwm output mode enum */
typedef enum {
    PTM_PWM_OUTPUT_KEEP_H       = (0x00 << 3),
    PTM_PWM_OUTPUT_KEEP_L       = (0x01 << 3),
    PTM_PWM_OUTPUT_PWM_ACTIVE_L = (0x04 << 3),
    PTM_PWM_OUTPUT_PWM_ACTIVE_H = (0x05 << 3),
} PTM_PWM_Output_e;

/*! PWM output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see PTM_Clock_e
    uint8_t outputMode;     //!< R/W @see PTM_PWM_Output_e
    bool pinInvert;
    uint16_t ccraData;
    uint16_t ccrpData;
} PTM_Cfg_PWM_t;

/*! Single pulse output enum */
typedef enum {
    PTM_SINGLE_PULSE_OUTPUT_ACTIVE_L = (0x06 << 3),
    PTM_SINGLE_PULSE_OUTPUT_ACTIVE_H = (0x07 << 3),
} PTM_SinglePulseOutput_e;

/*! Single pulse output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see PTM_Clock_e
    uint8_t outputMode;     //!< R/W @see PTM_SinglePulseOutput_e
    bool pinInvert;
    uint16_t ccraData;
} PTM_Cfg_SinglePulseOutput_t;

/*! TimerCount configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see PTM_Clock_e
    uint8_t countClear;     //!< R/W @see PTM_CountClear_e
    uint16_t count;
} PTM_Cfg_TimerCounter_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void PTM_Cfg_CompareMatchOutput(PTM_Cfg_CompareMatchOutputMode_t *cfg);
void PTM_Cfg_SinglePulseOutput(PTM_Cfg_SinglePulseOutput_t *cfg);
void PTM_Cfg_CaptureInput(PTM_Cfg_CaptureInput_t *cfg);
void PTM_Cfg_TimerCounter(PTM_Cfg_TimerCounter_t *cfg);
void PTM_Cfg_PWM(PTM_Cfg_PWM_t *cfg);
#define PTM_Enable()           { _ptpau = 0;  _pton = 1;}
#define PTM_Disable()          { _pton = 0;}
#define PTMA_Isr_Enable()      { _ptmaf = 0; _ptmae =1; _mf1e = 1;}
#define PTMA_Isr_Disable()     { _ptmae = 0;}
#define PTMP_Isr_Enable()      { _ptmpf = 0; _ptmpe =1; _mf1e  = 1;}
#define PTMP_Isr_Disable()     { _ptmpe = 0;}

// clang-format on
#endif