/**
 * *************************************************************************************************************
 * @file Afe.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Afe firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Afe.h"
#include "AfePower.h"
#include "..\board\BoardCfg.h"

// clang-format off
#define Timing_Period_Cfg(t)    { _prfc = t;}    //!< period = 0.5S*(p + 1)
#define Timing_Opa_Cfg(startDelay, work)    { _topst = startDelay; _toplen = work;}
#define Timing_Dac_Cfg(startDelay, work)    { _tdast = startDelay; _tdalen = work;}
#define Timing_Cmp_Cfg(startDelay, work)    { _tcpst = startDelay; _tcplen = work;}
#define Timing_Power_Cfg(timingControl)     { _tchs0 = timingControl & 0xFF; _tchs1 = (timingControl >> 8);}   //!< @see timing_Cfg_t

#define OPAn_Enable(n)          { _opa##n##en = 1; _gsop##n##p = 1;}
#define OPAn_Disable(n)         { _opa##n##en = 0; _gsop##n##p = 0;}

// clang-format on

void Timing_Cfg(timing_Cfg_t *Cfg, AfeCircuit_t *afeCircuit)
{
    Timing_Opa_Cfg(Cfg->opaStartDelay, Cfg->opaWork);
    Timing_Dac_Cfg(Cfg->dacStartDelay, Cfg->dacWork);
    Timing_Cmp_Cfg(Cfg->cmpStartDelay, Cfg->cmpWork);
    Timing_Power_Cfg(Cfg->flag.byte);
    Timing_Period_Cfg(Cfg->period);

    Dac0_Cfg(afeCircuit->dac0Data);
    Dac1_Cfg(afeCircuit->dac1Data);
    Dac2_Cfg(afeCircuit->dac2Data);
    Dac3_Cfg(afeCircuit->dac3Data);

    if (_tcpen)
    {
        _cmpc    = afeCircuit->cmpPselect;
        _gscmpn0 = 1;
    }
    if (_top3en)
    {
        _gsop3p = 1;
    }
    else
    {
        _gsop3p = 0;
    }
    if (_top2en)
    {
        _gsop2p = 1;
    }
    else
    {
        _gsop2p = 0;
    }
    if (_top1en)
    {
        _gsop1p = 1;
    }
    else
    {
        _gsop1p = 0;
    }
}

void TwoElAfeCfg(uint8_t VirefData, uint16_t Dac1OData)
{
    // config VOREG_BYPASS
    Voreg_Cfg(VOREG_BYPASS);
    // Voreg_Enable();
    // Viref
    Dac_vref_Cfg(DAC_REF_VIREF);
    Viref_Cfg(VirefData);    // Calibration voreg, adjusted for different IC needs
    Viref_Enable();
    // DAC
    Dac1_Cfg(Dac1OData);    // default
    Dac1_Enable();
    // OPA
    OPAn_Enable(1);
}

void ThirdElAfeCfg(uint8_t VirefData, uint16_t Dac1OData, uint16_t Dac2OData)
{
    // config AfePower
    Voreg_Cfg(VOREG_BYPASS);
    // Voreg_Enable();
    // Voreg_Disable();
    // Viref
    Dac_vref_Cfg(DAC_REF_VIREF);
    Viref_Cfg(VirefData);    // Calibration voreg, adjusted for different IC needs
    Viref_Enable();
    // DAC
    Dac1_Cfg(Dac1OData);
    Dac1_Enable();
    Dac2_Cfg(Dac2OData);
    Dac2_Enable();
    // OPA
    OPAn_Enable(1);
    OPAn_Enable(2);
}

void FourElAfeCfg(uint8_t VirefData, uint16_t Dac1OData, uint16_t Dac2OData, uint16_t Dac3OData)
{
    // config AfePower
    Voreg_Cfg(VOREG_BYPASS);
    // Voreg_Enable();
    // Voreg_Disable();
    // Viref
    Dac_vref_Cfg(DAC_REF_VIREF);
    Viref_Cfg(VirefData);    // Calibration voreg, adjusted for different IC needs
    Viref_Enable();
    // DAC
    Dac1_Cfg(Dac1OData);
    Dac1_Enable();
    Dac2_Cfg(Dac2OData);
    Dac2_Enable();
    Dac3_Cfg(Dac3OData);
    Dac3_Enable();
    // OPA
    OPAn_Enable(1);
    OPAn_Enable(2);
    OPAn_Enable(3);
}

void Disable_AFE()
{
    Voreg_Disable();
    Viref_Disable();
    Dac1_Disable();
    Dac2_Disable();
    OPAn_Disable(1);
    OPAn_Disable(2);
}