/**
 * *************************************************************************************************************
 * @file AfePower.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for AfePower firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.1

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _AFEPOWER_H_
#define _AFEPOWER_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BH66F2475.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! Voreg output voltage selection */
typedef enum {
    VOREG_2V4    = 0x00,    //!< 2.4V
    VOREG_2V6    = 0x01,    //!< 2.6V
    VOREG_2V2    = 0x02,    //!< 2.2V
    VOREG_2V3    = 0x03,    //!< 2.3V
    VOREG_BYPASS = 0x44,    //!< bypass with Avdd
} Voreg_Cfg_e;

/*! Dac reference voltage enum */
typedef enum {
    DAC_REF_VIREF = 0x00,
    DAC_REF_AVDD  = 0x02,
    DAC_REF_HZ    = 0x03
} Dac_RefVoltage_e;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
#define Voreg_Cfg(type)   { _pwrc = type;} //!< @see Voreg_Cfg_e
#define Voreg_Enable()    { _ldoen = 1;}
#define Voreg_Disable()   { _ldoen = 0;}

#define Viref_Cfg(x)         { _pvref = x;} //!< x 0~255
#define Viref_Enable()       { _irefen = 1;}
#define Viref_Disable()      { _irefen = 0;}

#define Dac_vref_Cfg(type)  { _irefc &= 0xFC; _irefc |= type;}; //!< Dac_RefVoltage_e

#define Dac0_Cfg(x)     { _afeda0l = (x << 4) & 0xFF; _afeda0h = x >> 4;}
#define Dac0_Enable()   { _afeda0c = 0x01;}
#define Dac0_Disable()  { _afeda0c = 0x00;}
#define Dac0_GND()      { _afeda0c = 0x10;}

#define Dac1_Cfg(x)     { _afeda1l = (x << 4) & 0xFF; _afeda1h = x >> 4;}
#define Dac1_Enable()   { _afeda1c = 0x01;}
#define Dac1_Disable()  { _afeda1c = 0x00;}
#define Dac1_GND()      { _afeda1c = 0x10;}

#define Dac2_Cfg(x)     { _afeda2l = (x << 4) & 0xFF; _afeda2h = x >> 4;}
#define Dac2_Enable()   { _afeda2c = 0x01;}
#define Dac2_Disable()  { _afeda2c = 0x00;}
#define Dac2_GND()      { _afeda2c = 0x10;}

#define Dac3_Cfg(x)     { _afeda3l = (x << 4) & 0xFF; _afeda3h = x >> 4;}
#define Dac3_Enable()   { _afeda3c = 0x01;}
#define Dac3_Disable()  { _afeda3c = 0x00;}
#define Dac3_GND()      { _afeda3c = 0x10;}

// clang-format on
#endif