/**
 * *************************************************************************************************************
 * @file Afe.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Afe firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _AFE_H_
#define _AFE_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH66F2475.h"

/* Exported types ------------------------------------------------------------------------------------------*/
typedef struct {
    uint8_t period;    //!< period = 0.5S*(p + 1)
    uint8_t opaStartDelay;
    uint8_t opaWork;
    uint8_t dacStartDelay;
    uint8_t dacWork;
    uint8_t cmpStartDelay;
    uint8_t cmpWork;

    union {
        struct {
            uint16_t opa1Enable    : 1;    //!< R/W 是否加入 timeing control
            uint16_t opa2Enable    : 1;    //!< R/W 是否加入 timeing control
            uint16_t opa3Enable    : 1;    //!< R/W 是否加入 timeing control
            uint16_t dac0Enable    : 1;    //!< R/W 是否加入 timeing control
            uint16_t dac1Enable    : 1;    //!< R/W 是否加入 timeing control
            uint16_t dac2Enable    : 1;    //!< R/W 是否加入 timeing control
            uint16_t dac3Enable    : 1;    //!< R/W 是否加入 timeing control
            uint16_t cmpEnable     : 1;    //!< R/W 是否加入 timeing control
            uint16_t dacvrefEnable : 1;    //!< R/W 是否加入 timeing control
        } b;

        uint16_t byte;
    } flag;
} timing_Cfg_t;

typedef struct {
    uint8_t cmpPselect;    //!< 0: op1o 1:op2o 2:op3o
    uint16_t dac0Data;
    uint16_t dac1Data;
    uint16_t dac2Data;
    uint16_t dac3Data;
} AfeCircuit_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void Timing_Cfg(timing_Cfg_t *Cfg, AfeCircuit_t *afeCircuit);
#define Timing_Enable()         { _tctren = 1;}
#define Timing_Disable()        { _tctren = 0;}
// clang-format on
void TwoElAfeCfg(uint8_t VirefData, uint16_t Dac1OData);
void ThirdElAfeCfg(uint8_t VirefData, uint16_t Dac1OData, uint16_t Dac2OData);
void FourElAfeCfg(uint8_t VirefData, uint16_t Dac1OData, uint16_t Dac2OData, uint16_t Dac3OData);
void Disable_AFE();

#endif