/**
 * *************************************************************************************************************
 * @file Spi.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Spi firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _SPI_H_
#define _SPI_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "BH66F2475.h"

/** @defgroup SPI
 * @{
 */

/* Exported types ----------------------------------------------------------------------------------------*/
/**
 * @brief Spi operating mode Selection enum
 *
 */
typedef enum {
    SPI_MASTER_FSYS_4  = (0x00 << 5),    //*!<  master mode: clock is fsys/4
    SPI_MASTER_FSYS_16 = (0x01 << 5),    //*!<  master mode: clock is fsys/16
    SPI_MASTER_FSYS_64 = (0x02 << 5),    //*!<  master mode: clock is fsys/64
    SPI_MASTER_FSUB    = (0x03 << 5),    //*!<  master mode: clock is fsub
    SPI_SLAVE          = (0x05 << 5),    //*!<  slave mode
} Spi_Mode_e;

/**
 * @brief sck active edge type selection Selection enum
 *
 */
typedef enum {
    SPI_SCK_HIGH_RISING  = (0x00 << 4),    //*!<  Spi sck has high base level with data capture on Spi sck rising edge
    SPI_SCK_HIGH_FALLING = (0x01 << 4),    //*!<  Spi sck has high base level with data capture on Spi sck falling edge
    SPI_SCK_LOW_FALLING  = (0x02 << 4),    //*!<  Spi sck has low base level with data capture on Spi sck falling edge
    SPI_SCK_LOW_RISING   = (0x03 << 4),    //*!<  Spi sck has low base level with data capture on Spi sck rising edge
} Spi_SckEdge_e;

/**
 * @brief SPI data shift order Selection enum
 *
 */
typedef enum {
    SPI_LSB = (0x00 << 3),    //*!<  Spi LSB first
    SPI_MSB = (0x01 << 3),    //*!<  Spi MSB first
} Spi_DataShift_e;

/**
 * @brief SPI data shift order Selection enum
 *
 */
typedef enum {
    SPI_CSEN_DISABLE = (0x00 << 2),
    SPI_CSEN_ENABLE  = (0x01 << 2),
} Spi_Csen_e;

/**
 * @brief Spi cfg structure definition
 *
 */
typedef struct {
    uint8_t mode;         //*!< @ref Spi_Mode_e
    uint8_t sck_edge;     //*!< @ref Spi_SckEdge_e
    uint8_t dataShift;    //*!< @ref Spi_DataShift_e
    uint8_t csen;         //*!< @ref Spi_Csen_e
} Spi_Cfg_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void Spi_Cfg(const Spi_Cfg_t *cfg);
#define Spi_Enable()      { _simen = 1;}
#define Spi_Disable()     { _simen = 0;}
#define Spi_Isr_Enable()  { _sime = 1;}
#define Spi_Isr_Disable() { _sime = 0;}
uint8_t Spi_TxRxByte(uint8_t txData);
#define Spi_IsHaveData    _trf == 1

// clang-format on
/**
 * @}
 */

#endif