/**
 * *************************************************************************************************************
 * @file Adc24.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Adc24 firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "stdbool.h"
#include "Adc24.h"
#include "AfePower.h"
#include "..\application\Iap_Isp.h"

#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 4000000    //!< 設置系統頻率，目前支援設置為 4000000,8000000,12000000
#endif
    
// clang-format off
#define SET_ADC_ENABLE()			{ _sincen = 1; _moden = 1; _modrst = 0; _modrst = 1; _modrst = 0;}
#define SET_ADC_DISABLE()			{ _sincen = 0; _moden = 0; _pgaen = 0;}
#define SET_ADC_START_CONVERT()		{ _adrst = 0; _adrst = 1; _adrst = 0; _adcdl = 0; _eoc = 0; }
#define SET_ADC_INPUT_SHORT(x)    	{ _inis = x;}

#if SYS_CLOCK_FREQ == 4000000    
//!< fmclk = 4000000
//!< SINC2 DataRate = FMCLK/(OSR*N*2)
#define SET_ADC_DATA_RATE2_5HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 5.09Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_RATE2_10HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_RATE2_20HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_RATE2_41HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_RATE2_81HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_RATE2_163HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_RATE2_326HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=512)
#define SET_ADC_DATA_RATE2_651HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=256)
#define SET_ADC_DATA_RATE2_1302HZ()  { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 1302.08Hz：(N=12, OSR=128)

#define SET_ADC_DATA_RATE2_2HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 2.03Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_RATE2_4HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_RATE2_8HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_RATE2_16HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_RATE2_33HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_RATE2_65HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_RATE2_130HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=512)
#define SET_ADC_DATA_RATE2_260HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=256)
#define SET_ADC_DATA_RATE2_521HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 520.83Hz：(N=30, OSR=128)

//!< SINC3 DataRate = FMCLK/(OSR*N)
#define SET_ADC_DATA_RATE3_10HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_RATE3_20HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_RATE3_41HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_RATE3_81HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_RATE3_163HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_RATE3_326HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_RATE3_651HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=512)
#define SET_ADC_DATA_RATE3_1302HZ()  { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 1302.08Hz：(N=12, OSR=256)
#define SET_ADC_DATA_RATE3_2604HZ()  { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 2604.17Hz：(N=12, OSR=128)

#define SET_ADC_DATA_RATE3_4HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_RATE3_8HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_RATE3_16HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_RATE3_33HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_RATE3_65HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_RATE3_130HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_RATE3_260HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=512)
#define SET_ADC_DATA_RATE3_521HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 520.83Hz：(N=30, OSR=256)
#define SET_ADC_DATA_RATE3_1042HZ()  { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 1041.67Hz：(N=30, OSR=128)

#endif
#if SYS_CLOCK_FREQ == 8000000    
//!< fmclk = 4000000
//!< SINC2 DataRate = FMCLK/(OSR*N*2)
#define SET_ADC_DATA_RATE2_5HZ()     { _adcs=0x00; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 5.09Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_RATE2_10HZ()    { _adcs=0x00; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_RATE2_20HZ()    { _adcs=0x00; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_RATE2_41HZ()    { _adcs=0x00; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_RATE2_81HZ()    { _adcs=0x00; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_RATE2_163HZ()   { _adcs=0x00; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_RATE2_326HZ()   { _adcs=0x00; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=512)
#define SET_ADC_DATA_RATE2_651HZ()   { _adcs=0x00; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=256)
#define SET_ADC_DATA_RATE2_1302HZ()  { _adcs=0x00; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 1302.08Hz：(N=12, OSR=128)

#define SET_ADC_DATA_RATE2_2HZ()     { _adcs=0x00; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 2.03Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_RATE2_4HZ()     { _adcs=0x00; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_RATE2_8HZ()     { _adcs=0x00; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_RATE2_16HZ()    { _adcs=0x00; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_RATE2_33HZ()    { _adcs=0x00; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_RATE2_65HZ()    { _adcs=0x00; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_RATE2_130HZ()   { _adcs=0x00; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=512)
#define SET_ADC_DATA_RATE2_260HZ()   { _adcs=0x00; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=256)
#define SET_ADC_DATA_RATE2_521HZ()   { _adcs=0x00; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 520.83Hz：(N=30, OSR=128)

//!< SINC3 DataRate = FMCLK/(OSR*N)
#define SET_ADC_DATA_RATE3_10HZ()    { _adcs=0x00; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_RATE3_20HZ()    { _adcs=0x00; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_RATE3_41HZ()    { _adcs=0x00; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_RATE3_81HZ()    { _adcs=0x00; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_RATE3_163HZ()   { _adcs=0x00; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_RATE3_326HZ()   { _adcs=0x00; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_RATE3_651HZ()   { _adcs=0x00; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=512)
#define SET_ADC_DATA_RATE3_1302HZ()  { _adcs=0x00; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 1302.08Hz：(N=12, OSR=256)
#define SET_ADC_DATA_RATE3_2604HZ()  { _adcs=0x00; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 2604.17Hz：(N=12, OSR=128)

#define SET_ADC_DATA_RATE3_4HZ()     { _adcs=0x00; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_RATE3_8HZ()     { _adcs=0x00; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_RATE3_16HZ()    { _adcs=0x00; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_RATE3_33HZ()    { _adcs=0x00; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_RATE3_65HZ()    { _adcs=0x00; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_RATE3_130HZ()   { _adcs=0x00; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_RATE3_260HZ()   { _adcs=0x00; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=512)
#define SET_ADC_DATA_RATE3_521HZ()   { _adcs=0x00; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 520.83Hz：(N=30, OSR=256)
#define SET_ADC_DATA_RATE3_1042HZ()  { _adcs=0x00; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 1041.67Hz：(N=30, OSR=128)

#endif
#if SYS_CLOCK_FREQ == 12000000    
//!< fmclk = 2000000
//!< SINC2 DataRate = FMCLK/(OSR*N*2)
#define SET_ADC_DATA_RATE2_3HZ()     { _adcs=0x02; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 2.54Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_RATE2_5HZ()     { _adcs=0x02; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 5.09Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_RATE2_10HZ()    { _adcs=0x02; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_RATE2_20HZ()    { _adcs=0x02; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_RATE2_41HZ()    { _adcs=0x02; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_RATE2_81HZ()    { _adcs=0x02; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_RATE2_163HZ()   { _adcs=0x02; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=512)
#define SET_ADC_DATA_RATE2_326HZ()   { _adcs=0x02; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=256)
#define SET_ADC_DATA_RATE2_651HZ()   { _adcs=0x02; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=128)

#define SET_ADC_DATA_RATE2_1HZ()     { _adcs=0x02; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 1.02Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_RATE2_2HZ()     { _adcs=0x02; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 2.03Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_RATE2_4HZ()     { _adcs=0x02; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_RATE2_8HZ()     { _adcs=0x02; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_RATE2_16HZ()    { _adcs=0x02; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_RATE2_33HZ()    { _adcs=0x02; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_RATE2_65HZ()    { _adcs=0x02; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=512)
#define SET_ADC_DATA_RATE2_130HZ()   { _adcs=0x02; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=256)
#define SET_ADC_DATA_RATE2_260HZ()   { _adcs=0x02; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=128)

//!< SINC3 DataRate = FMCLK/(OSR*N)
#define SET_ADC_DATA_RATE3_5HZ()     { _adcs=0x02; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 5.09Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_RATE3_10HZ()    { _adcs=0x02; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_RATE3_20HZ()    { _adcs=0x02; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_RATE3_41HZ()    { _adcs=0x02; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_RATE3_81HZ()    { _adcs=0x02; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_RATE3_163HZ()   { _adcs=0x02; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_RATE3_326HZ()   { _adcs=0x02; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=512)
#define SET_ADC_DATA_RATE3_651HZ()   { _adcs=0x02; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=256)
#define SET_ADC_DATA_RATE3_1302HZ()  { _adcs=0x02; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 1302.08Hz：(N=12, OSR=128)

#define SET_ADC_DATA_RATE3_2HZ()     { _adcs=0x02; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 2.03Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_RATE3_4HZ()     { _adcs=0x02; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_RATE3_8HZ()     { _adcs=0x02; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_RATE3_16HZ()    { _adcs=0x02; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_RATE3_33HZ()    { _adcs=0x02; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_RATE3_65HZ()    { _adcs=0x02; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_RATE3_130HZ()   { _adcs=0x02; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=512)
#define SET_ADC_DATA_RATE3_260HZ()   { _adcs=0x02; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=256)
#define SET_ADC_DATA_RATE3_521HZ()   { _adcs=0x02; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 520.83Hz：(N=30, OSR=128)

#endif

// clang-format on
volatile Adc24_Source_t adc24SourceData;

/**
 * @brief config adc sampleRate, gain, dcset, channel
 *
 * @param adcCfg @see AdcCfg_t
 */
void Adc24_Cfg(Adc24_Cfg_t *cfg)
{
    switch (cfg->sampleRate)
    {
        // case ADC24_RATE_4HZ: SET_ADC_DATA_RATE3_4HZ(); break;
        // case ADC24_RATE_8HZ: SET_ADC_DATA_RATE3_8HZ(); break;
        // case ADC24_RATE_10HZ: SET_ADC_DATA_RATE3_10HZ(); break;
        // case ADC24_RATE_16HZ: SET_ADC_DATA_RATE3_16HZ(); break;
        // case ADC24_RATE_20HZ: SET_ADC_DATA_RATE3_20HZ(); break;
        // case ADC24_RATE_33HZ: SET_ADC_DATA_RATE3_33HZ(); break;
        // case ADC24_RATE_41HZ: SET_ADC_DATA_RATE3_41HZ(); break;
        // case ADC24_RATE_65HZ: SET_ADC_DATA_RATE3_65HZ(); break;
        // case ADC24_RATE_81HZ: SET_ADC_DATA_RATE3_81HZ(); break;
        // case ADC24_RATE_130HZ: SET_ADC_DATA_RATE3_130HZ(); break;
        // case ADC24_RATE_163HZ: SET_ADC_DATA_RATE3_163HZ(); break;
        // case ADC24_RATE_260HZ: SET_ADC_DATA_RATE3_260HZ(); break;
        // case ADC24_RATE_326HZ: SET_ADC_DATA_RATE3_326HZ(); break;
#if (SYS_CLOCK_FREQ == 4000000 || SYS_CLOCK_FREQ == 8000000)
        // case ADC24_RATE_521HZ: SET_ADC_DATA_RATE3_521HZ(); break;
#endif
        // case ADC24_RATE_651HZ: SET_ADC_DATA_RATE3_651HZ(); break;
#if (SYS_CLOCK_FREQ == 4000000 || SYS_CLOCK_FREQ == 8000000)
        // case ADC24_RATE_1302HZ: SET_ADC_DATA_RATE3_1302HZ(); break;
#endif
        case ADC24_RATE_4HZ: SET_ADC_DATA_RATE2_4HZ(); break;
        case ADC24_RATE_8HZ: SET_ADC_DATA_RATE2_8HZ(); break;
        case ADC24_RATE_10HZ: SET_ADC_DATA_RATE2_10HZ(); break;
        case ADC24_RATE_16HZ: SET_ADC_DATA_RATE2_16HZ(); break;
        case ADC24_RATE_20HZ: SET_ADC_DATA_RATE2_20HZ(); break;
        case ADC24_RATE_33HZ: SET_ADC_DATA_RATE2_33HZ(); break;
        case ADC24_RATE_41HZ: SET_ADC_DATA_RATE2_41HZ(); break;
        case ADC24_RATE_65HZ: SET_ADC_DATA_RATE2_65HZ(); break;
        case ADC24_RATE_81HZ: SET_ADC_DATA_RATE2_81HZ(); break;
        case ADC24_RATE_130HZ: SET_ADC_DATA_RATE2_130HZ(); break;
        case ADC24_RATE_163HZ: SET_ADC_DATA_RATE2_163HZ(); break;
        case ADC24_RATE_260HZ: SET_ADC_DATA_RATE2_260HZ(); break;
        case ADC24_RATE_326HZ: SET_ADC_DATA_RATE2_326HZ(); break;
        case ADC24_RATE_521HZ: SET_ADC_DATA_RATE2_521HZ(); break;
        case ADC24_RATE_651HZ: SET_ADC_DATA_RATE2_651HZ(); break;
        case ADC24_RATE_1302HZ: SET_ADC_DATA_RATE2_1302HZ(); break;
        default:
            break;
    }
    // adc gain configuration
    _pgac0 = cfg->gain;
    if (cfg->gain == ADC24_REFx1_GAINx1BYPASS)
    {
        _pgabps = 1;
        _pgaen  = 0;
    }
    else
    {
        _pgabps = 0;
        _pgaen  = 1;
    }
    // adc channel
    _pgacs = cfg->channel;

    _vdetecten = 0;
    if (_pgacs == ADC24_CHP_AVDD5_N_AVDD6)
    {
        _vdetecten = 1;
    }
    // adc reference
    _pgac0 += cfg->refVoltage;
    // others
    _adcr3 = 0x71;
}

/**
 * @brief adc convert start
 */
void Adc24_Enable()
{
    // SET_ADC_INPUT_SHORT(true);
    SET_ADC_ENABLE();
    SET_ADC_START_CONVERT();
    adc24SourceData.samplingCnt    = 0;
    adc24SourceData.flag.b.isReady = 0;
}

/**
 * @brief adc convert stop
 */
void Adc24_Disable()
{
    adc24SourceData.flag.b.isReady = 0;
    adc24SourceData.samplingCnt    = 0;
    SET_ADC_DISABLE();
}

void Adc24_Poling()
{
    if (_eoc == 1)
    {
        // ADC 轉換完成
        adc24SourceData.samplingCnt++;
        // 前三筆數據丟掉，第四筆才開始處理
        if (adc24SourceData.samplingCnt > 3)
        {
            // Read current ADC
            _adcdl                             = 1;
            adc24SourceData.data.byte.byteLow  = 0x00;
            adc24SourceData.data.byte.byteMid  = _adrl;
            adc24SourceData.data.byte.byteHigh = _adrm;
            adc24SourceData.data.byte.byteRes  = _adrh;
            _adcdl                             = 0;    // 數據讀取完成，取消鎖存
            adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
            adc24SourceData.flag.b.isReady     = 1;
        }
        _eoc = 0;
    }
}

//@------------ADC 中斷入口函數---------------@
#ifdef SUPPORT_ISP
 __attribute__((interrupt(0x0C),reg_acc(0x82), isr_at(PROM_AP_ADDRESS_START+0x0C)))
void ADC_ISR_Routine()
#else
DEFINE_ISR(ADC_ISR, 0x0C)
#endif
{
    if (_eoc == 1)
    {
        // ADC 轉換完成
        adc24SourceData.samplingCnt++;
        // 前三筆數據丟掉，第四筆才開始處理
        if (adc24SourceData.samplingCnt > 3)
        {
            // Read current ADC
            _adcdl                             = 1;
            adc24SourceData.data.byte.byteLow  = 0x00;
            adc24SourceData.data.byte.byteMid  = _adrl;
            adc24SourceData.data.byte.byteHigh = _adrm;
            adc24SourceData.data.byte.byteRes  = _adrh;
            _adcdl                             = 0;    // 數據讀取完成，取消鎖存
            adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
            adc24SourceData.flag.b.isReady     = 1;
        }
        _eoc = 0;
    }
}